/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.fn;

import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.dm.FileObject;
import com.scudata.dm.HttpFile;
import com.scudata.expression.Expression;
import com.scudata.expression.Function;
import com.scudata.expression.IParam;
import com.scudata.expression.Node;
import com.scudata.expression.ParamInfo2;
import com.scudata.resources.EngineMessage;

public class CreateHttpFile
extends Function {
    public byte calcExpValueType(Context ctx) {
        return 2;
    }

    public Node optimize(Context ctx) {
        if (this.param != null) {
            this.param.optimize(ctx);
        }
        return this;
    }

    public Object calculate(Context ctx) {
        String pathName;
        IParam postParam;
        IParam urlParam;
        IParam param = this.param;
        IParam headerParam = null;
        if (param == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("httpfile" + mm.getMessage("function.missingParam"));
        }
        if (param.getType() == ';') {
            if (param.getSubSize() != 2) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("httpfile" + mm.getMessage("function.invalidParam"));
            }
            headerParam = param.getSub(1);
            if ((param = param.getSub(0)) == null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("httpfile" + mm.getMessage("function.invalidParam"));
            }
        }
        String type = null;
        if (param.getType() == ',') {
            IParam typeParam;
            int size = param.getSubSize();
            if (size > 3) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("httpfile" + mm.getMessage("function.invalidParam"));
            }
            urlParam = param.getSub(0);
            if (urlParam == null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("httpfile" + mm.getMessage("function.invalidParam"));
            }
            postParam = param.getSub(1);
            if (size > 2 && (typeParam = param.getSub(2)) != null) {
                Object obj = typeParam.getLeafExpression().calculate(ctx);
                if (obj instanceof String) {
                    type = (String)obj;
                } else if (obj != null) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("httpfile" + mm.getMessage("function.paramTypeError"));
                }
            }
        } else {
            if (param.getType() == ';') {
                MessageManager mm = EngineMessage.get();
                throw new RQException("httpfile" + mm.getMessage("function.invalidParam"));
            }
            urlParam = param;
            postParam = null;
        }
        String cs = null;
        if (urlParam.isLeaf()) {
            Object pathObj = urlParam.getLeafExpression().calculate(ctx);
            if (!(pathObj instanceof String)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("httpfile" + mm.getMessage("function.paramTypeError"));
            }
            pathName = (String)pathObj;
        } else {
            if (urlParam.getSubSize() != 2) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("httpfile" + mm.getMessage("function.invalidParam"));
            }
            IParam sub0 = urlParam.getSub(0);
            if (sub0 == null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("httpfile" + mm.getMessage("function.invalidParam"));
            }
            Object pathObj = sub0.getLeafExpression().calculate(ctx);
            if (!(pathObj instanceof String)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("httpfile" + mm.getMessage("function.paramTypeError"));
            }
            pathName = (String)pathObj;
            IParam sub1 = urlParam.getSub(1);
            if (sub1 != null) {
                Object csObj = sub1.getLeafExpression().calculate(ctx);
                if (!(csObj instanceof String)) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("httpfile" + mm.getMessage("function.paramTypeError"));
                }
                cs = (String)csObj;
            }
        }
        String prefix = "http://";
        if (!pathName.startsWith("http://") && !pathName.startsWith("https://")) {
            pathName = "http://" + pathName;
        }
        HttpFile file = new HttpFile(pathName);
        if (type != null) {
            file.setRequestContentType(type);
        }
        if (postParam != null) {
            String post = null;
            String pcs = null;
            String method = null;
            if (postParam.isLeaf()) {
                Object obj = postParam.getLeafExpression().calculate(ctx);
                if (!(obj instanceof String)) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("httpfile" + mm.getMessage("function.paramTypeError"));
                }
                post = (String)obj;
            } else {
                IParam sub2;
                IParam sub1;
                if (postParam.getSubSize() > 3) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("httpfile" + mm.getMessage("function.invalidParam"));
                }
                IParam sub0 = postParam.getSub(0);
                if (sub0 != null) {
                    Object obj = sub0.getLeafExpression().calculate(ctx);
                    if (!(obj instanceof String)) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException("httpfile" + mm.getMessage("function.paramTypeError"));
                    }
                    post = (String)obj;
                }
                if ((sub1 = postParam.getSub(1)) != null) {
                    Object csObj = sub1.getLeafExpression().calculate(ctx);
                    if (!(csObj instanceof String)) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException("httpfile" + mm.getMessage("function.paramTypeError"));
                    }
                    pcs = (String)csObj;
                }
                if (postParam.getSubSize() == 3 && (sub2 = postParam.getSub(2)) != null) {
                    Object mObj = sub2.getLeafExpression().calculate(ctx);
                    if (!(mObj instanceof String)) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException("httpfile" + mm.getMessage("function.paramTypeError"));
                    }
                    method = (String)mObj;
                }
            }
            file.setPostParams(post, pcs, method);
        }
        if (headerParam != null) {
            ParamInfo2 pi2 = ParamInfo2.parse(headerParam, "httpfile", true, true);
            Expression[] exps1 = pi2.getExpressions1();
            Expression[] exps2 = pi2.getExpressions2();
            int count = exps1.length;
            for (int i = 0; i < count; ++i) {
                Object obj1 = exps1[i].calculate(ctx);
                if (!(obj1 instanceof String)) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("httpfile" + mm.getMessage("function.paramTypeError"));
                }
                Object obj2 = exps2[i].calculate(ctx);
                if (!(obj2 instanceof String)) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("httpfile" + mm.getMessage("function.paramTypeError"));
                }
                file.addRequestHeader((String)obj1, (String)obj2);
            }
        }
        return new FileObject(file, pathName, cs, this.option);
    }
}

