/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.fn;

import com.scudata.array.IArray;
import com.scudata.array.ObjectArray;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.expression.Function;
import com.scudata.expression.IParam;
import com.scudata.resources.EngineMessage;

public class Ifn
extends Function {
    public void checkValidity() {
        if (this.param == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("ifn" + mm.getMessage("function.missingParam"));
        }
    }

    public Object calculate(Context ctx) {
        IParam param = this.param;
        if (param.isLeaf()) {
            return param.getLeafExpression().calculate(ctx);
        }
        int size = param.getSubSize();
        for (int i = 0; i < size; ++i) {
            IParam sub = param.getSub(i);
            if (sub == null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("ifn" + mm.getMessage("function.invalidParam"));
            }
            Object obj = sub.getLeafExpression().calculate(ctx);
            if (obj == null) continue;
            return obj;
        }
        return null;
    }

    public IArray calculateAll(Context ctx) {
        IArray result;
        IParam param = this.param;
        if (param.isLeaf()) {
            return param.getLeafExpression().calculateAll(ctx);
        }
        int psize = param.getSubSize();
        IArray[] arrays = new IArray[psize];
        boolean isSameType = true;
        for (int i = 0; i < psize; ++i) {
            IParam sub = param.getSub(i);
            if (sub == null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("ifn" + mm.getMessage("function.invalidParam"));
            }
            arrays[i] = sub.getLeafExpression().calculateAll(ctx);
            if (!isSameType || i <= 0 || arrays[i].getClass() == arrays[i - 1].getClass()) continue;
            isSameType = false;
        }
        int len = arrays[0].size();
        if (isSameType) {
            result = arrays[0].dup();
        } else {
            result = new ObjectArray(len);
            result.addAll(arrays[0]);
        }
        block1: for (int i = 1; i <= len; ++i) {
            if (!result.isNull(i)) continue;
            for (int p = 1; p < psize; ++p) {
                if (arrays[p].isNull(i)) continue;
                result.set(i, arrays[p].get(i));
                continue block1;
            }
        }
        result.setTemporary(true);
        return result;
    }

    public IArray calculateAll(Context ctx, IArray signArray, boolean sign) {
        IArray result;
        IParam param = this.param;
        if (param.isLeaf()) {
            return param.getLeafExpression().calculateAll(ctx, signArray, sign);
        }
        int psize = param.getSubSize();
        IArray[] arrays = new IArray[psize];
        boolean isSameType = true;
        for (int i = 0; i < psize; ++i) {
            IParam sub = param.getSub(i);
            if (sub == null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("ifn" + mm.getMessage("function.invalidParam"));
            }
            arrays[i] = sub.getLeafExpression().calculateAll(ctx, signArray, sign);
            if (!isSameType || i <= 0 || arrays[i].getClass() == arrays[i - 1].getClass()) continue;
            isSameType = false;
        }
        int len = arrays[0].size();
        if (isSameType) {
            result = arrays[0].dup();
        } else {
            result = new ObjectArray(len);
            result.addAll(arrays[0]);
        }
        block1: for (int i = 1; i <= len; ++i) {
            if (!result.isNull(i)) continue;
            for (int p = 1; p < psize; ++p) {
                if (arrays[p].isNull(i)) continue;
                result.set(i, arrays[p].get(i));
                continue block1;
            }
        }
        result.setTemporary(true);
        return result;
    }
}

