/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.fn;

import com.scudata.app.common.AppUtil;
import com.scudata.cellset.datamodel.PgmCellSet;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.dm.ParamList;
import com.scudata.dm.Sequence;
import com.scudata.expression.Function;
import com.scudata.expression.IParam;
import com.scudata.expression.Node;
import com.scudata.resources.EngineMessage;

public class JDBCCall
extends Function {
    public Node optimize(Context ctx) {
        this.param.optimize(ctx);
        return this;
    }

    public void checkValidity() {
        if (this.param == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("jdbccall" + mm.getMessage("function.missingParam"));
        }
    }

    public Object calculate(Context ctx) {
        ParamList list;
        PgmCellSet pcs;
        String opt = this.option;
        boolean isR = opt != null && opt.indexOf("r") > -1;
        IParam param = this.param;
        Sequence args = null;
        if (param.isLeaf()) {
            Object strObj = param.getLeafExpression().calculate(ctx);
            if (!(strObj instanceof String)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("jdbccall" + mm.getMessage("function.paramTypeError"));
            }
            try {
                pcs = AppUtil.readCellSet((String)strObj);
            }
            catch (Exception e) {
                throw new RQException(e.getMessage(), e);
            }
        }
        IParam sub0 = param.getSub(0);
        if (sub0 == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("jdbccall" + mm.getMessage("function.invalidParam"));
        }
        Object strObj = sub0.getLeafExpression().calculate(ctx);
        if (!(strObj instanceof String)) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("jdbccall" + mm.getMessage("function.paramTypeError"));
        }
        try {
            pcs = AppUtil.readCellSet((String)strObj);
        }
        catch (Exception e) {
            if (e instanceof RQException) {
                throw (RQException)e;
            }
            throw new RQException(e.getMessage(), e);
        }
        int size = param.getSubSize();
        args = new Sequence();
        for (int i = 1; i < size; ++i) {
            IParam sub = param.getSub(i);
            if (sub != null) {
                Object obj = sub.getLeafExpression().calculate(ctx);
                args.add(obj);
                continue;
            }
            args.add(null);
        }
        if ((list = pcs.getParamList()) != null) {
            AppUtil.setParamToCellSet(pcs, args);
        }
        Context csCtx = pcs.getContext();
        csCtx.setEnv(ctx);
        if (isR) {
            return pcs.execute();
        }
        pcs.calculateResult();
        return pcs;
    }
}

