/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.fn;

import com.scudata.cellset.datamodel.PgmCellSet;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.common.Sentence;
import com.scudata.dm.Context;
import com.scudata.dm.KeyWord;
import com.scudata.expression.Expression;
import com.scudata.expression.Function;
import com.scudata.expression.IParam;
import com.scudata.expression.Node;
import com.scudata.resources.EngineMessage;

public class PCSFunction
extends Function {
    private PgmCellSet.FuncInfo _$1;

    public PCSFunction(PgmCellSet.FuncInfo funcInfo) {
        this._$1 = funcInfo;
    }

    public Node optimize(Context ctx) {
        if (this.param != null) {
            this.param.optimize(ctx);
        }
        return this;
    }

    private Object _$1(String macroExp, Context ctx) {
        String[] argNames = this._$1.getArgNames();
        if (argNames == null) {
            Expression exp = new Expression(this.cs, ctx, macroExp);
            return exp.calculate(ctx);
        }
        int pcount = argNames.length;
        String[] argExps = new String[pcount];
        if (pcount == 1) {
            if (this.param == null || !this.param.isLeaf()) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(this._$1.getFnName() + mm.getMessage("function.invalidParam"));
            }
            argExps[0] = this.param.getLeafExpression().toString();
        } else {
            if (this.param.getSubSize() != pcount) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(this._$1.getFnName() + mm.getMessage("function.invalidParam"));
            }
            for (int i = 0; i < pcount; ++i) {
                IParam sub = this.param.getSub(i);
                if (sub == null) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException(this._$1.getFnName() + mm.getMessage("function.invalidParam"));
                }
                argExps[i] = sub.getLeafExpression().toString();
            }
        }
        macroExp = PCSFunction._$1(macroExp, argNames, argExps);
        Expression exp = new Expression(this.cs, ctx, macroExp);
        return exp.calculate(ctx);
    }

    private static String _$1(String text, String[] argNames, String[] argExps) {
        int len = text.length();
        StringBuffer newStr = new StringBuffer(len + 32);
        int argCount = argNames.length;
        int idx = 0;
        block0: while (idx < len) {
            char c = text.charAt(idx);
            if (c == '\'' || c == '\"') {
                int match = Sentence.scanQuotation(text, idx);
                if (match < 0) {
                    if (newStr != null) {
                        newStr.append(c);
                    }
                    ++idx;
                    continue;
                }
                if (newStr != null) {
                    newStr.append(text.substring(idx, match + 1));
                }
                idx = match + 1;
                continue;
            }
            if (KeyWord.isSymbol(c)) {
                if (newStr != null) {
                    newStr.append(c);
                }
                ++idx;
                continue;
            }
            int last = KeyWord.scanId(text, idx + 1);
            String subStr = text.substring(idx, last);
            idx = last;
            for (int i = 0; i < argCount; ++i) {
                if (!argNames[i].equals(subStr)) continue;
                newStr.append(argExps[i]);
                continue block0;
            }
            newStr.append(subStr);
        }
        return newStr.toString();
    }

    public Object calculate(Context ctx) {
        String macroExp = this._$1.getMacroExpression();
        if (macroExp != null) {
            return this._$1(macroExp, ctx);
        }
        Object[] args = this._$1.getDefaultValues();
        boolean hasOptParam = this._$1.hasOptParam();
        if (this.param != null) {
            if (hasOptParam) {
                if (this.param.isLeaf()) {
                    if (args == null || args.length < 2) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException(this._$1.getFnName() + mm.getMessage("function.invalidParam"));
                    }
                    args[0] = this.option;
                    args[1] = this._$1.isMacroArg(1) ? this.param.getLeafExpression().toString() : this.param.getLeafExpression().calculate(ctx);
                } else {
                    int size = this.param.getSubSize();
                    if (args == null || args.length < size + 1) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException(this._$1.getFnName() + mm.getMessage("function.invalidParam"));
                    }
                    args[0] = this.option;
                    for (int i = 0; i < size; ++i) {
                        IParam sub = this.param.getSub(i);
                        if (sub == null) continue;
                        args[i + 1] = this._$1.isMacroArg(i + 1) ? sub.getLeafExpression().toString() : sub.getLeafExpression().calculate(ctx);
                    }
                }
            } else if (this.param.isLeaf()) {
                if (args == null) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException(this._$1.getFnName() + mm.getMessage("function.invalidParam"));
                }
                args[0] = this._$1.isMacroArg(0) ? this.param.getLeafExpression().toString() : this.param.getLeafExpression().calculate(ctx);
            } else {
                int size = this.param.getSubSize();
                if (args == null || args.length < size) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException(this._$1.getFnName() + mm.getMessage("function.invalidParam"));
                }
                for (int i = 0; i < size; ++i) {
                    IParam sub = this.param.getSub(i);
                    if (sub == null) continue;
                    args[i] = this._$1.isMacroArg(i) ? sub.getLeafExpression().toString() : sub.getLeafExpression().calculate(ctx);
                }
            }
        } else if (hasOptParam) {
            if (args == null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(this._$1.getFnName() + mm.getMessage("function.invalidParam"));
            }
            args[0] = this.option;
        }
        return this._$1.execute(args, ctx);
    }

    public PgmCellSet.FuncInfo getFuncInfo() {
        return this._$1;
    }

    public Object[] prepareArgs(Context ctx) {
        Object[] args = null;
        if (this.param != null) {
            if (this.param.isLeaf()) {
                Object val = this.param.getLeafExpression().calculate(ctx);
                args = new Object[]{val};
            } else {
                int size = this.param.getSubSize();
                args = new Object[size];
                for (int i = 0; i < size; ++i) {
                    IParam sub = this.param.getSub(i);
                    if (sub == null) continue;
                    args[i] = sub.getLeafExpression().calculate(ctx);
                }
            }
        }
        return args;
    }
}

