/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.fn;

import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.dm.Sequence;
import com.scudata.expression.Function;
import com.scudata.expression.IParam;
import com.scudata.resources.EngineMessage;
import com.scudata.util.Variant;
import java.sql.Timestamp;
import java.util.Date;

public class Range
extends Function {
    public void checkValidity() {
        if (this.param == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("range" + mm.getMessage("function.missingParam"));
        }
        if (this.param.getSubSize() != 3) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("range" + mm.getMessage("function.invalidParam"));
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public Object calculate(Context ctx) {
        Object endVal;
        IParam startParam = this.param.getSub(0);
        IParam endParam = this.param.getSub(1);
        IParam segParam = this.param.getSub(2);
        if (startParam == null || endParam == null || segParam == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("range" + mm.getMessage("function.invalidParam"));
        }
        Object startVal = startParam.getLeafExpression().calculate(ctx);
        if (Variant.compare(startVal, endVal = endParam.getLeafExpression().calculate(ctx)) >= 0) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("range" + mm.getMessage("function.invalidParam"));
        }
        int k = -1;
        int n = 1;
        if (segParam.isLeaf()) {
            Object obj = segParam.getLeafExpression().calculate(ctx);
            if (!(obj instanceof Number)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("range" + mm.getMessage("function.paramTypeError"));
            }
            n = ((Number)obj).intValue();
        } else {
            if (segParam.getSubSize() != 2) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("range" + mm.getMessage("function.invalidParam"));
            }
            IParam sub0 = segParam.getSub(0);
            IParam sub1 = segParam.getSub(1);
            if (sub0 == null || sub1 == null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("range" + mm.getMessage("function.invalidParam"));
            }
            Object obj0 = sub0.getLeafExpression().calculate(ctx);
            if (!(obj0 instanceof Number)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("range" + mm.getMessage("function.paramTypeError"));
            }
            k = ((Number)obj0).intValue();
            Object obj1 = sub1.getLeafExpression().calculate(ctx);
            if (!(obj1 instanceof Number)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("range" + mm.getMessage("function.paramTypeError"));
            }
            n = ((Number)obj1).intValue();
            if (k < 1 || k > n) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("range" + mm.getMessage("function.invalidParam"));
            }
        }
        if (k == -1) {
            return this._$1(startVal, endVal, n);
        }
        return this._$1(startVal, endVal, k, n);
    }

    private Sequence _$1(Object startVal, Object endVal, int n) {
        if (n <= 1) {
            Sequence seq = new Sequence(2);
            seq.add(startVal);
            seq.add(endVal);
            return seq;
        }
        if (startVal instanceof Number && endVal instanceof Number) {
            long len = ((Number)endVal).longValue() - ((Number)startVal).longValue();
            if (len < (long)n) {
                n = (int)len;
                Sequence seq = new Sequence(n + 1);
                seq.add(startVal);
                for (int i = 1; i < n; ++i) {
                    Object val = Variant.add(startVal, (Object)i);
                    seq.add(val);
                }
                seq.add(endVal);
                return seq;
            }
            long avg = len / (long)n;
            long mod = len % (long)n;
            Sequence seq = new Sequence(n + 1);
            seq.add(startVal);
            for (int i = 1; i < n; ++i) {
                Object val;
                if ((long)i <= mod) {
                    val = Variant.add(startVal, avg * (long)i + (long)i);
                    seq.add(val);
                    continue;
                }
                val = Variant.add(startVal, avg * (long)i + mod);
                seq.add(val);
            }
            seq.add(endVal);
            return seq;
        }
        if (startVal instanceof java.sql.Date && endVal instanceof java.sql.Date) {
            java.sql.Date startDate = (java.sql.Date)startVal;
            java.sql.Date endDate = (java.sql.Date)endVal;
            int len = (int)Variant.dayInterval(startDate, endDate);
            if (len < n) {
                n = len;
                Sequence seq = new Sequence(n + 1);
                seq.add(startVal);
                for (int i = 1; i < n; ++i) {
                    Date val = Variant.elapse(startDate, i, null);
                    seq.add(val);
                }
                seq.add(endVal);
                return seq;
            }
            int avg = len / n;
            int mod = len % n;
            Sequence seq = new Sequence(n + 1);
            seq.add(startVal);
            for (int i = 1; i < n; ++i) {
                Date val;
                if (i <= mod) {
                    val = Variant.elapse(startDate, avg * i + i, null);
                    seq.add(val);
                    continue;
                }
                val = Variant.elapse(startDate, avg * i + mod, null);
                seq.add(val);
            }
            seq.add(endVal);
            return seq;
        }
        if (startVal instanceof Timestamp && endVal instanceof Timestamp) {
            Timestamp startDate = (Timestamp)startVal;
            Timestamp endDate = (Timestamp)endVal;
            int len = (int)Variant.secondInterval(startDate, endDate);
            if (len < n) {
                n = len;
                Sequence seq = new Sequence(n + 1);
                seq.add(startVal);
                for (int i = 1; i < n; ++i) {
                    Date val = Variant.elapse(startDate, i, "s");
                    seq.add(val);
                }
                seq.add(endVal);
                return seq;
            }
            int avg = len / n;
            int mod = len % n;
            Sequence seq = new Sequence(n + 1);
            seq.add(startVal);
            for (int i = 1; i < n; ++i) {
                Date val;
                if (i <= mod) {
                    val = Variant.elapse(startDate, avg * i + i, "s");
                    seq.add(val);
                    continue;
                }
                val = Variant.elapse(startDate, avg * i + mod, "s");
                seq.add(val);
            }
            seq.add(endVal);
            return seq;
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException("range" + mm.getMessage("function.paramTypeError"));
    }

    private Sequence _$1(Object startVal, Object endVal, int k, int n) {
        Sequence total = this._$1(startVal, endVal, n);
        int len = total.length();
        if (k < len) {
            Sequence seq = new Sequence(2);
            seq.add(total.getMem(k));
            seq.add(total.getMem(k + 1));
            return seq;
        }
        return null;
    }
}

