/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.fn;

import com.scudata.common.Logger;
import com.scudata.common.MessageManager;
import com.scudata.common.ObjectCache;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.dm.JobSpace;
import com.scudata.dm.Sequence;
import com.scudata.expression.Function;
import com.scudata.expression.IParam;
import com.scudata.expression.Node;
import com.scudata.expression.fn.llIlllIlIlIllIlI;
import com.scudata.resources.EngineMessage;

public class SystemExec
extends Function {
    public Node optimize(Context ctx) {
        this.param.optimize(ctx);
        return this;
    }

    public void checkValidity() {
        if (this.param == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("system" + mm.getMessage("function.missingParam"));
        }
    }

    public Object calculate(Context ctx) {
        JobSpace js = ctx.getJobSpace();
        if (js != null && js.getAppHome() != null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("license.fpNotSupport") + "system");
        }
        String cmd = null;
        String[] cmds = null;
        if (this.param.isLeaf()) {
            Object cmdObj = this.param.getLeafExpression().calculate(ctx);
            if (!(cmdObj instanceof String)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("system" + mm.getMessage("function.paramTypeError"));
            }
            cmd = (String)cmdObj;
        } else {
            int count = this.param.getSubSize();
            cmds = new String[count];
            for (int i = 0; i < count; ++i) {
                IParam sub = this.param.getSub(i);
                if (sub == null || !sub.isLeaf()) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("system" + mm.getMessage("function.invalidParam"));
                }
                Object cmdObj = sub.getLeafExpression().calculate(ctx);
                if (!(cmdObj instanceof String)) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("system" + mm.getMessage("function.paramTypeError"));
                }
                cmds[i] = (String)cmdObj;
            }
        }
        try {
            Runtime runtime = Runtime.getRuntime();
            Process process = cmds == null ? runtime.exec(cmd) : runtime.exec(cmds);
            StringBuffer errBuf = new StringBuffer(1024);
            StringBuffer outBuf = new StringBuffer(1024);
            llIlllIlIlIllIlI g1 = new llIlllIlIlIllIlI(errBuf, process.getErrorStream());
            llIlllIlIlIllIlI g2 = new llIlllIlIlIllIlI(outBuf, process.getInputStream());
            g1.start();
            g2.start();
            boolean isWait = true;
            boolean isOut = false;
            boolean isAll = false;
            if (this.option != null) {
                if (this.option.indexOf(112) != -1) {
                    isWait = false;
                } else if (this.option.indexOf(97) != -1) {
                    isAll = true;
                } else if (this.option.indexOf(111) != -1) {
                    isOut = true;
                }
            }
            if (isWait) {
                int n = process.waitFor();
                g1.join();
                g2.join();
                if (isAll) {
                    String error = null;
                    if (errBuf.length() > 0) {
                        error = errBuf.toString();
                        Logger.info(error);
                    }
                    String out = null;
                    if (outBuf.length() > 0) {
                        out = outBuf.toString();
                        Logger.info(out);
                    }
                    Sequence result = new Sequence(3);
                    result.add(ObjectCache.getInteger(n));
                    result.add(out);
                    result.add(error);
                    return result;
                }
                if (isOut) {
                    if (errBuf.length() > 0) {
                        Logger.info(errBuf);
                    }
                    if (outBuf.length() > 0) {
                        String out = outBuf.toString();
                        Logger.info(out);
                        return out;
                    }
                    return null;
                }
                if (errBuf.length() > 0) {
                    Logger.info(errBuf);
                }
                if (outBuf.length() > 0) {
                    Logger.info(outBuf);
                }
                return ObjectCache.getInteger(n);
            }
            return Boolean.TRUE;
        }
        catch (Exception e) {
            throw new RQException(e);
        }
    }
}

