/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.fn.algebra;

import com.scudata.common.Logger;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.dm.Sequence;
import com.scudata.expression.Function;
import com.scudata.expression.fn.algebra.Matrix;
import com.scudata.resources.EngineMessage;

public class Inverse
extends Function {
    public void checkValidity() {
        if (this.param == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("inverse" + mm.getMessage("function.missingParam"));
        }
        if (!this.param.isLeaf()) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("inverse" + mm.getMessage("function.invalidParam"));
        }
    }

    public Object calculate(Context ctx) {
        Object result1 = this.param.getLeafExpression().calculate(ctx);
        if (!(result1 instanceof Sequence)) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("inverse" + mm.getMessage("function.paramTypeError"));
        }
        Matrix A = new Matrix((Sequence)result1);
        if (A.getCols() == 0 || A.getRows() == 0) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("inverse" + mm.getMessage("function.paramTypeError"));
        }
        Matrix X = null;
        boolean pseudo = false;
        boolean auto = false;
        if (this.option != null) {
            if (this.option.indexOf(97) > -1) {
                auto = true;
            } else if (this.option.indexOf(112) > -1) {
                pseudo = true;
            }
        }
        try {
            X = pseudo ? A.pseudoinverse() : A.inverse();
        }
        catch (Exception e) {
            if (auto) {
                X = A.pseudoinverse();
            }
            Logger.warn("inverse error: " + e.getMessage());
            return null;
        }
        if (X == null) {
            return null;
        }
        return X.toSequence(this.option, false);
    }
}

