/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.fn.algebra;

import com.scudata.common.RQException;
import com.scudata.expression.fn.algebra.Matrix;

public class LUDecomposition {
    private double[][] _$5;
    private int[] _$4;
    private int _$3;
    private int _$2;
    private int _$1;

    protected LUDecomposition(Matrix A) {
        this._$5 = A.getArrayCopy();
        this._$3 = A.getRows();
        this._$2 = A.getCols();
        this._$4 = new int[this._$3];
        for (int r = 0; r < this._$3; ++r) {
            this._$4[r] = r;
        }
        this._$1 = 1;
        double[] LUcol = new double[this._$3];
        for (int c = 0; c < this._$2; ++c) {
            int r;
            int r2;
            for (r2 = 0; r2 < this._$3; ++r2) {
                LUcol[r2] = this._$5[r2][c];
            }
            r2 = 0;
            while (r2 < this._$3) {
                double[] LUrow = this._$5[r2];
                int kmax = Math.min(r2, c);
                double s = 0.0;
                for (int k = 0; k < kmax; ++k) {
                    s += LUrow[k] * LUcol[k];
                }
                int n = r2++;
                double d = LUcol[n] - s;
                LUcol[n] = d;
                LUrow[c] = d;
            }
            int p = c;
            for (r = c + 1; r < this._$3; ++r) {
                if (!(Math.abs(LUcol[r]) > Math.abs(LUcol[p]))) continue;
                p = r;
            }
            if (p != c) {
                int k;
                for (k = 0; k < this._$2; ++k) {
                    double t = this._$5[p][k];
                    this._$5[p][k] = this._$5[c][k];
                    this._$5[c][k] = t;
                }
                k = this._$4[p];
                this._$4[p] = this._$4[c];
                this._$4[c] = k;
                this._$1 = -this._$1;
            }
            if (!(c < this._$3 & this._$5[c][c] != 0.0)) continue;
            for (r = c + 1; r < this._$3; ++r) {
                double[] dArray = this._$5[r];
                int n = c;
                dArray[n] = dArray[n] / this._$5[c][c];
            }
        }
    }

    protected Matrix solve(Matrix B) {
        int j;
        int i;
        int k;
        if (B.getRows() != this._$3) {
            throw new RQException("Matrix row dimensions must agree.");
        }
        if (!this._$1()) {
            throw new RQException("Matrix is singular.");
        }
        int nx = B.getCols();
        Matrix Xmat = B.getMatrix(this._$4, 0, nx - 1);
        double[][] X = Xmat.getArray();
        for (k = 0; k < this._$2; ++k) {
            for (i = k + 1; i < this._$2; ++i) {
                for (j = 0; j < nx; ++j) {
                    double[] dArray = X[i];
                    int n = j;
                    dArray[n] = dArray[n] - X[k][j] * this._$5[i][k];
                }
            }
        }
        for (k = this._$2 - 1; k >= 0; --k) {
            int j2 = 0;
            while (j2 < nx) {
                double[] dArray = X[k];
                int n = j2++;
                dArray[n] = dArray[n] / this._$5[k][k];
            }
            for (i = 0; i < k; ++i) {
                for (j = 0; j < nx; ++j) {
                    double[] dArray = X[i];
                    int n = j;
                    dArray[n] = dArray[n] - X[k][j] * this._$5[i][k];
                }
            }
        }
        return Xmat;
    }

    protected double det() {
        if (this._$3 != this._$2) {
            throw new IllegalArgumentException("Matrix must be square.");
        }
        double d = this._$1;
        for (int j = 0; j < this._$2; ++j) {
            d *= this._$5[j][j];
        }
        double scale = 1000000.0;
        d = (d *= scale) > -9.223372036854776E18 && d < 9.223372036854776E18 ? (double)Math.round(d) / scale : (d /= scale);
        return d;
    }

    private boolean _$1() {
        for (int c = 0; c < this._$2; ++c) {
            if (!Matrix.ifZero(this._$5[c][c])) continue;
            return false;
        }
        return true;
    }
}

