/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.fn.algebra;

import com.scudata.common.Logger;
import com.scudata.dm.BaseRecord;
import com.scudata.dm.Sequence;
import com.scudata.dm.Table;
import com.scudata.expression.fn.algebra.LUDecomposition;
import com.scudata.expression.fn.algebra.QRDecomposition;
import com.scudata.expression.fn.algebra.SVDecomposition;
import com.scudata.expression.fn.algebra.Vector;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.RealMatrix;

public class Matrix {
    private double[][] _$6;
    private int _$5;
    private int _$4;
    private boolean _$3 = false;
    private static final double _$2 = 1000000.0;
    private static final double _$1 = 1.0E-14;

    public Matrix(int rs, int cs) {
        this._$6 = new double[rs][cs];
        this._$5 = rs;
        this._$4 = cs;
    }

    public Matrix(Sequence matrix) {
        int rows;
        int n = rows = matrix == null ? 0 : matrix.length();
        if (rows > 0) {
            if (matrix instanceof Table) {
                Table tab = (Table)matrix;
                this._$4 = tab.dataStruct().getFieldCount();
                this._$5 = rows;
                this._$6 = new double[rows][this._$4];
                for (int i = 1; i <= rows; ++i) {
                    double[] row = Matrix.getRow(tab.getRecord(i), this._$4);
                    this._$6[i - 1] = row;
                }
            } else {
                int cols2;
                Object row;
                int r;
                int cols = 0;
                for (r = 0; r < rows; ++r) {
                    row = matrix.get(r + 1);
                    if (!(row instanceof Sequence) || cols >= (cols2 = ((Sequence)row).length())) continue;
                    cols = cols2;
                }
                if (cols == 0) {
                    cols = 1;
                    this._$3 = false;
                    this._$6 = new double[rows][1];
                    for (r = 0; r < rows; ++r) {
                        Object obj = matrix.get(r + 1);
                        if (!(obj instanceof Number)) continue;
                        this._$6[r][0] = ((Number)obj).doubleValue();
                    }
                } else {
                    this._$6 = new double[rows][cols];
                    for (r = 0; r < rows; ++r) {
                        row = matrix.get(r + 1);
                        if (row instanceof Sequence) {
                            cols2 = ((Sequence)row).length();
                            for (int c = 0; c < cols2; ++c) {
                                Object obj = ((Sequence)row).get(c + 1);
                                if (!(obj instanceof Number)) continue;
                                this._$6[r][c] = ((Number)obj).doubleValue();
                            }
                            continue;
                        }
                        if (!(row instanceof Number)) continue;
                        this._$6[r][0] = ((Number)row).doubleValue();
                    }
                }
                this._$4 = cols;
                this._$5 = rows;
            }
        }
    }

    protected static double[] getRow(Sequence seq, int n) {
        if (n < 1) {
            int n2 = n = seq == null ? 0 : seq.length();
        }
        if (n < 1) {
            return null;
        }
        double[] row = new double[n];
        for (int i = 1; i <= n; ++i) {
            Object obj = seq.get(i);
            row[i - 1] = Matrix._$1(obj);
        }
        return row;
    }

    protected static double[] getRow(BaseRecord rec, int n) {
        double[] row = new double[n];
        Object[] vs = rec.getFieldValues();
        for (int i = 0; i < n; ++i) {
            Object obj = vs[i];
            row[i] = Matrix._$1(obj);
        }
        return row;
    }

    private static double _$1(Object obj) {
        double d = 0.0;
        if (obj instanceof Sequence) {
            if (((Sequence)obj).length() == 0) {
                return d;
            }
            obj = ((Sequence)obj).get(1);
        }
        if (obj instanceof Number) {
            d = ((Number)obj).doubleValue();
        } else if (obj instanceof String) {
            d = Double.valueOf(obj.toString());
        }
        return d;
    }

    protected double[] getVector() {
        if (this._$3) {
            if (this._$5 == 1) {
                return this._$6[0];
            }
            if (this._$4 == 1) {
                double[] vector = new double[this._$5];
                for (int i = 0; i < this._$5; ++i) {
                    vector[i] = this._$6[i][0];
                }
                return vector;
            }
        }
        return null;
    }

    protected Matrix(double[] vector, boolean vertical) {
        int size = vector == null ? 0 : vector.length;
        this._$3 = true;
        if (vertical) {
            this._$5 = size;
            this._$4 = 1;
            this._$6 = new double[this._$5][this._$4];
            for (int r = 0; r < size; ++r) {
                this._$6[r][0] = vector[r];
            }
        } else {
            this._$5 = 1;
            this._$4 = size;
            this._$6 = new double[this._$5][this._$4];
            this._$6[0] = vector;
        }
    }

    protected Matrix(Sequence vector, boolean vertical) {
        int size = vector == null ? 0 : vector.length();
        this._$3 = true;
        if (vertical) {
            this._$5 = size;
            this._$4 = 1;
            this._$6 = new double[this._$5][this._$4];
            for (int r = 0; r < size; ++r) {
                Object obj = vector.get(r + 1);
                if (!(obj instanceof Number)) continue;
                this._$6[r][0] = ((Number)obj).doubleValue();
            }
        } else {
            this._$5 = 1;
            this._$4 = size;
            this._$6 = new double[this._$5][this._$4];
            for (int i = 0; i < size; ++i) {
                Object obj = vector.get(i + 1);
                if (!(obj instanceof Number)) continue;
                this._$6[0][i] = ((Number)obj).doubleValue();
            }
        }
    }

    public Matrix(double[][] A) {
        this._$6 = A;
        this._$5 = A.length;
        int cols = 0;
        for (int i = 0; i < this._$5; ++i) {
            int thisCols;
            double[] row = this._$6[i];
            int n = thisCols = row == null ? 0 : row.length;
            if (cols >= thisCols) continue;
            cols = thisCols;
        }
        this._$4 = cols;
    }

    public Matrix(double[][] A, int rows, int cols) {
        this._$6 = A;
        this._$5 = rows;
        this._$4 = cols;
    }

    public Object toSequence(String option, boolean real) {
        boolean ifv;
        boolean ift = option != null && option.indexOf(116) > -1;
        boolean bl = ifv = option != null && option.indexOf(118) > -1;
        if (ift) {
            String[] cols = new String[]{"_1"};
            if (this._$4 > 1) {
                cols = new String[this._$4];
                for (int i = 0; i < this._$4; ++i) {
                    cols[i] = "_" + (i + 1);
                }
            }
            Table tbl = new Table(cols);
            for (int i = 0; i < this._$5; ++i) {
                Object[] r = new Double[this._$4];
                for (int j = 0; j < this._$4; ++j) {
                    r[j] = this._$1(i, j, real);
                }
                tbl.newLast(r);
            }
            return tbl;
        }
        if (this._$5 == 1 && this._$4 == 1) {
            return this._$6[0][0];
        }
        if (ifv && this._$5 == 1) {
            Sequence sub = new Sequence(this._$4);
            for (int c = 0; c < this._$4; ++c) {
                double d = this._$1(0, c, real);
                sub.add(d);
            }
            return sub;
        }
        if (ifv && this._$4 == 1) {
            Sequence sub = new Sequence(this._$5);
            for (int r = 0; r < this._$5; ++r) {
                double d = this._$1(r, 0, real);
                sub.add(d);
            }
            return sub;
        }
        Sequence seq = new Sequence(this._$5);
        for (int r = 0; r < this._$5; ++r) {
            Sequence sub = new Sequence(this._$4);
            for (int c = 0; c < this._$4; ++c) {
                double d = this._$1(r, c, real);
                sub.add(d);
            }
            seq.add(sub);
        }
        return seq;
    }

    public void set(int r, int c, double v) {
        this._$6[r][c] = v;
    }

    private double _$1(int r, int c, boolean real) {
        double d = this._$6[r][c];
        if (!real) {
            double abs = Math.abs(d);
            double scale1 = 1000000.0;
            if (abs < 1.0E-14) {
                return d;
            }
            if (abs < 1.0) {
                scale1 *= Math.pow(10.0, (int)Math.round(Math.log10(1.0 / abs)));
            }
            if ((d *= scale1) > -9.223372036854776E18 && d < 9.223372036854776E18) {
                d = (double)Math.round(d) / scale1;
            } else {
                return this._$6[r][c];
            }
        }
        return d;
    }

    public int getRows() {
        return this._$5;
    }

    public int getCols() {
        return this._$4;
    }

    public double[][] getArray() {
        return this._$6;
    }

    public Matrix covm() {
        int i;
        Matrix X = new Matrix(this._$4, this._$4);
        double[][] xs = X.getArray();
        double[][] dims = this.transpose().getArray();
        double[] dimv = new double[this._$4];
        for (i = 0; i < this._$4; ++i) {
            double[] dim = dims[i];
            double res = 0.0;
            for (int j = 0; j < this._$5; ++j) {
                res += dim[j];
            }
            dimv[i] = res / (double)this._$5;
        }
        for (i = 0; i < this._$4; ++i) {
            for (int j = 0; j < this._$4; ++j) {
                int k;
                double cov;
                if (i > j) {
                    xs[i][j] = xs[j][i];
                    continue;
                }
                if (i == j) {
                    cov = 0.0;
                    for (k = 0; k < this._$5; ++k) {
                        cov += Math.pow(this._$6[k][i] - dimv[i], 2.0);
                    }
                    xs[i][j] = cov / (double)(this._$5 - 1);
                    continue;
                }
                cov = 0.0;
                for (k = 0; k < this._$5; ++k) {
                    cov += (this._$6[k][i] - dimv[i]) * (this._$6[k][j] - dimv[j]);
                }
                xs[i][j] = cov / (double)(this._$5 - 1);
            }
        }
        return X;
    }

    protected Table toTable() {
        String[] cns = new String[this._$4];
        for (int c = 0; c < this._$4; ++c) {
            cns[c] = "Col" + (c + 1);
        }
        Table t = new Table(cns);
        for (int r = 0; r < this._$5; ++r) {
            BaseRecord rec = t.newLast();
            for (int c = 0; c < this._$4; ++c) {
                rec.set(c, (Object)this._$6[r][c]);
            }
        }
        return t;
    }

    protected Matrix getMatrix(int[] r, int j0, int j1) {
        Matrix X = new Matrix(r.length, j1 - j0 + 1);
        double[][] B = X.getArray();
        try {
            for (int i = 0; i < r.length; ++i) {
                for (int j = j0; j <= j1; ++j) {
                    B[i][j - j0] = this._$6[r[i]][j];
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
        return X;
    }

    public Matrix getMatrix(int r0, int r1, int c0, int c1) {
        Matrix X = new Matrix(r1 - r0 + 1, c1 - c0 + 1);
        double[][] B = X.getArray();
        try {
            for (int r = r0; r <= r1; ++r) {
                for (int c = c0; c <= c1; ++c) {
                    B[r - r0][c - c0] = this._$6[r][c];
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
        return X;
    }

    protected static double get(Sequence matrix, int r, int c) {
        Object obj;
        int len;
        Object row = matrix.get(r + 1);
        if (row instanceof Sequence && (len = ((Sequence)row).length()) >= c && (obj = ((Sequence)row).get(c + 1)) instanceof Number) {
            return ((Number)obj).doubleValue();
        }
        return 0.0;
    }

    protected static int[] ifMatrix(Sequence matrix, boolean ifNumerical) {
        int rows;
        int n = rows = matrix == null ? 0 : matrix.length();
        if (rows > 0) {
            int cols = 0;
            for (int r = 0; r < rows; ++r) {
                Object row = matrix.get(r + 1);
                if (row instanceof Sequence) {
                    int cols2 = ((Sequence)row).length();
                    if (cols == 0) {
                        cols = cols2;
                    } else if (cols != cols2) {
                        return null;
                    }
                } else {
                    return null;
                }
                if (!ifNumerical) continue;
                for (int c = 0; c < cols; ++c) {
                    Object obj = ((Sequence)row).get(c + 1);
                    if (obj instanceof Number) continue;
                    return null;
                }
            }
            int[] bak = new int[]{rows, cols};
            return bak;
        }
        return null;
    }

    protected boolean ifMatrix() {
        return this._$6 != null;
    }

    protected static int ifSquare(Sequence matrix, boolean ifNumerical) {
        int rows;
        int n = rows = matrix == null ? 0 : matrix.length();
        if (rows > 0) {
            for (int r = 0; r < rows; ++r) {
                Object row = matrix.get(r + 1);
                if (row instanceof Sequence) {
                    int cols = ((Sequence)row).length();
                    if (cols != rows) {
                        return 0;
                    }
                    if (!ifNumerical) continue;
                    for (int c = 0; c < cols; ++c) {
                        Object obj = ((Sequence)row).get(c + 1);
                        if (obj instanceof Number) continue;
                        return 0;
                    }
                    continue;
                }
                return 0;
            }
            return rows;
        }
        return 0;
    }

    protected boolean ifSquare() {
        return this._$5 > 0 && this._$5 == this._$4;
    }

    public Matrix transpose() {
        Matrix X = new Matrix(this._$4, this._$5);
        for (int r = 0; r < this._$5; ++r) {
            for (int c = 0; c < this._$4; ++c) {
                X._$6[c][r] = this._$6[r][c];
            }
        }
        return X;
    }

    public static Sequence transpose(Sequence matrix) {
        int rows;
        int n = rows = matrix == null ? 0 : matrix.length();
        if (rows > 0) {
            int cols = 0;
            for (int r = 0; r < rows; ++r) {
                int cols2;
                Object row = matrix.get(r + 1);
                if (!(row instanceof Sequence) || cols >= (cols2 = ((Sequence)row).length())) continue;
                cols = cols2;
            }
            Sequence trans = new Sequence(cols);
            for (int c = 0; c < cols; ++c) {
                Sequence row0 = new Sequence(rows);
                trans.add(row0);
                for (int r = 0; r < rows; ++r) {
                    Object row = matrix.get(r + 1);
                    if (row instanceof Sequence) {
                        int cols2 = ((Sequence)row).length();
                        if (cols2 > c) {
                            row0.add(((Sequence)row).get(c + 1));
                            continue;
                        }
                        row0.add(null);
                        continue;
                    }
                    if (c == 0) {
                        row0.add(row);
                        continue;
                    }
                    row0.add(null);
                }
            }
            return trans;
        }
        return null;
    }

    public double get(int r, int c) {
        return this._$6[r][c];
    }

    private void _$1(Matrix B) {
        if (B._$5 != this._$5 || B._$4 != this._$4) {
            throw new IllegalArgumentException("Matrix dimensions must agree.");
        }
    }

    public Matrix plus(Matrix B) {
        this._$1(B);
        Matrix X = new Matrix(this._$5, this._$4);
        for (int r = 0; r < this._$5; ++r) {
            for (int c = 0; c < this._$4; ++c) {
                X._$6[r][c] = this._$6[r][c] + B._$6[r][c];
            }
        }
        return X;
    }

    public Matrix elementSquare() {
        Matrix X = new Matrix(this._$5, this._$4);
        for (int r = 0; r < this._$5; ++r) {
            for (int c = 0; c < this._$4; ++c) {
                X._$6[r][c] = this._$6[r][c] * this._$6[r][c];
            }
        }
        return X;
    }

    public double elementSum() {
        double sumup = 0.0;
        for (int r = 0; r < this._$5; ++r) {
            for (int c = 0; c < this._$4; ++c) {
                sumup += this._$6[r][c];
            }
        }
        return sumup;
    }

    public double dot(Matrix B) {
        double innerProduct = 0.0;
        for (int r = 0; r < this._$5; ++r) {
            for (int c = 0; c < this._$4; ++c) {
                innerProduct += this._$6[r][c] * B._$6[r][c];
            }
        }
        return innerProduct;
    }

    protected Matrix plusUp(Matrix B) {
        this._$1(B);
        for (int r = 0; r < this._$5; ++r) {
            for (int c = 0; c < this._$4; ++c) {
                this._$6[r][c] = this._$6[r][c] + B._$6[r][c];
            }
        }
        return this;
    }

    public Matrix minus(Matrix B) {
        this._$1(B);
        Matrix X = new Matrix(this._$5, this._$4);
        for (int r = 0; r < this._$5; ++r) {
            for (int c = 0; c < this._$4; ++c) {
                X._$6[r][c] = this._$6[r][c] - B._$6[r][c];
            }
        }
        return X;
    }

    public Matrix plus(double d) {
        Matrix X = new Matrix(this._$5, this._$4);
        for (int r = 0; r < this._$5; ++r) {
            for (int c = 0; c < this._$4; ++c) {
                X._$6[r][c] = this._$6[r][c] + d;
            }
        }
        return X;
    }

    protected Matrix minus(double d) {
        Matrix X = new Matrix(this._$5, this._$4);
        for (int r = 0; r < this._$5; ++r) {
            for (int c = 0; c < this._$4; ++c) {
                X._$6[r][c] = this._$6[r][c] - d;
            }
        }
        return X;
    }

    protected Matrix times(double d) {
        Matrix X = new Matrix(this._$5, this._$4);
        for (int r = 0; r < this._$5; ++r) {
            for (int c = 0; c < this._$4; ++c) {
                X._$6[r][c] = this._$6[r][c] * d;
            }
        }
        return X;
    }

    protected Matrix minusEquals(Matrix B) {
        this._$1(B);
        for (int r = 0; r < this._$5; ++r) {
            for (int c = 0; c < this._$4; ++c) {
                this._$6[r][c] = this._$6[r][c] - B._$6[r][c];
            }
        }
        return this;
    }

    public Matrix times(Matrix B) {
        if (B._$5 != this._$4) {
            throw new IllegalArgumentException("Matrix inner dimensions must agree.");
        }
        Matrix X = new Matrix(this._$5, B._$4);
        double[] BVectorCol = new double[this._$4];
        for (int c = 0; c < B._$4; ++c) {
            for (int k = 0; k < this._$4; ++k) {
                BVectorCol[k] = B._$6[k][c];
            }
            for (int r = 0; r < this._$5; ++r) {
                double[] AVectorRow = this._$6[r];
                double s = 0.0;
                for (int k = 0; k < this._$4; ++k) {
                    s += AVectorRow[k] * BVectorCol[k];
                }
                X._$6[r][c] = s;
            }
        }
        return X;
    }

    public Matrix divide(double d) {
        Matrix X = new Matrix(this._$5, this._$4);
        for (int c = 0; c < this._$4; ++c) {
            for (int r = 0; r < this._$5; ++r) {
                X._$6[r][c] = this._$6[r][c] / d;
            }
        }
        return X;
    }

    protected static Matrix identity(int rows, int cols) {
        Matrix X = new Matrix(rows, cols);
        for (int r = 0; r < rows; ++r) {
            for (int c = 0; c < cols; ++c) {
                X._$6[r][c] = r == c ? 1.0 : 0.0;
            }
        }
        return X;
    }

    protected static Matrix identity(int size) {
        return Matrix.identity(size, size);
    }

    public Matrix solve(Matrix B) {
        Matrix result = null;
        try {
            result = this._$5 == this._$4 ? new LUDecomposition(this).solve(B) : new QRDecomposition(this).solve(B);
        }
        catch (Exception e) {
            Logger.warn(e.getMessage());
        }
        return result;
    }

    public double[][] getArrayCopy() {
        double[][] X = new double[this._$5][this._$4];
        for (int r = 0; r < this._$5; ++r) {
            for (int c = 0; c < this._$4; ++c) {
                X[r][c] = this._$6[r][c];
            }
        }
        return X;
    }

    public Matrix inverse() {
        return this.solve(Matrix.identity(this._$5));
    }

    public Matrix pseudoinverse() {
        if (this._$5 >= this._$4) {
            return new QRDecomposition(this).solve(Matrix.identity(this._$5));
        }
        Matrix X = new QRDecomposition(this.transpose()).solve(Matrix.identity(this._$4));
        return X.transpose();
    }

    public RealMatrix realMatrix() {
        return new Array2DRowRealMatrix(this._$6);
    }

    public double det() {
        if (this._$5 != this._$4) {
            Logger.warn("Matrix must be square.");
            return 0.0;
        }
        double det = 0.0;
        try {
            det = new LUDecomposition(this).det();
        }
        catch (Exception e) {
            Logger.warn(e.getMessage());
        }
        return det;
    }

    public static void main(String[] args) {
        Sequence seq = new Sequence(3);
        Sequence sub1 = new Sequence(3);
        sub1.add(1);
        sub1.add(1);
        sub1.add(1);
        seq.add(sub1);
        Sequence sub2 = new Sequence(3);
        sub2.add(0);
        sub2.add(4);
        sub2.add(-1);
        seq.add(sub2);
        Sequence sub3 = new Sequence(3);
        sub3.add(2);
        sub3.add(-2);
        sub3.add(1);
        seq.add(sub3);
        Matrix m = new Matrix(seq);
        Sequence seq2 = new Sequence(3);
        seq2.add(6);
        seq2.add(5);
        seq2.add(1);
        m.solve(new Matrix(seq2, true)).output();
        System.out.println("done");
    }

    protected void output() {
        for (int i = 0; i < this._$5; ++i) {
            String s = "";
            for (int j = 0; j < this._$4; ++j) {
                s = s + this._$6[i][j] + "\t";
            }
            System.out.println(s);
        }
    }

    public int rank() {
        return new SVDecomposition(this).rank();
    }

    public double mse(Matrix B) {
        try {
            Matrix X = this.minus(B);
            double result = 0.0;
            for (int r = 0; r < this._$5; ++r) {
                for (int c = 0; c < this._$4; ++c) {
                    result += Math.pow(X.get(r, c), 2.0);
                }
            }
            return result / (double)this._$4 / (double)this._$5;
        }
        catch (Exception e) {
            Logger.warn(e.getMessage());
            return 0.0;
        }
    }

    public double mae(Matrix B) {
        try {
            Matrix X = this.minus(B);
            double result = 0.0;
            for (int r = 0; r < this._$5; ++r) {
                for (int c = 0; c < this._$4; ++c) {
                    result += Math.abs(X.get(r, c));
                }
            }
            return result / (double)this._$4 / (double)this._$5;
        }
        catch (Exception e) {
            Logger.warn(e.getMessage());
            return 0.0;
        }
    }

    public boolean ifVector() {
        return this._$3;
    }

    public Matrix changeAverageToZero() {
        int r;
        int c;
        double[] sum = new double[this._$4];
        double[] average = new double[this._$4];
        double[][] averageArray = new double[this._$5][this._$4];
        for (c = 0; c < this._$4; ++c) {
            for (r = 0; r < this._$5; ++r) {
                int n = c;
                sum[n] = sum[n] + this.get(r, c);
            }
            average[c] = sum[c] / (double)this._$5;
        }
        for (c = 0; c < this._$4; ++c) {
            for (r = 0; r < this._$5; ++r) {
                averageArray[r][c] = this.get(r, c) - average[c];
            }
        }
        return new Matrix(averageArray);
    }

    public Matrix changeAverageToZero(Vector averageV) {
        double[] average = averageV.getValue();
        double[][] averageArray = new double[this._$5][this._$4];
        for (int c = 0; c < this._$4; ++c) {
            for (int r = 0; r < this._$5; ++r) {
                averageArray[r][c] = this.get(r, c) - average[c];
            }
        }
        return new Matrix(averageArray);
    }

    public Vector getAverage() {
        double[] sum = new double[this._$4];
        double[] average = new double[this._$4];
        for (int c = 0; c < this._$4; ++c) {
            for (int r = 0; r < this._$5; ++r) {
                int n = c;
                sum[n] = sum[n] + this.get(r, c);
            }
            average[c] = sum[c] / (double)this._$5;
        }
        return new Vector(average);
    }

    public static boolean ifZero(double d) {
        return d < 1.0E-14 && d > -1.0E-14;
    }
}

