/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.fn.algebra;

import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.dm.Sequence;
import com.scudata.expression.Function;
import com.scudata.expression.fn.algebra.Matrix;
import com.scudata.expression.fn.algebra.Var;
import com.scudata.expression.fn.algebra.Vector;
import com.scudata.resources.EngineMessage;

public class Normalize
extends Function {
    public void checkValidity() {
        if (this.param == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("norm" + mm.getMessage("function.missingParam"));
        }
        if (!this.param.isLeaf()) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("norm" + mm.getMessage("function.invalidParam"));
        }
    }

    public Object calculate(Context ctx) {
        Object result1 = this.param.getLeafExpression().calculate(ctx);
        if (!(result1 instanceof Sequence)) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("norm" + mm.getMessage("function.paramTypeError"));
        }
        boolean norm = this.option == null || this.option.indexOf(48) < 0;
        boolean std = this.option != null && this.option.indexOf(115) > -1;
        Matrix A = this.normalize((Sequence)result1, norm, std);
        return A.toSequence(this.option, true);
    }

    protected Matrix normalize(Sequence result, boolean norm, boolean std) {
        Matrix A = new Matrix(result);
        Object o1 = result.get(1);
        if (!(o1 instanceof Sequence)) {
            A = A.transpose();
        }
        double[][] vs = A.getArray();
        int rows = A.getRows();
        int cols = A.getCols();
        for (int r = 0; r < rows; ++r) {
            int c;
            double[] row = vs[r];
            double avg = 0.0;
            double sqrsum = 0.0;
            for (c = 0; c < cols; ++c) {
                avg += row[c];
                if (!norm || std) continue;
                sqrsum += row[c] * row[c];
            }
            avg /= (double)cols;
            if (norm && !std) {
                sqrsum = Math.sqrt(sqrsum);
            } else if (std) {
                sqrsum = Var.std(row, true);
            }
            for (c = 0; c < cols; ++c) {
                vs[r][c] = vs[r][c] - avg;
                if (!norm || sqrsum == 0.0) continue;
                vs[r][c] = vs[r][c] / sqrsum;
            }
        }
        return A;
    }

    protected static Vector normalize(Vector A) {
        int c;
        double[] vs = A.getValue();
        int cols = A.len();
        double avg = 0.0;
        for (c = 0; c < cols; ++c) {
            avg += vs[c];
        }
        avg /= (double)cols;
        for (c = 0; c < cols; ++c) {
            vs[c] = vs[c] - avg;
        }
        return A;
    }
}

