/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.fn.algebra;

import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.dm.Sequence;
import com.scudata.expression.Function;
import com.scudata.expression.IParam;
import com.scudata.expression.fn.algebra.Normalize;
import com.scudata.expression.fn.algebra.Vector;
import com.scudata.resources.EngineMessage;

public class Pearson
extends Function {
    public void checkValidity() {
        if (this.param == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("pearson" + mm.getMessage("function.missingParam"));
        }
    }

    public Object calculate(Context ctx) {
        int setn = 0;
        IParam param = this.param;
        if (param.getType() == ';') {
            if (param.getSubSize() != 2) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("pearson" + mm.getMessage("function.invalidParam"));
            }
            IParam locParam = param.getSub(1);
            if (locParam != null) {
                Object obj = locParam.getLeafExpression().calculate(ctx);
                if (obj != null && !(obj instanceof Number)) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("pearson" + mm.getMessage("function.paramTypeError"));
                }
                setn = ((Number)obj).intValue();
            }
            if ((param = param.getSub(0)) == null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("pearson" + mm.getMessage("function.missingParam"));
            }
        }
        Object o1 = null;
        Sequence o2 = null;
        if (param.isLeaf()) {
            o1 = param.getLeafExpression().calculate(ctx);
            if (!(o1 instanceof Sequence)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("pearson" + mm.getMessage("function.paramTypeError"));
            }
        } else {
            if (param.getSubSize() != 2) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("pearson" + mm.getMessage("function.invalidParam"));
            }
            IParam sub1 = param.getSub(0);
            IParam sub2 = param.getSub(1);
            if (sub1 == null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("pearson" + mm.getMessage("function.invalidParam"));
            }
            o1 = sub1.getLeafExpression().calculate(ctx);
            Sequence sequence = o2 = sub2 == null ? null : sub2.getLeafExpression().calculate(ctx);
        }
        if (o2 == null) {
            int len = o1 instanceof Sequence ? ((Sequence)o1).length() : 1;
            o2 = new Sequence(1, len);
        }
        if (o1 instanceof Sequence && o2 instanceof Sequence) {
            boolean ifR2 = false;
            boolean adjust = false;
            if (this.option != null) {
                if (this.option.indexOf(114) > -1) {
                    ifR2 = true;
                }
                if (this.option.indexOf(97) > -1) {
                    adjust = true;
                }
            }
            Vector v1 = new Vector((Sequence)o1);
            Vector v2 = new Vector(o2);
            int n = ((Sequence)o1).length();
            if (adjust && setn > 0) {
                n = setn;
            }
            if (ifR2) {
                v1 = Normalize.normalize(v1);
                v2 = Normalize.normalize(v2);
            }
            return Pearson.pearson(v1, v2, (double)n);
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException("pearson" + mm.getMessage("function.paramTypeError"));
    }

    protected static double pearson(Vector vx, Vector vy, double n) {
        double[] x = vx.getValue();
        double[] y = vy.getValue();
        double X = 0.0;
        double Y = 0.0;
        double XX = 0.0;
        double YY = 0.0;
        double XY = 0.0;
        int i = 0;
        while ((double)i < n) {
            double xcur = x[i];
            double ycur = y[i];
            X += xcur;
            Y += ycur;
            XX += xcur * xcur;
            YY += ycur * ycur;
            XY += xcur * ycur;
            ++i;
        }
        return (n * XY - X * Y) / Math.sqrt(n * XX - X * X) / Math.sqrt(n * YY - Y * Y);
    }

    public static double pearson(Sequence x, Sequence y, double n) {
        double X = 0.0;
        double Y = 0.0;
        double XX = 0.0;
        double YY = 0.0;
        double XY = 0.0;
        int i = 1;
        while ((double)i <= n) {
            Object xo = x.get(i);
            Object yo = y.get(i);
            double xcur = xo instanceof Number ? ((Number)xo).doubleValue() : 0.0;
            double ycur = yo instanceof Number ? ((Number)yo).doubleValue() : 0.0;
            X += xcur;
            Y += ycur;
            XX += xcur * xcur;
            YY += ycur * ycur;
            XY += xcur * ycur;
            ++i;
        }
        return (n * XY - X * Y) / Math.sqrt(n * XX - X * X) / Math.sqrt(n * YY - Y * Y);
    }
}

