/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.fn.algebra;

import com.scudata.expression.fn.algebra.Matrix;

public class SVDecomposition {
    private double[][] _$5;
    private double[][] _$4;
    private double[] _$3;
    private int _$2;
    private int _$1;

    public SVDecomposition(Matrix matrix) {
        int r;
        double t;
        int k;
        int j;
        double[][] A = matrix.getArrayCopy();
        this._$2 = matrix.getRows();
        this._$1 = matrix.getCols();
        int nu = Math.min(this._$2, this._$1);
        this._$3 = new double[Math.min(this._$2 + 1, this._$1)];
        this._$5 = new double[this._$2][nu];
        this._$4 = new double[this._$1][this._$1];
        double[] e = new double[this._$1];
        double[] work = new double[this._$2];
        boolean wantu = true;
        boolean wantv = true;
        int nct = Math.min(this._$2 - 1, this._$1);
        int nrt = Math.max(0, Math.min(this._$1 - 2, this._$2));
        for (int k2 = 0; k2 < Math.max(nct, nrt); ++k2) {
            int r2;
            int r3;
            if (k2 < nct) {
                this._$3[k2] = 0.0;
                for (r3 = k2; r3 < this._$2; ++r3) {
                    this._$3[k2] = Math.hypot(this._$3[k2], A[r3][k2]);
                }
                if (this._$3[k2] != 0.0) {
                    if (A[k2][k2] < 0.0) {
                        this._$3[k2] = -this._$3[k2];
                    }
                    for (r3 = k2; r3 < this._$2; ++r3) {
                        double[] dArray = A[r3];
                        int n = k2;
                        dArray[n] = dArray[n] / this._$3[k2];
                    }
                    double[] dArray = A[k2];
                    int n = k2;
                    dArray[n] = dArray[n] + 1.0;
                }
                this._$3[k2] = -this._$3[k2];
            }
            for (j = k2 + 1; j < this._$1; ++j) {
                if (k2 < nct & this._$3[k2] != 0.0) {
                    double t2 = 0.0;
                    for (r2 = k2; r2 < this._$2; ++r2) {
                        t2 += A[r2][k2] * A[r2][j];
                    }
                    t2 = -t2 / A[k2][k2];
                    for (r2 = k2; r2 < this._$2; ++r2) {
                        double[] dArray = A[r2];
                        int n = j;
                        dArray[n] = dArray[n] + t2 * A[r2][k2];
                    }
                }
                e[j] = A[k2][j];
            }
            if (wantu & k2 < nct) {
                for (r3 = k2; r3 < this._$2; ++r3) {
                    this._$5[r3][k2] = A[r3][k2];
                }
            }
            if (k2 >= nrt) continue;
            e[k2] = 0.0;
            for (r3 = k2 + 1; r3 < this._$1; ++r3) {
                e[k2] = Math.hypot(e[k2], e[r3]);
            }
            if (e[k2] != 0.0) {
                if (e[k2 + 1] < 0.0) {
                    e[k2] = -e[k2];
                }
                r3 = k2 + 1;
                while (r3 < this._$1) {
                    int n = r3++;
                    e[n] = e[n] / e[k2];
                }
                int n = k2 + 1;
                e[n] = e[n] + 1.0;
            }
            e[k2] = -e[k2];
            if (k2 + 1 < this._$2 & e[k2] != 0.0) {
                for (r3 = k2 + 1; r3 < this._$2; ++r3) {
                    work[r3] = 0.0;
                }
                for (j = k2 + 1; j < this._$1; ++j) {
                    for (int r4 = k2 + 1; r4 < this._$2; ++r4) {
                        int n = r4;
                        work[n] = work[n] + e[j] * A[r4][j];
                    }
                }
                for (j = k2 + 1; j < this._$1; ++j) {
                    double t3 = -e[j] / e[k2 + 1];
                    for (r2 = k2 + 1; r2 < this._$2; ++r2) {
                        double[] dArray = A[r2];
                        int n = j;
                        dArray[n] = dArray[n] + t3 * work[r2];
                    }
                }
            }
            if (!wantv) continue;
            for (r3 = k2 + 1; r3 < this._$1; ++r3) {
                this._$4[r3][k2] = e[r3];
            }
        }
        int p = Math.min(this._$1, this._$2 + 1);
        if (nct < this._$1) {
            this._$3[nct] = A[nct][nct];
        }
        if (this._$2 < p) {
            this._$3[p - 1] = 0.0;
        }
        if (nrt + 1 < p) {
            e[nrt] = A[nrt][p - 1];
        }
        e[p - 1] = 0.0;
        if (wantu) {
            for (j = nct; j < nu; ++j) {
                for (int r5 = 0; r5 < this._$2; ++r5) {
                    this._$5[r5][j] = 0.0;
                }
                this._$5[j][j] = 1.0;
            }
            for (k = nct - 1; k >= 0; --k) {
                int r6;
                if (this._$3[k] != 0.0) {
                    for (int j2 = k + 1; j2 < nu; ++j2) {
                        t = 0.0;
                        for (r = k; r < this._$2; ++r) {
                            t += this._$5[r][k] * this._$5[r][j2];
                        }
                        t = -t / this._$5[k][k];
                        for (r = k; r < this._$2; ++r) {
                            double[] dArray = this._$5[r];
                            int n = j2;
                            dArray[n] = dArray[n] + t * this._$5[r][k];
                        }
                    }
                    for (r6 = k; r6 < this._$2; ++r6) {
                        this._$5[r6][k] = -this._$5[r6][k];
                    }
                    this._$5[k][k] = 1.0 + this._$5[k][k];
                    for (r6 = 0; r6 < k - 1; ++r6) {
                        this._$5[r6][k] = 0.0;
                    }
                    continue;
                }
                for (r6 = 0; r6 < this._$2; ++r6) {
                    this._$5[r6][k] = 0.0;
                }
                this._$5[k][k] = 1.0;
            }
        }
        if (wantv) {
            for (k = this._$1 - 1; k >= 0; --k) {
                if (k < nrt & e[k] != 0.0) {
                    for (int j3 = k + 1; j3 < nu; ++j3) {
                        t = 0.0;
                        for (r = k + 1; r < this._$1; ++r) {
                            t += this._$4[r][k] * this._$4[r][j3];
                        }
                        t = -t / this._$4[k + 1][k];
                        for (r = k + 1; r < this._$1; ++r) {
                            double[] dArray = this._$4[r];
                            int n = j3;
                            dArray[n] = dArray[n] + t * this._$4[r][k];
                        }
                    }
                }
                for (int r7 = 0; r7 < this._$1; ++r7) {
                    this._$4[r7][k] = 0.0;
                }
                this._$4[k][k] = 1.0;
            }
        }
        int pp = p - 1;
        int iter = 0;
        double eps = Math.pow(2.0, -52.0);
        double tiny = Math.pow(2.0, -966.0);
        block35: while (p > 0) {
            int kase;
            int k3;
            for (k3 = p - 2; k3 >= -1 && k3 != -1; --k3) {
                if (!(Math.abs(e[k3]) <= tiny + eps * (Math.abs(this._$3[k3]) + Math.abs(this._$3[k3 + 1])))) continue;
                e[k3] = 0.0;
                break;
            }
            if (k3 == p - 2) {
                kase = 4;
            } else {
                int ks;
                for (ks = p - 1; ks >= k3 && ks != k3; --ks) {
                    double t4 = (ks != p ? Math.abs(e[ks]) : 0.0) + (ks != k3 + 1 ? Math.abs(e[ks - 1]) : 0.0);
                    if (!(Math.abs(this._$3[ks]) <= tiny + eps * t4)) continue;
                    this._$3[ks] = 0.0;
                    break;
                }
                if (ks == k3) {
                    kase = 3;
                } else if (ks == p - 1) {
                    kase = 1;
                } else {
                    kase = 2;
                    k3 = ks;
                }
            }
            ++k3;
            switch (kase) {
                case 1: {
                    int r8;
                    double sn;
                    double cs;
                    double t5;
                    double f = e[p - 2];
                    e[p - 2] = 0.0;
                    for (int j4 = p - 2; j4 >= k3; --j4) {
                        t5 = Math.hypot(this._$3[j4], f);
                        cs = this._$3[j4] / t5;
                        sn = f / t5;
                        this._$3[j4] = t5;
                        if (j4 != k3) {
                            f = -sn * e[j4 - 1];
                            e[j4 - 1] = cs * e[j4 - 1];
                        }
                        if (!wantv) continue;
                        for (r8 = 0; r8 < this._$1; ++r8) {
                            t5 = cs * this._$4[r8][j4] + sn * this._$4[r8][p - 1];
                            this._$4[r8][p - 1] = -sn * this._$4[r8][j4] + cs * this._$4[r8][p - 1];
                            this._$4[r8][j4] = t5;
                        }
                    }
                    continue block35;
                }
                case 2: {
                    int r8;
                    double sn;
                    double cs;
                    double t5;
                    double f = e[k3 - 1];
                    e[k3 - 1] = 0.0;
                    for (int j5 = k3; j5 < p; ++j5) {
                        t5 = Math.hypot(this._$3[j5], f);
                        cs = this._$3[j5] / t5;
                        sn = f / t5;
                        this._$3[j5] = t5;
                        f = -sn * e[j5];
                        e[j5] = cs * e[j5];
                        if (!wantu) continue;
                        for (r8 = 0; r8 < this._$2; ++r8) {
                            t5 = cs * this._$5[r8][j5] + sn * this._$5[r8][k3 - 1];
                            this._$5[r8][k3 - 1] = -sn * this._$5[r8][j5] + cs * this._$5[r8][k3 - 1];
                            this._$5[r8][j5] = t5;
                        }
                    }
                    continue block35;
                }
                case 3: {
                    double scale = Math.max(Math.max(Math.max(Math.max(Math.abs(this._$3[p - 1]), Math.abs(this._$3[p - 2])), Math.abs(e[p - 2])), Math.abs(this._$3[k3])), Math.abs(e[k3]));
                    double sp = this._$3[p - 1] / scale;
                    double spm1 = this._$3[p - 2] / scale;
                    double epm1 = e[p - 2] / scale;
                    double sk = this._$3[k3] / scale;
                    double ek = e[k3] / scale;
                    double b = ((spm1 + sp) * (spm1 - sp) + epm1 * epm1) / 2.0;
                    double c = sp * epm1 * (sp * epm1);
                    double shift = 0.0;
                    if (b != 0.0 | c != 0.0) {
                        shift = Math.sqrt(b * b + c);
                        if (b < 0.0) {
                            shift = -shift;
                        }
                        shift = c / (b + shift);
                    }
                    double f = (sk + sp) * (sk - sp) + shift;
                    double g = sk * ek;
                    for (int j6 = k3; j6 < p - 1; ++j6) {
                        int r9;
                        double t6 = Math.hypot(f, g);
                        double cs = f / t6;
                        double sn = g / t6;
                        if (j6 != k3) {
                            e[j6 - 1] = t6;
                        }
                        f = cs * this._$3[j6] + sn * e[j6];
                        e[j6] = cs * e[j6] - sn * this._$3[j6];
                        g = sn * this._$3[j6 + 1];
                        this._$3[j6 + 1] = cs * this._$3[j6 + 1];
                        if (wantv) {
                            for (r9 = 0; r9 < this._$1; ++r9) {
                                t6 = cs * this._$4[r9][j6] + sn * this._$4[r9][j6 + 1];
                                this._$4[r9][j6 + 1] = -sn * this._$4[r9][j6] + cs * this._$4[r9][j6 + 1];
                                this._$4[r9][j6] = t6;
                            }
                        }
                        t6 = Math.hypot(f, g);
                        cs = f / t6;
                        sn = g / t6;
                        this._$3[j6] = t6;
                        f = cs * e[j6] + sn * this._$3[j6 + 1];
                        this._$3[j6 + 1] = -sn * e[j6] + cs * this._$3[j6 + 1];
                        g = sn * e[j6 + 1];
                        e[j6 + 1] = cs * e[j6 + 1];
                        if (!wantu || j6 >= this._$2 - 1) continue;
                        for (r9 = 0; r9 < this._$2; ++r9) {
                            t6 = cs * this._$5[r9][j6] + sn * this._$5[r9][j6 + 1];
                            this._$5[r9][j6 + 1] = -sn * this._$5[r9][j6] + cs * this._$5[r9][j6 + 1];
                            this._$5[r9][j6] = t6;
                        }
                    }
                    e[p - 2] = f;
                    ++iter;
                    break;
                }
                case 4: {
                    if (this._$3[k3] <= 0.0) {
                        double d = this._$3[k3] = this._$3[k3] < 0.0 ? -this._$3[k3] : 0.0;
                        if (wantv) {
                            for (int r10 = 0; r10 <= pp; ++r10) {
                                this._$4[r10][k3] = -this._$4[r10][k3];
                            }
                        }
                    }
                    while (k3 < pp && !(this._$3[k3] >= this._$3[k3 + 1])) {
                        int r11;
                        double t7 = this._$3[k3];
                        this._$3[k3] = this._$3[k3 + 1];
                        this._$3[k3 + 1] = t7;
                        if (wantv && k3 < this._$1 - 1) {
                            for (r11 = 0; r11 < this._$1; ++r11) {
                                t7 = this._$4[r11][k3 + 1];
                                this._$4[r11][k3 + 1] = this._$4[r11][k3];
                                this._$4[r11][k3] = t7;
                            }
                        }
                        if (wantu && k3 < this._$2 - 1) {
                            for (r11 = 0; r11 < this._$2; ++r11) {
                                t7 = this._$5[r11][k3 + 1];
                                this._$5[r11][k3 + 1] = this._$5[r11][k3];
                                this._$5[r11][k3] = t7;
                            }
                        }
                        ++k3;
                    }
                    iter = 0;
                    --p;
                }
            }
        }
    }

    public Matrix getU() {
        return new Matrix(this._$5, this._$2, Math.min(this._$2 + 1, this._$1));
    }

    public Matrix getV() {
        return new Matrix(this._$4, this._$1, this._$1);
    }

    public double[] getSingularValues() {
        return this._$3;
    }

    public Matrix getS() {
        Matrix X = new Matrix(this._$1, this._$1);
        double[][] S = X.getArray();
        for (int r = 0; r < this._$1; ++r) {
            for (int j = 0; j < this._$1; ++j) {
                S[r][j] = 0.0;
            }
            S[r][r] = this._$3[r];
        }
        return X;
    }

    public double norm2() {
        return this._$3[0];
    }

    public double cond() {
        return this._$3[0] / this._$3[Math.min(this._$2, this._$1) - 1];
    }

    public int rank() {
        double eps = Math.pow(2.0, -52.0);
        double tol = (double)Math.max(this._$2, this._$1) * this._$3[0] * eps;
        int rank = 0;
        for (int r = 0; r < this._$3.length; ++r) {
            if (!(this._$3[r] > tol)) continue;
            ++rank;
        }
        return rank;
    }
}

