/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.fn.algebra;

import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.dm.Sequence;
import com.scudata.expression.Function;
import com.scudata.resources.EngineMessage;

public class Transpose
extends Function {
    public void checkValidity() {
        if (this.param == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("transpose" + mm.getMessage("function.missingParam"));
        }
        if (!this.param.isLeaf()) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("transpose" + mm.getMessage("function.invalidParam"));
        }
    }

    public Object calculate(Context ctx) {
        Sequence result;
        Object result1 = this.param.getLeafExpression().calculate(ctx);
        if (!(result1 instanceof Sequence)) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("transpose" + mm.getMessage("function.paramTypeError"));
        }
        boolean ifn = this.option != null && this.option.indexOf(110) > -1;
        Sequence seq = (Sequence)result1;
        int rows = seq.length();
        int cols = 0;
        for (int r = 1; r <= rows; ++r) {
            Object o = seq.get(r);
            if (!(o instanceof Sequence)) continue;
            cols = Math.max(cols, ((Sequence)o).length());
        }
        Double zero = 0.0;
        if (ifn) {
            zero = null;
        }
        if (cols == 0) {
            result = new Sequence(rows);
            for (int r = 1; r <= rows; ++r) {
                Object o = seq.get(r);
                Sequence sub = new Sequence(1);
                sub.add(o);
                result.add(sub);
            }
            return result;
        }
        result = new Sequence(cols);
        for (int c = 1; c <= cols; ++c) {
            Sequence sub = new Sequence(rows);
            for (int r = 1; r <= rows; ++r) {
                Object o = seq.get(r);
                if (o instanceof Sequence) {
                    Sequence subSeq = (Sequence)o;
                    o = subSeq.length() >= c ? subSeq.get(c) : zero;
                } else if (c > 1) {
                    o = zero;
                }
                sub.add(o);
            }
            result.add(sub);
        }
        return result;
    }
}

