/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.fn.algebra;

import com.scudata.array.IArray;
import com.scudata.array.ObjectArray;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.dm.Sequence;
import com.scudata.expression.Expression;
import com.scudata.expression.Gather;
import com.scudata.expression.fn.algebra.VarValue;
import com.scudata.resources.EngineMessage;

public class Var
extends Gather {
    private Expression _$3;
    private boolean _$2;
    private boolean _$1;

    public void checkValidity() {
        if (this.param != null && !this.param.isLeaf()) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("var" + mm.getMessage("function.invalidParam"));
        }
    }

    public Object calculate(Context ctx) {
        if (this.param == null) {
            return null;
        }
        Object result1 = this.param.getLeafExpression().calculate(ctx);
        if (!(result1 instanceof Sequence)) {
            if (result1 == null) {
                return null;
            }
            if (result1 instanceof Number) {
                return 0.0;
            }
            MessageManager mm = EngineMessage.get();
            throw new RQException("var" + mm.getMessage("function.paramTypeError"));
        }
        Sequence ser = (Sequence)result1;
        if (ser.length() == 0) {
            return null;
        }
        if (this.option != null) {
            this._$2 = this.option.indexOf(115) > -1;
            this._$1 = this.option.indexOf(114) > -1;
        }
        return Var.var(ser, this._$2, this._$1);
    }

    protected static Object var(Sequence ser, boolean sta, boolean root) {
        Object avg = ser.average();
        if (avg instanceof Number) {
            double avgValue = ((Number)avg).doubleValue();
            int n = ser.length();
            double result = 0.0;
            for (int i = 1; i <= n; ++i) {
                double v;
                Number tmp = (Number)ser.get(i);
                double d = v = tmp == null ? 0.0 : tmp.doubleValue();
                if (tmp == null) continue;
                result += Math.pow(v - avgValue, 2.0);
            }
            result = sta ? (result /= (double)(n - 1)) : (result /= (double)n);
            if (root) {
                return Math.sqrt(result);
            }
            return result;
        }
        if (avg == null) {
            return null;
        }
        return 0.0;
    }

    protected static double var(double[] vs, boolean sta) {
        double sum = 0.0;
        int n = vs.length;
        if (n < 1) {
            return 0.0;
        }
        for (int i = 0; i < n; ++i) {
            sum += vs[i];
        }
        double avg = sum / (double)n;
        double result = 0.0;
        for (int i = 0; i < n; ++i) {
            result += Math.pow(vs[i] - avg, 2.0);
        }
        if (sta) {
            return result / (double)(n - 1);
        }
        return result / (double)n;
    }

    protected static Object std(Sequence ser, boolean sta) {
        return Var.var(ser, sta, true);
    }

    protected static double std(double[] vs, boolean sta) {
        double var = Var.var(vs, sta);
        return Math.sqrt(var);
    }

    public void prepare(Context ctx) {
        if (this.param == null || !this.param.isLeaf()) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("var" + mm.getMessage("function.invalidParam"));
        }
        this._$3 = this.param.getLeafExpression();
        if (this.option != null) {
            this._$2 = this.option.indexOf(115) > -1;
            this._$1 = this.option.indexOf(114) > -1;
        }
    }

    public Object gather(Context ctx) {
        Object val = this._$3.calculate(ctx);
        if (val instanceof VarValue) {
            return val;
        }
        return new VarValue(val);
    }

    public Object gather(Object oldValue, Context ctx) {
        Object val = this._$3.calculate(ctx);
        if (oldValue == null) {
            if (val instanceof VarValue) {
                return val;
            }
            return new VarValue(val);
        }
        ((VarValue)oldValue).add(val);
        return oldValue;
    }

    public Expression getRegatherExpression(int q) {
        String str = "var";
        if (this.option != null) {
            str = str + "@" + this.option;
        }
        str = str + "(#" + q + ")";
        return new Expression(str);
    }

    public boolean needFinish() {
        return true;
    }

    public Object finish(Object val) {
        if (val instanceof VarValue) {
            return ((VarValue)val).getVar(this._$2, this._$1);
        }
        if (val instanceof Sequence) {
            return Var.var((Sequence)val, this._$2, this._$1);
        }
        if (val instanceof Number) {
            return 0.0;
        }
        return null;
    }

    public Expression getExp() {
        return this._$3;
    }

    public IArray gather(IArray result, int[] resultSeqs, Context ctx) {
        IArray array = this._$3.calculateAll(ctx);
        if (result == null) {
            result = new ObjectArray(8191);
        }
        int len = array.size();
        for (int i = 1; i <= len; ++i) {
            VarValue vv;
            if (result.size() < resultSeqs[i]) {
                vv = new VarValue(array.get(i));
                result.add(vv);
                continue;
            }
            vv = (VarValue)result.get(resultSeqs[i]);
            vv.add(array.get(i));
        }
        return result;
    }

    public void gather2(IArray result, IArray result2, int[] seqs, Context ctx) {
        int len = result2.size();
        for (int i = 1; i <= len; ++i) {
            if (seqs[i] == 0) continue;
            VarValue vv1 = (VarValue)result.get(seqs[i]);
            VarValue vv2 = (VarValue)result2.get(i);
            if (vv1 == null) {
                result.set(seqs[i], vv2);
                continue;
            }
            if (vv2 == null) continue;
            vv1.add(vv2);
        }
    }

    public IArray finish(IArray array) {
        int size = array.size();
        for (int i = 1; i <= size; ++i) {
            VarValue vv = (VarValue)array.get(i);
            Object var = vv.getVar(this._$2, this._$1);
            array.set(i, var);
        }
        return array;
    }
}

