/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.fn.convert;

import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.common.Sentence;
import com.scudata.common.StringUtils;
import com.scudata.dm.Context;
import com.scudata.expression.Function;
import com.scudata.resources.EngineMessage;
import com.scudata.util.Variant;

public class Parse
extends Function {
    public void checkValidity() {
        if (this.param == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("parse" + mm.getMessage("function.missingParam"));
        }
        if (!this.param.isLeaf()) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("parse" + mm.getMessage("function.invalidParam"));
        }
    }

    public Object calculate(Context ctx) {
        Object obj = this.param.getLeafExpression().calculate(ctx);
        if (!(obj instanceof String)) {
            return obj;
        }
        String str = (String)obj;
        if (this.option != null) {
            char c;
            int start;
            int len;
            if (this.option.indexOf(113) != -1) {
                len = str.length();
                for (start = 0; start < len; ++start) {
                    c = str.charAt(start);
                    if (c == '\"' || c == '\'') {
                        int match = Sentence.scanQuotation(str, start);
                        if (match <= 0) continue;
                        if (this.option.indexOf(101) != -1) {
                            return StringUtils.unicode(str.substring(start + 1, match));
                        }
                        return str.substring(start, match + 1);
                    }
                    if (!Character.isWhitespace(c)) break;
                }
            }
            if (this.option.indexOf(101) != -1) {
                int last = (str = StringUtils.unicode(str)).length() - 1;
                if (last > 0) {
                    char e;
                    char s = str.charAt(0);
                    if (s == (e = str.charAt(last)) && (s == '\"' || s == '\'')) {
                        return str.substring(1, last);
                    }
                    return Variant.parse(str, true);
                }
            } else if (this.option.indexOf(110) != -1) {
                char c2;
                int end;
                len = str.length();
                for (start = 0; start < len; ++start) {
                    c = str.charAt(start);
                    if (Character.isWhitespace(c)) continue;
                    if (c >= '0' && c <= '9' || c == '-' || c == '.') break;
                    return null;
                }
                if (start == len) {
                    return null;
                }
                for (end = start + 1; end < len && ((c2 = str.charAt(end)) >= '0' && c2 <= '9' || c2 == '.'); ++end) {
                }
                if (start != 0 || end != len) {
                    return Variant.parseNumber(str.substring(start, end));
                }
                return Variant.parseNumber(str);
            }
        }
        return Variant.parse(str, false);
    }
}

