/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.fn.convert;

import com.scudata.array.IArray;
import com.scudata.array.IntArray;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.expression.Function;
import com.scudata.expression.IParam;
import com.scudata.resources.EngineMessage;

public class RGB
extends Function {
    public void checkValidity() {
        if (this.param == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("rgb" + mm.getMessage("function.missingParam"));
        }
    }

    public Object calculate(Context ctx) {
        IParam sub4;
        int size = this.param.getSubSize();
        if (size < 3 || size > 4) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("rgb" + mm.getMessage("function.invalidParam"));
        }
        int a = 255;
        IParam sub1 = this.param.getSub(0);
        IParam sub2 = this.param.getSub(1);
        IParam sub3 = this.param.getSub(2);
        if (sub1 == null || sub2 == null || sub3 == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("rgb" + mm.getMessage("function.invalidParam"));
        }
        Object result1 = sub1.getLeafExpression().calculate(ctx);
        if (!(result1 instanceof Number)) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("rgb" + mm.getMessage("function.paramTypeError"));
        }
        int r = ((Number)result1).intValue();
        Object result2 = sub2.getLeafExpression().calculate(ctx);
        if (!(result2 instanceof Number)) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("rgb" + mm.getMessage("function.paramTypeError"));
        }
        int g = ((Number)result2).intValue();
        Object result3 = sub3.getLeafExpression().calculate(ctx);
        if (!(result3 instanceof Number)) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("rgb" + mm.getMessage("function.paramTypeError"));
        }
        int b = ((Number)result3).intValue();
        if (size == 4 && (sub4 = this.param.getSub(3)) != null) {
            Object result4 = sub4.getLeafExpression().calculate(ctx);
            if (result4 instanceof Number) {
                a = ((Number)result4).intValue();
            } else {
                MessageManager mm = EngineMessage.get();
                throw new RQException("rgb" + mm.getMessage("function.paramTypeError"));
            }
        }
        return (a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | (b & 0xFF) << 0;
    }

    public IArray calculateAll(Context ctx) {
        int size = this.param.getSubSize();
        if (size < 3 || size > 4) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("rgb" + mm.getMessage("function.invalidParam"));
        }
        IParam sub1 = this.param.getSub(0);
        IParam sub2 = this.param.getSub(1);
        IParam sub3 = this.param.getSub(2);
        if (sub1 == null || sub2 == null || sub3 == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("rgb" + mm.getMessage("function.invalidParam"));
        }
        IArray array1 = sub1.getLeafExpression().calculateAll(ctx);
        if (!array1.isNumberArray()) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("rgb" + mm.getMessage("function.paramTypeError"));
        }
        IArray array2 = sub2.getLeafExpression().calculateAll(ctx);
        if (!array2.isNumberArray()) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("rgb" + mm.getMessage("function.paramTypeError"));
        }
        IArray array3 = sub3.getLeafExpression().calculateAll(ctx);
        if (!array3.isNumberArray()) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("rgb" + mm.getMessage("function.paramTypeError"));
        }
        int len = array1.size();
        int[] resultValues = new int[len + 1];
        if (size == 4) {
            IParam sub4 = this.param.getSub(3);
            IArray array4 = sub4.getLeafExpression().calculateAll(ctx);
            if (!array4.isNumberArray()) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("rgb" + mm.getMessage("function.paramTypeError"));
            }
            for (int i = 1; i <= len; ++i) {
                int r = array1.getInt(i);
                int g = array2.getInt(i);
                int b = array3.getInt(i);
                int a = array4.getInt(i);
                resultValues[i] = (a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | (b & 0xFF) << 0;
            }
        } else {
            int a = -16777216;
            for (int i = 1; i <= len; ++i) {
                int r = array1.getInt(i);
                int g = array2.getInt(i);
                int b = array3.getInt(i);
                resultValues[i] = a | (r & 0xFF) << 16 | (g & 0xFF) << 8 | (b & 0xFF) << 0;
            }
        }
        IntArray result = new IntArray(resultValues, null, len);
        result.setTemporary(true);
        return result;
    }
}

