/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.fn.convert;

import com.scudata.array.IArray;
import com.scudata.array.IntArray;
import com.scudata.common.MessageManager;
import com.scudata.common.ObjectCache;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.expression.Function;
import com.scudata.resources.EngineMessage;

public class ToInteger
extends Function {
    public void checkValidity() {
        if (this.param == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("int" + mm.getMessage("function.missingParam"));
        }
        if (!this.param.isLeaf()) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("int" + mm.getMessage("function.invalidParam"));
        }
    }

    public Object calculate(Context ctx) {
        Object result = this.param.getLeafExpression().calculate(ctx);
        if (result instanceof Integer) {
            return result;
        }
        if (result instanceof Number) {
            return ObjectCache.getInteger(((Number)result).intValue());
        }
        if (result instanceof String) {
            try {
                double d = Double.parseDouble((String)result);
                return ObjectCache.getInteger((int)d);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        if (result == null) {
            return null;
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException("int" + mm.getMessage("function.paramTypeError"));
    }

    public IArray calculateAll(Context ctx) {
        IArray array = this.param.getLeafExpression().calculateAll(ctx);
        if (array instanceof IntArray) {
            return array;
        }
        int len = array.size();
        IntArray result = new IntArray(len);
        result.setTemporary(true);
        if (array.isNumberArray()) {
            for (int i = 1; i <= len; ++i) {
                if (array.isNull(i)) {
                    result.pushNull();
                    continue;
                }
                result.pushInt(array.getInt(i));
            }
        } else {
            for (int i = 1; i <= len; ++i) {
                Object obj = array.get(i);
                if (obj instanceof Number) {
                    result.pushInt(((Number)obj).intValue());
                    continue;
                }
                if (obj instanceof String) {
                    result.pushInt(Integer.parseInt((String)obj));
                    continue;
                }
                if (obj == null) {
                    result.pushNull();
                    continue;
                }
                MessageManager mm = EngineMessage.get();
                throw new RQException("float" + mm.getMessage("function.paramTypeError"));
            }
        }
        return result;
    }
}

