/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.fn.convert;

import com.scudata.array.IArray;
import com.scudata.array.LongArray;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.expression.Function;
import com.scudata.expression.IParam;
import com.scudata.resources.EngineMessage;
import com.scudata.util.Variant;
import java.util.Date;

public class ToLong
extends Function {
    public void checkValidity() {
        if (this.param == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("long" + mm.getMessage("function.missingParam"));
        }
    }

    public Object calculate(Context ctx) {
        if (this.param.isLeaf()) {
            Object result = this.param.getLeafExpression().calculate(ctx);
            if (result instanceof Long) {
                return result;
            }
            if (result instanceof Number) {
                return new Long(((Number)result).longValue());
            }
            if (result instanceof String) {
                try {
                    return Long.parseLong((String)result);
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
            if (result instanceof Date) {
                return new Long(((Date)result).getTime());
            }
            if (result == null) {
                return null;
            }
            MessageManager mm = EngineMessage.get();
            throw new RQException("long" + mm.getMessage("function.paramTypeError"));
        }
        if (this.param.getSubSize() == 2) {
            IParam sub0 = this.param.getSub(0);
            IParam sub1 = this.param.getSub(1);
            if (sub0 == null || sub1 == null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("long" + mm.getMessage("function.invalidParam"));
            }
            Object str = sub0.getLeafExpression().calculate(ctx);
            if (!(str instanceof String)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("long" + mm.getMessage("function.paramTypeError"));
            }
            Object radix = sub1.getLeafExpression().calculate(ctx);
            if (!(radix instanceof Number)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("long" + mm.getMessage("function.paramTypeError"));
            }
            return Variant.parseLong((String)str, ((Number)radix).intValue());
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException("long" + mm.getMessage("function.invalidParam"));
    }

    public IArray calculateAll(Context ctx) {
        if (this.param.isLeaf()) {
            IArray array = this.param.getLeafExpression().calculateAll(ctx);
            if (array instanceof LongArray) {
                return array;
            }
            int len = array.size();
            LongArray result = new LongArray(len);
            result.setTemporary(true);
            if (array.isNumberArray()) {
                for (int i = 1; i <= len; ++i) {
                    if (array.isNull(i)) {
                        result.pushNull();
                        continue;
                    }
                    result.pushLong(array.getLong(i));
                }
            } else {
                for (int i = 1; i <= len; ++i) {
                    Object obj = array.get(i);
                    if (obj instanceof Number) {
                        result.pushLong(((Number)obj).longValue());
                        continue;
                    }
                    if (obj instanceof String) {
                        result.pushLong(Long.parseLong((String)obj));
                        continue;
                    }
                    if (obj instanceof Date) {
                        result.pushLong(((Date)obj).getTime());
                        continue;
                    }
                    if (obj == null) {
                        result.pushNull();
                        continue;
                    }
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("float" + mm.getMessage("function.paramTypeError"));
                }
            }
            return result;
        }
        if (this.param.getSubSize() == 2) {
            IParam sub0 = this.param.getSub(0);
            IParam sub1 = this.param.getSub(1);
            if (sub0 == null || sub1 == null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("long" + mm.getMessage("function.invalidParam"));
            }
            IArray array = sub1.getLeafExpression().calculateAll(ctx);
            Object obj = array.get(1);
            if (!(obj instanceof Number)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("long" + mm.getMessage("function.paramTypeError"));
            }
            int radix = ((Number)obj).intValue();
            array = sub0.getLeafExpression().calculateAll(ctx);
            int len = array.size();
            LongArray result = new LongArray(len);
            result.setTemporary(true);
            for (int i = 1; i <= len; ++i) {
                Object str = array.get(i);
                if (str instanceof String) {
                    result.pushLong(Variant.parseLongValue((String)str, radix));
                    continue;
                }
                if (str == null) {
                    result.pushNull();
                    continue;
                }
                MessageManager mm = EngineMessage.get();
                throw new RQException("long" + mm.getMessage("function.paramTypeError"));
            }
            return result;
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException("long" + mm.getMessage("function.invalidParam"));
    }
}

