/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.fn.datetime;

import com.scudata.common.DateFactory;
import com.scudata.common.DateFormatFactory;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.expression.Function;
import com.scudata.expression.IParam;
import com.scudata.resources.EngineMessage;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;

public class DateTime
extends Function {
    public void checkValidity() {
        if (this.param == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("datetime" + mm.getMessage("function.missingParam"));
        }
    }

    public Object calculate(Context ctx) {
        int size = this.param.getSubSize();
        if (size == 0) {
            Object result1 = this.param.getLeafExpression().calculate(ctx);
            if (result1 == null) {
                return null;
            }
            if (result1 instanceof String) {
                try {
                    return DateFactory.parseDateTime((String)result1);
                }
                catch (ParseException e) {
                    return null;
                }
            }
            if (result1 instanceof Number) {
                return new Timestamp(((Number)result1).longValue());
            }
            if (result1 instanceof Timestamp) {
                if (this.option != null) {
                    if (this.option.indexOf(115) != -1) {
                        Calendar calendar = Calendar.getInstance();
                        calendar.setTime((Date)result1);
                        calendar.set(14, 0);
                        return new Timestamp(calendar.getTimeInMillis());
                    }
                    if (this.option.indexOf(109) != -1) {
                        Calendar calendar = Calendar.getInstance();
                        calendar.setTime((Date)result1);
                        calendar.set(13, 0);
                        calendar.set(14, 0);
                        return new Timestamp(calendar.getTimeInMillis());
                    }
                    if (this.option.indexOf(104) != -1) {
                        Calendar calendar = Calendar.getInstance();
                        calendar.setTime((Date)result1);
                        calendar.set(12, 0);
                        calendar.set(13, 0);
                        calendar.set(14, 0);
                        return new Timestamp(calendar.getTimeInMillis());
                    }
                }
                return result1;
            }
            if (result1 instanceof Date) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime((Date)result1);
                if (this.option != null) {
                    if (this.option.indexOf(115) != -1) {
                        calendar.set(14, 0);
                    } else if (this.option.indexOf(109) != -1) {
                        calendar.set(13, 0);
                        calendar.set(14, 0);
                    } else if (this.option.indexOf(104) != -1) {
                        calendar.set(12, 0);
                        calendar.set(13, 0);
                        calendar.set(14, 0);
                    } else {
                        calendar.set(11, 0);
                        calendar.set(12, 0);
                        calendar.set(13, 0);
                        calendar.set(14, 0);
                    }
                } else {
                    calendar.set(11, 0);
                    calendar.set(12, 0);
                    calendar.set(13, 0);
                    calendar.set(14, 0);
                }
                return new Timestamp(calendar.getTimeInMillis());
            }
            MessageManager mm = EngineMessage.get();
            throw new RQException("datetime" + mm.getMessage("function.paramTypeError"));
        }
        if (size == 2) {
            String format;
            IParam sub1 = this.param.getSub(0);
            IParam sub2 = this.param.getSub(1);
            if (sub1 == null || sub2 == null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("datetime" + mm.getMessage("function.invalidParam"));
            }
            Object result1 = sub1.getLeafExpression().calculate(ctx);
            if (result1 == null) {
                return null;
            }
            if (sub2.isLeaf()) {
                Object result2 = sub2.getLeafExpression().calculate(ctx);
                if (result1 instanceof String) {
                    if (result2 instanceof String) {
                        try {
                            DateFormat df = DateFormatFactory.get().getFormat((String)result2);
                            return new Timestamp(df.parse((String)result1).getTime());
                        }
                        catch (ParseException e) {
                            return null;
                        }
                    }
                    if (result2 == null) {
                        try {
                            return DateFactory.parseDateTime((String)result1);
                        }
                        catch (ParseException e) {
                            return null;
                        }
                    }
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("datetime" + mm.getMessage("function.paramTypeError"));
                }
                if (result1 instanceof Date) {
                    Date date = (Date)result1;
                    if (result2 instanceof Date) {
                        Date time = (Date)result2;
                        DateFactory ds = DateFactory.get();
                        Calendar calendar = Calendar.getInstance();
                        calendar.set(ds.year(date), ds.month(date) - 1, ds.day(date), ds.hour(time), ds.minute(time), ds.second(time));
                        calendar.set(14, ds.millisecond(time));
                        return new Timestamp(calendar.getTimeInMillis());
                    }
                    if (result2 == null) {
                        DateFactory ds = DateFactory.get();
                        Calendar calendar = Calendar.getInstance();
                        calendar.set(ds.year(date), ds.month(date) - 1, ds.day(date), 0, 0, 0);
                        calendar.set(14, 0);
                        return new Timestamp(calendar.getTimeInMillis());
                    }
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("datetime" + mm.getMessage("function.paramTypeError"));
                }
                MessageManager mm = EngineMessage.get();
                throw new RQException("datetime" + mm.getMessage("function.paramTypeError"));
            }
            if (!(result1 instanceof String)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("datetime" + mm.getMessage("function.paramTypeError"));
            }
            IParam fmtParam = sub2.getSub(0);
            if (fmtParam == null) {
                format = DateFormatFactory.getDefaultDateTimeFormat();
            } else {
                Object obj = fmtParam.getLeafExpression().calculate(ctx);
                if (!(obj instanceof String)) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("datetime" + mm.getMessage("function.paramTypeError"));
                }
                format = (String)obj;
            }
            String locale = null;
            IParam locParam = sub2.getSub(1);
            if (locParam != null) {
                Object obj = locParam.getLeafExpression().calculate(ctx);
                if (!(obj instanceof String)) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("datetime" + mm.getMessage("function.paramTypeError"));
                }
                locale = (String)obj;
            }
            try {
                DateFormat df = DateFormatFactory.get().getFormat(format, locale);
                return new Timestamp(df.parse((String)result1).getTime());
            }
            catch (ParseException e) {
                return null;
            }
        }
        if (size == 6) {
            IParam sub1 = this.param.getSub(0);
            IParam sub2 = this.param.getSub(1);
            IParam sub3 = this.param.getSub(2);
            IParam sub4 = this.param.getSub(3);
            IParam sub5 = this.param.getSub(4);
            IParam sub6 = this.param.getSub(5);
            if (sub1 == null || sub2 == null || sub3 == null || sub4 == null || sub5 == null || sub6 == null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("datetime" + mm.getMessage("function.invalidParam"));
            }
            Object result1 = sub1.getLeafExpression().calculate(ctx);
            if (!(result1 instanceof Number)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("datetime" + mm.getMessage("function.paramTypeError"));
            }
            int year = ((Number)result1).intValue();
            Object obj = sub2.getLeafExpression().calculate(ctx);
            if (!(obj instanceof Number)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("datetime" + mm.getMessage("function.paramTypeError"));
            }
            int month = ((Number)obj).intValue();
            obj = sub3.getLeafExpression().calculate(ctx);
            if (!(obj instanceof Number)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("datetime" + mm.getMessage("function.paramTypeError"));
            }
            int day = ((Number)obj).intValue();
            obj = sub4.getLeafExpression().calculate(ctx);
            if (!(obj instanceof Number)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("datetime" + mm.getMessage("function.paramTypeError"));
            }
            int hour = ((Number)obj).intValue();
            obj = sub5.getLeafExpression().calculate(ctx);
            if (!(obj instanceof Number)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("datetime" + mm.getMessage("function.paramTypeError"));
            }
            int minute = ((Number)obj).intValue();
            obj = sub6.getLeafExpression().calculate(ctx);
            if (!(obj instanceof Number)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("datetime" + mm.getMessage("function.paramTypeError"));
            }
            int second = ((Number)obj).intValue();
            Calendar calendar = Calendar.getInstance();
            calendar.set(year, month - 1, day, hour, minute, second);
            calendar.set(14, 0);
            return new Timestamp(calendar.getTimeInMillis());
        }
        if (size == 5) {
            IParam sub1 = this.param.getSub(0);
            IParam sub2 = this.param.getSub(1);
            IParam sub3 = this.param.getSub(2);
            IParam sub4 = this.param.getSub(3);
            IParam sub5 = this.param.getSub(4);
            if (sub1 == null || sub2 == null || sub3 == null || sub4 == null || sub5 == null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("datetime" + mm.getMessage("function.invalidParam"));
            }
            Object result1 = sub1.getLeafExpression().calculate(ctx);
            if (!(result1 instanceof Number)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("datetime" + mm.getMessage("function.paramTypeError"));
            }
            int ym = ((Number)result1).intValue();
            if (ym < 9999) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("date" + mm.getMessage("function.invalidParam"));
            }
            int year = ym / 100;
            int month = ym % 100;
            Object obj = sub2.getLeafExpression().calculate(ctx);
            if (!(obj instanceof Number)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("datetime" + mm.getMessage("function.paramTypeError"));
            }
            int day = ((Number)obj).intValue();
            obj = sub3.getLeafExpression().calculate(ctx);
            if (!(obj instanceof Number)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("datetime" + mm.getMessage("function.paramTypeError"));
            }
            int hour = ((Number)obj).intValue();
            obj = sub4.getLeafExpression().calculate(ctx);
            if (!(obj instanceof Number)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("datetime" + mm.getMessage("function.paramTypeError"));
            }
            int minute = ((Number)obj).intValue();
            obj = sub5.getLeafExpression().calculate(ctx);
            if (!(obj instanceof Number)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("datetime" + mm.getMessage("function.paramTypeError"));
            }
            int second = ((Number)obj).intValue();
            Calendar calendar = Calendar.getInstance();
            calendar.set(year, month - 1, day, hour, minute, second);
            calendar.set(14, 0);
            return new Timestamp(calendar.getTimeInMillis());
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException("datetime" + mm.getMessage("function.invalidParam"));
    }
}

