/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.fn.datetime;

import com.scudata.array.ConstArray;
import com.scudata.array.DateArray;
import com.scudata.array.DoubleArray;
import com.scudata.array.IArray;
import com.scudata.array.LongArray;
import com.scudata.array.NumberArray;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.expression.Expression;
import com.scudata.expression.Function;
import com.scudata.expression.IParam;
import com.scudata.resources.EngineMessage;
import com.scudata.util.Variant;
import java.util.Date;

public class Interval
extends Function {
    private Expression _$2;
    private Expression _$1;

    public void checkValidity() {
        if (this.param == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("interval" + mm.getMessage("function.missingParam"));
        }
        if (this.param.getSubSize() != 2) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("interval" + mm.getMessage("function.invalidParam"));
        }
        IParam sub1 = this.param.getSub(0);
        IParam sub2 = this.param.getSub(1);
        if (sub1 == null || sub2 == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("interval" + mm.getMessage("function.invalidParam"));
        }
        this._$2 = sub1.getLeafExpression();
        this._$1 = sub2.getLeafExpression();
    }

    public Object calculate(Context ctx) {
        Object result1 = this._$2.calculate(ctx);
        Object result2 = this._$1.calculate(ctx);
        if (result1 == null || result2 == null) {
            return null;
        }
        if (this.option == null || this.option.indexOf(114) == -1) {
            return new Long(this._$2(result1, result2));
        }
        return new Double(this._$1(result1, result2));
    }

    public IArray calculateAll(Context ctx) {
        boolean isInterval;
        IArray array1 = this._$2.calculateAll(ctx);
        IArray array2 = this._$1.calculateAll(ctx);
        int size = array1.size();
        boolean bl = isInterval = this.option == null || this.option.indexOf(114) == -1;
        if (array1 instanceof ConstArray && array2 instanceof ConstArray) {
            Object obj1 = array1.get(1);
            Object obj2 = array2.get(1);
            Number result = null;
            if (obj1 != null && obj2 != null) {
                result = isInterval ? (Number)this._$2(obj1, obj2) : (Number)this._$1(obj1, obj2);
            }
            return new ConstArray(result, size);
        }
        if (array1 instanceof DateArray && array2 instanceof DateArray) {
            DateArray dateArray1 = (DateArray)array1;
            DateArray dateArray2 = (DateArray)array2;
            if (isInterval) {
                LongArray result = new LongArray(size);
                result.setTemporary(true);
                for (int i = 1; i <= size; ++i) {
                    Date date1 = dateArray1.getDate(i);
                    Date date2 = dateArray2.getDate(i);
                    if (date1 != null && date2 != null) {
                        result.pushLong(Variant.interval(date1, date2, this.option));
                        continue;
                    }
                    result.pushNull();
                }
                return result;
            }
            DoubleArray result = new DoubleArray(size);
            result.setTemporary(true);
            for (int i = 1; i <= size; ++i) {
                Date date1 = dateArray1.getDate(i);
                Date date2 = dateArray2.getDate(i);
                if (date1 != null && date2 != null) {
                    result.pushDouble(Variant.realInterval(date1, date2, this.option));
                    continue;
                }
                result.pushNull();
            }
            return result;
        }
        if (array1 instanceof NumberArray && array2 instanceof NumberArray) {
            NumberArray dateArray1 = (NumberArray)array1;
            NumberArray dateArray2 = (NumberArray)array2;
            if (isInterval) {
                LongArray result = new LongArray(size);
                result.setTemporary(true);
                for (int i = 1; i <= size; ++i) {
                    if (!dateArray1.isNull(i) && !dateArray2.isNull(i)) {
                        int date1 = dateArray1.getInt(i);
                        int date2 = dateArray2.getInt(i);
                        result.pushLong(Variant.interval(date1, date2, this.option));
                        continue;
                    }
                    result.pushNull();
                }
                return result;
            }
            DoubleArray result = new DoubleArray(size);
            result.setTemporary(true);
            for (int i = 1; i <= size; ++i) {
                if (!dateArray1.isNull(i) && !dateArray2.isNull(i)) {
                    int date1 = dateArray1.getInt(i);
                    int date2 = dateArray2.getInt(i);
                    result.pushDouble(Variant.realInterval(date1, date2, this.option));
                    continue;
                }
                result.pushNull();
            }
            return result;
        }
        if (isInterval) {
            LongArray result = new LongArray(size);
            result.setTemporary(true);
            for (int i = 1; i <= size; ++i) {
                Object date1 = array1.get(i);
                Object date2 = array2.get(i);
                if (date1 != null && date2 != null) {
                    result.pushLong(this._$2(date1, date2));
                    continue;
                }
                result.pushNull();
            }
            return result;
        }
        DoubleArray result = new DoubleArray(size);
        result.setTemporary(true);
        for (int i = 1; i <= size; ++i) {
            Object date1 = array1.get(i);
            Object date2 = array2.get(i);
            if (date1 != null && date2 != null) {
                result.pushDouble(this._$1(date1, date2));
                continue;
            }
            result.pushNull();
        }
        return result;
    }

    public IArray calculateAll(Context ctx, IArray signArray, boolean sign) {
        boolean isInterval;
        IArray array1 = this._$2.calculateAll(ctx);
        IArray array2 = this._$1.calculateAll(ctx);
        int size = array1.size();
        boolean bl = isInterval = this.option == null || this.option.indexOf(114) == -1;
        if (array1 instanceof ConstArray && array2 instanceof ConstArray) {
            Object obj1 = array1.get(1);
            Object obj2 = array2.get(1);
            Number result = null;
            if (obj1 != null && obj2 != null) {
                result = isInterval ? (Number)this._$2(obj1, obj2) : (Number)this._$1(obj1, obj2);
            }
            return new ConstArray(result, size);
        }
        boolean[] signDatas = sign ? signArray.isTrue().getDatas() : signArray.isFalse().getDatas();
        if (array1 instanceof DateArray && array2 instanceof DateArray) {
            DateArray dateArray1 = (DateArray)array1;
            DateArray dateArray2 = (DateArray)array2;
            if (isInterval) {
                LongArray result = new LongArray(size);
                result.setTemporary(true);
                for (int i = 1; i <= size; ++i) {
                    if (signDatas[i]) {
                        Date date1 = dateArray1.getDate(i);
                        Date date2 = dateArray2.getDate(i);
                        if (date1 != null && date2 != null) {
                            result.pushLong(Variant.interval(date1, date2, this.option));
                            continue;
                        }
                        result.pushNull();
                        continue;
                    }
                    result.pushLong(0L);
                }
                return result;
            }
            DoubleArray result = new DoubleArray(size);
            result.setTemporary(true);
            for (int i = 1; i <= size; ++i) {
                if (signDatas[i]) {
                    Date date1 = dateArray1.getDate(i);
                    Date date2 = dateArray2.getDate(i);
                    if (date1 != null && date2 != null) {
                        result.pushDouble(Variant.realInterval(date1, date2, this.option));
                        continue;
                    }
                    result.pushNull();
                    continue;
                }
                result.pushDouble(0.0);
            }
            return result;
        }
        if (array1 instanceof NumberArray && array2 instanceof NumberArray) {
            NumberArray dateArray1 = (NumberArray)array1;
            NumberArray dateArray2 = (NumberArray)array2;
            if (isInterval) {
                LongArray result = new LongArray(size);
                result.setTemporary(true);
                for (int i = 1; i <= size; ++i) {
                    if (signDatas[i]) {
                        if (!dateArray1.isNull(i) && !dateArray2.isNull(i)) {
                            int date1 = dateArray1.getInt(i);
                            int date2 = dateArray2.getInt(i);
                            result.pushLong(Variant.interval(date1, date2, this.option));
                            continue;
                        }
                        result.pushNull();
                        continue;
                    }
                    result.pushLong(0L);
                }
                return result;
            }
            DoubleArray result = new DoubleArray(size);
            result.setTemporary(true);
            for (int i = 1; i <= size; ++i) {
                if (signDatas[i]) {
                    if (!dateArray1.isNull(i) && !dateArray2.isNull(i)) {
                        int date1 = dateArray1.getInt(i);
                        int date2 = dateArray2.getInt(i);
                        result.pushDouble(Variant.realInterval(date1, date2, this.option));
                        continue;
                    }
                    result.pushNull();
                    continue;
                }
                result.pushDouble(0.0);
            }
            return result;
        }
        if (isInterval) {
            LongArray result = new LongArray(size);
            result.setTemporary(true);
            for (int i = 1; i <= size; ++i) {
                if (signDatas[i]) {
                    Object date1 = array1.get(i);
                    Object date2 = array2.get(i);
                    if (date1 != null && date2 != null) {
                        result.pushLong(this._$2(date1, date2));
                        continue;
                    }
                    result.pushNull();
                    continue;
                }
                result.pushLong(0L);
            }
            return result;
        }
        DoubleArray result = new DoubleArray(size);
        result.setTemporary(true);
        for (int i = 1; i <= size; ++i) {
            if (signDatas[i]) {
                Object date1 = array1.get(i);
                Object date2 = array2.get(i);
                if (date1 != null && date2 != null) {
                    result.pushDouble(this._$1(date1, date2));
                    continue;
                }
                result.pushNull();
                continue;
            }
            result.pushDouble(0.0);
        }
        return result;
    }

    private long _$2(Object result1, Object result2) {
        if (result1 instanceof String) {
            if (!((result1 = Variant.parseDate((String)result1)) instanceof Date)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("interval" + mm.getMessage("function.paramTypeError"));
            }
        } else {
            if (result1 instanceof Integer) {
                if (!(result2 instanceof Integer)) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("interval" + mm.getMessage("function.paramTypeError"));
                }
                return Variant.interval((Integer)result1, (Integer)result2, this.option);
            }
            if (!(result1 instanceof Date)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("interval" + mm.getMessage("function.paramTypeError"));
            }
        }
        if (result2 instanceof String) {
            if (!((result2 = Variant.parseDate((String)result2)) instanceof Date)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("interval" + mm.getMessage("function.paramTypeError"));
            }
        } else if (!(result2 instanceof Date)) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("interval" + mm.getMessage("function.paramTypeError"));
        }
        return Variant.interval((Date)result1, (Date)result2, this.option);
    }

    private double _$1(Object result1, Object result2) {
        if (result1 instanceof String) {
            if (!((result1 = Variant.parseDate((String)result1)) instanceof Date)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("interval" + mm.getMessage("function.paramTypeError"));
            }
        } else {
            if (result1 instanceof Integer) {
                if (!(result2 instanceof Integer)) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("interval" + mm.getMessage("function.paramTypeError"));
                }
                return Variant.realInterval((Integer)result1, (Integer)result2, this.option);
            }
            if (!(result1 instanceof Date)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("interval" + mm.getMessage("function.paramTypeError"));
            }
        }
        if (result2 instanceof String) {
            if (!((result2 = Variant.parseDate((String)result2)) instanceof Date)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("interval" + mm.getMessage("function.paramTypeError"));
            }
        } else if (!(result2 instanceof Date)) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("interval" + mm.getMessage("function.paramTypeError"));
        }
        return Variant.realInterval((Date)result1, (Date)result2, this.option);
    }
}

