/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.fn.datetime;

import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.Sequence;
import com.scudata.resources.EngineMessage;
import java.util.Calendar;
import java.util.Date;

class OffDays {
    private long[] days;
    private boolean isSorted;
    private int index = 0;

    public OffDays(Sequence dates, String opt) {
        boolean bl = this.isSorted = opt != null && opt.indexOf(98) != -1;
        if (dates != null && dates.length() > 0) {
            int size = dates.length();
            this.days = new long[size];
            int i = 1;
            while (i <= size) {
                Object obj = dates.get(i);
                if (!(obj instanceof Date)) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("workday" + mm.getMessage("function.paramTypeError"));
                }
                this.days[i - 1] = ((Date)obj).getTime();
                ++i;
            }
        }
    }

    public boolean isWorkDay(Calendar calendar) {
        int week = calendar.get(7);
        boolean isWorkDay = week != 1 && week != 7;
        long[] days = this.days;
        if (days == null) {
            return isWorkDay;
        }
        if (this.isSorted) {
            int size = days.length;
            long time = calendar.getTimeInMillis();
            while (this.index < size) {
                if (time == days[this.index]) {
                    ++this.index;
                    return !isWorkDay;
                }
                if (time < days[this.index]) break;
                ++this.index;
            }
            return isWorkDay;
        }
        long time = calendar.getTimeInMillis();
        long[] lArray = days;
        int n = days.length;
        int n2 = 0;
        while (n2 < n) {
            long day = lArray[n2];
            if (time == day) {
                return !isWorkDay;
            }
            ++n2;
        }
        return isWorkDay;
    }
}

