/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.fn.datetime;

import com.scudata.common.DateFactory;
import com.scudata.common.DateFormatFactory;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.expression.Function;
import com.scudata.expression.IParam;
import com.scudata.resources.EngineMessage;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;

public class ToDate
extends Function {
    public void checkValidity() {
        if (this.param == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("date" + mm.getMessage("function.missingParam"));
        }
    }

    public Object calculate(Context ctx) {
        int size = this.param.getSubSize();
        if (size == 0) {
            Object result1 = this.param.getLeafExpression().calculate(ctx);
            if (result1 instanceof String) {
                try {
                    return DateFactory.parseDate((String)result1);
                }
                catch (ParseException e) {
                    return null;
                }
            }
            if (result1 instanceof Number) {
                if (this.option == null || this.option.indexOf(111) == -1) {
                    return DateFactory.get().toDate(((Number)result1).longValue());
                }
                return DateFactory.toDate(((Number)result1).intValue());
            }
            if (result1 instanceof Date) {
                if (!(result1 instanceof java.sql.Date)) {
                    return DateFactory.get().toDate((Date)result1);
                }
                return result1;
            }
            if (result1 == null) {
                return null;
            }
            MessageManager mm = EngineMessage.get();
            throw new RQException("date" + mm.getMessage("function.paramTypeError"));
        }
        if (size == 2) {
            String format;
            IParam sub1 = this.param.getSub(0);
            IParam sub2 = this.param.getSub(1);
            if (sub1 == null || sub2 == null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("date" + mm.getMessage("function.invalidParam"));
            }
            Object result1 = sub1.getLeafExpression().calculate(ctx);
            if (result1 == null) {
                return null;
            }
            if (sub2.isLeaf()) {
                Object result2 = sub2.getLeafExpression().calculate(ctx);
                if (result1 instanceof String && result2 instanceof String) {
                    try {
                        DateFormat df = DateFormatFactory.get().getFormat((String)result2);
                        return new java.sql.Date(df.parse((String)result1).getTime());
                    }
                    catch (ParseException e) {
                        return null;
                    }
                }
                if (result1 instanceof Number && result2 instanceof Number) {
                    int ym = ((Number)result1).intValue();
                    if (ym < 1) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException("date" + mm.getMessage("function.invalidParam"));
                    }
                    int day = ((Number)result2).intValue();
                    int year = ym / 100;
                    if (year < 100) {
                        year += 2000;
                    }
                    int month = ym % 100;
                    Calendar calendar = Calendar.getInstance();
                    calendar.set(year, month - 1, day, 0, 0, 0);
                    calendar.set(14, 0);
                    return new java.sql.Date(calendar.getTimeInMillis());
                }
                MessageManager mm = EngineMessage.get();
                throw new RQException("date" + mm.getMessage("function.paramTypeError"));
            }
            if (!(result1 instanceof String)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("date" + mm.getMessage("function.paramTypeError"));
            }
            IParam fmtParam = sub2.getSub(0);
            if (fmtParam == null) {
                format = DateFormatFactory.getDefaultDateFormat();
            } else {
                Object obj = fmtParam.getLeafExpression().calculate(ctx);
                if (!(obj instanceof String)) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("date" + mm.getMessage("function.paramTypeError"));
                }
                format = (String)obj;
            }
            String locale = null;
            IParam locParam = sub2.getSub(1);
            if (locParam != null) {
                Object obj = locParam.getLeafExpression().calculate(ctx);
                if (!(obj instanceof String)) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("date" + mm.getMessage("function.paramTypeError"));
                }
                locale = (String)obj;
            }
            try {
                DateFormat df = DateFormatFactory.get().getFormat(format, locale);
                return new java.sql.Date(df.parse((String)result1).getTime());
            }
            catch (ParseException e) {
                return null;
            }
        }
        if (size == 3) {
            IParam sub1 = this.param.getSub(0);
            IParam sub2 = this.param.getSub(1);
            IParam sub3 = this.param.getSub(2);
            if (sub1 == null || sub2 == null || sub3 == null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("date" + mm.getMessage("function.invalidParam"));
            }
            Object obj = sub1.getLeafExpression().calculate(ctx);
            if (!(obj instanceof Number)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("date" + mm.getMessage("function.paramTypeError"));
            }
            int year = ((Number)obj).intValue();
            obj = sub2.getLeafExpression().calculate(ctx);
            if (!(obj instanceof Number)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("date" + mm.getMessage("function.paramTypeError"));
            }
            int month = ((Number)obj).intValue();
            obj = sub3.getLeafExpression().calculate(ctx);
            if (!(obj instanceof Number)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("date" + mm.getMessage("function.paramTypeError"));
            }
            int day = ((Number)obj).intValue();
            Calendar calendar = Calendar.getInstance();
            calendar.set(year, month - 1, day, 0, 0, 0);
            calendar.set(14, 0);
            return new java.sql.Date(calendar.getTimeInMillis());
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException("date" + mm.getMessage("function.invalidParam"));
    }
}

