/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.fn.datetime;

import com.scudata.common.DateFactory;
import com.scudata.common.DateFormatFactory;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.expression.Function;
import com.scudata.expression.IParam;
import com.scudata.resources.EngineMessage;
import java.sql.Time;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;

public class ToTime
extends Function {
    public void checkValidity() {
        if (this.param == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("time" + mm.getMessage("function.missingParam"));
        }
    }

    public Object calculate(Context ctx) {
        if (this.param.isLeaf()) {
            Object result1 = this.param.getLeafExpression().calculate(ctx);
            if (result1 instanceof String) {
                try {
                    return DateFactory.parseTime((String)result1);
                }
                catch (ParseException e) {
                    return null;
                }
            }
            if (result1 instanceof Number) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTimeInMillis(((Number)result1).longValue());
                calendar.set(1970, 0, 1);
                if (this.option != null) {
                    if (this.option.indexOf(115) != -1) {
                        calendar.set(14, 0);
                    } else if (this.option.indexOf(109) != -1) {
                        calendar.set(13, 0);
                        calendar.set(14, 0);
                    }
                }
                return new Time(calendar.getTimeInMillis());
            }
            if (result1 instanceof Date) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime((Date)result1);
                calendar.set(1970, 0, 1);
                if (this.option != null) {
                    if (this.option.indexOf(115) != -1) {
                        calendar.set(14, 0);
                    } else if (this.option.indexOf(109) != -1) {
                        calendar.set(13, 0);
                        calendar.set(14, 0);
                    }
                }
                return new Time(calendar.getTimeInMillis());
            }
            if (result1 == null) {
                return null;
            }
            MessageManager mm = EngineMessage.get();
            throw new RQException("time" + mm.getMessage("function.paramTypeError"));
        }
        if (this.param.getSubSize() == 2) {
            String format;
            IParam sub1 = this.param.getSub(0);
            IParam sub2 = this.param.getSub(1);
            if (sub1 == null || sub2 == null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("time" + mm.getMessage("function.invalidParam"));
            }
            Object result1 = sub1.getLeafExpression().calculate(ctx);
            if (result1 == null) {
                return null;
            }
            if (!(result1 instanceof String)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("time" + mm.getMessage("function.paramTypeError"));
            }
            if (sub2.isLeaf()) {
                Object fmt = sub2.getLeafExpression().calculate(ctx);
                if (!(fmt instanceof String)) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("time" + mm.getMessage("function.paramTypeError"));
                }
                try {
                    DateFormat df = DateFormatFactory.get().getFormat((String)fmt);
                    return new Time(df.parse((String)result1).getTime());
                }
                catch (ParseException e) {
                    return null;
                }
            }
            IParam fmtParam = sub2.getSub(0);
            if (fmtParam == null) {
                format = DateFormatFactory.getDefaultDateFormat();
            } else {
                Object obj = fmtParam.getLeafExpression().calculate(ctx);
                if (!(obj instanceof String)) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("time" + mm.getMessage("function.paramTypeError"));
                }
                format = (String)obj;
            }
            String locale = null;
            IParam locParam = sub2.getSub(1);
            if (locParam != null) {
                Object obj = locParam.getLeafExpression().calculate(ctx);
                if (!(obj instanceof String)) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("time" + mm.getMessage("function.paramTypeError"));
                }
                locale = (String)obj;
            }
            try {
                DateFormat df = DateFormatFactory.get().getFormat(format, locale);
                return new Time(df.parse((String)result1).getTime());
            }
            catch (ParseException e) {
                return null;
            }
        }
        if (this.param.getSubSize() == 3) {
            IParam sub1 = this.param.getSub(0);
            IParam sub2 = this.param.getSub(1);
            IParam sub3 = this.param.getSub(2);
            if (sub1 == null || sub2 == null || sub3 == null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("time" + mm.getMessage("function.invalidParam"));
            }
            Object obj = sub1.getLeafExpression().calculate(ctx);
            if (!(obj instanceof Number)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("time" + mm.getMessage("function.paramTypeError"));
            }
            int hour = ((Number)obj).intValue();
            obj = sub2.getLeafExpression().calculate(ctx);
            if (!(obj instanceof Number)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("time" + mm.getMessage("function.paramTypeError"));
            }
            int minute = ((Number)obj).intValue();
            obj = sub3.getLeafExpression().calculate(ctx);
            if (!(obj instanceof Number)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("time" + mm.getMessage("function.paramTypeError"));
            }
            int second = ((Number)obj).intValue();
            Calendar calendar = Calendar.getInstance();
            calendar.set(1970, 0, 1, hour, minute, second);
            calendar.set(14, 0);
            return new Time(calendar.getTimeInMillis());
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException("time" + mm.getMessage("function.invalidParam"));
    }
}

