/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.fn.datetime;

import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.dm.Sequence;
import com.scudata.expression.Function;
import com.scudata.expression.IParam;
import com.scudata.expression.Node;
import com.scudata.resources.EngineMessage;
import java.util.Calendar;
import java.util.Date;

public class WorkDay
extends Function {
    public Node optimize(Context ctx) {
        this.param.optimize(ctx);
        return this;
    }

    public void checkValidity() {
        if (this.param == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("workday" + mm.getMessage("function.missingParam"));
        }
    }

    public Object calculate(Context ctx) {
        IParam sub3;
        int size = this.param.getSubSize();
        if (size != 2 && size != 3) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("workday" + mm.getMessage("function.invalidParam"));
        }
        IParam sub1 = this.param.getSub(0);
        IParam sub2 = this.param.getSub(1);
        if (sub1 == null || sub2 == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("workday" + mm.getMessage("function.invalidParam"));
        }
        Object result1 = sub1.getLeafExpression().calculate(ctx);
        Object result2 = sub2.getLeafExpression().calculate(ctx);
        if (!(result1 instanceof Date) || !(result2 instanceof Number)) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("workday" + mm.getMessage("function.paramTypeError"));
        }
        Sequence offDays = null;
        if (size == 3 && (sub3 = this.param.getSub(2)) != null) {
            Object obj = sub3.getLeafExpression().calculate(ctx);
            if (obj instanceof Sequence) {
                offDays = (Sequence)obj;
            } else if (obj != null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("workday" + mm.getMessage("function.paramTypeError"));
            }
        }
        Date date1 = (Date)result1;
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date1);
        int diff = ((Number)result2).intValue();
        int d = 1;
        if (diff < 0) {
            d = -1;
        } else if (diff == 0) {
            return date1;
        }
        while (diff != 0) {
            calendar.add(5, d);
            if (!this._$1(calendar, offDays)) continue;
            diff -= d;
        }
        Date date = (Date)date1.clone();
        date.setTime(calendar.getTimeInMillis());
        return date;
    }

    private boolean _$1(Calendar calendar, Sequence offDays) {
        boolean isWorkDay;
        int week = calendar.get(7);
        boolean bl = isWorkDay = week != 1 && week != 7;
        if (offDays == null || offDays.length() == 0) {
            return isWorkDay;
        }
        long time = calendar.getTimeInMillis();
        if (this.option == null || this.option.indexOf(98) == -1) {
            int count = offDays.length();
            for (int i = 1; i <= count; ++i) {
                Object obj = offDays.getMem(i);
                if (!(obj instanceof Date)) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("workday" + mm.getMessage("function.paramTypeError"));
                }
                if (((Date)obj).getTime() != time) continue;
                return !isWorkDay;
            }
        } else {
            int low = 1;
            int high = offDays.length();
            while (low <= high) {
                int mid = low + high >> 1;
                Object obj = offDays.getMem(mid);
                if (!(obj instanceof Date)) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("workday" + mm.getMessage("function.paramTypeError"));
                }
                long curTime = ((Date)obj).getTime();
                if (curTime < time) {
                    low = mid + 1;
                    continue;
                }
                if (curTime > time) {
                    high = mid - 1;
                    continue;
                }
                return !isWorkDay;
            }
        }
        return isWorkDay;
    }
}

