/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.fn.gather;

import com.scudata.array.IArray;
import com.scudata.array.LongArray;
import com.scudata.common.MessageManager;
import com.scudata.common.ObjectCache;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.dm.Sequence;
import com.scudata.expression.Expression;
import com.scudata.expression.Gather;
import com.scudata.expression.IParam;
import com.scudata.resources.EngineMessage;
import com.scudata.util.Variant;

public class Count
extends Gather {
    private Expression _$1;

    public void prepare(Context ctx) {
        if (this.param == null || !this.param.isLeaf()) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("count" + mm.getMessage("function.invalidParam"));
        }
        this._$1 = this.param.getLeafExpression();
    }

    public Object gather(Context ctx) {
        Object val = this._$1.calculate(ctx);
        if (Variant.isTrue(val)) {
            return new Long(1L);
        }
        return new Long(0L);
    }

    public Object gather(Object oldValue, Context ctx) {
        Object val = this._$1.calculate(ctx);
        if (Variant.isTrue(val)) {
            if (oldValue == null) {
                return new Long(1L);
            }
            return new Long(1L + ((Number)oldValue).longValue());
        }
        if (oldValue == null) {
            return new Long(0L);
        }
        return oldValue;
    }

    public Expression getRegatherExpression(int q) {
        String str = "sum(#" + q + ")";
        return new Expression(str);
    }

    public Object calculate(Context ctx) {
        IParam param = this.param;
        if (param == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("count" + mm.getMessage("function.missingParam"));
        }
        if (param.isLeaf()) {
            Object obj = param.getLeafExpression().calculate(ctx);
            if (obj instanceof Sequence) {
                return ((Sequence)obj).count();
            }
            if (Variant.isTrue(obj)) {
                return ObjectCache.getInteger(1);
            }
            return ObjectCache.getInteger(0);
        }
        int count = 0;
        int size = param.getSubSize();
        for (int i = 0; i < size; ++i) {
            Object obj;
            IParam sub = param.getSub(i);
            if (sub == null || !Variant.isTrue(obj = sub.getLeafExpression().calculate(ctx))) continue;
            ++count;
        }
        return count;
    }

    public Expression getExp() {
        return this._$1;
    }

    public IArray gather(IArray result, int[] resultSeqs, Context ctx) {
        IArray array = this._$1.calculateAll(ctx);
        LongArray resultArray = result == null ? new LongArray(8191) : (LongArray)result;
        int len = array.size();
        for (int i = 1; i <= len; ++i) {
            if (array.isTrue(i)) {
                if (resultArray.size() < resultSeqs[i]) {
                    resultArray.addLong(1L);
                    continue;
                }
                resultArray.plus1(resultSeqs[i]);
                continue;
            }
            if (resultArray.size() >= resultSeqs[i]) continue;
            resultArray.addLong(0L);
        }
        return resultArray;
    }

    public void gather2(IArray result, IArray result2, int[] seqs, Context ctx) {
        int len = result2.size();
        for (int i = 1; i <= len; ++i) {
            if (seqs[i] == 0) continue;
            result.memberAdd(seqs[i], result2, i);
        }
    }
}

