/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.fn.gather;

import com.scudata.common.RQException;
import com.scudata.dm.FileObject;
import com.scudata.dm.ObjectReader;
import com.scudata.expression.fn.gather.IValues;
import java.io.IOException;

class FileValues
implements IValues {
    private FileObject fo;
    private ObjectReader reader;
    private int count;
    private Object value;

    public FileValues(FileObject fo) {
        try {
            this.fo = fo;
            this.reader = new ObjectReader(fo.getInputStream());
            this.count = this.reader.readInt();
            this.value = this.reader.readObject();
        }
        catch (IOException e) {
            throw new RQException(e.getMessage(), e);
        }
    }

    @Override
    public Object getTop() {
        return this.value;
    }

    @Override
    public Object pop() {
        if (this.count > 1) {
            Object obj = this.value;
            --this.count;
            try {
                this.value = this.reader.readObject();
            }
            catch (IOException e) {
                throw new RQException(e.getMessage(), e);
            }
            return obj;
        }
        if (this.count == 1) {
            Object obj = this.value;
            this.count = 0;
            this.value = null;
            this.delete();
            return obj;
        }
        return null;
    }

    public void delete() {
        try {
            this.reader.close();
        }
        catch (IOException e) {
            throw new RQException(e.getMessage(), e);
        }
        this.fo.delete();
    }
}

