/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.fn.gather;

import com.scudata.array.IArray;
import com.scudata.array.IntArray;
import com.scudata.array.LongArray;
import com.scudata.array.ObjectArray;
import com.scudata.common.MessageManager;
import com.scudata.common.ObjectCache;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.dm.FileObject;
import com.scudata.dm.HashLinkSet;
import com.scudata.dm.ObjectWriter;
import com.scudata.dm.Sequence;
import com.scudata.expression.Expression;
import com.scudata.expression.Gather;
import com.scudata.expression.IParam;
import com.scudata.expression.fn.gather.IIlIIllIIIlIlIlI;
import com.scudata.expression.fn.gather.lIlIIIllIIllllII;
import com.scudata.expression.fn.gather.lllIllllIlllIlll;
import com.scudata.resources.EngineMessage;
import com.scudata.thread.MultithreadUtil;
import com.scudata.util.HashUtil;
import com.scudata.util.Variant;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;

public class ICount
extends Gather {
    private Expression _$5;
    private boolean _$4 = false;
    private boolean _$3 = false;
    private boolean _$2 = false;
    private int _$1 = 0;

    public Object calculate(Context ctx) {
        IParam param = this.param;
        if (param == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("icount" + mm.getMessage("function.missingParam"));
        }
        if (param.isLeaf()) {
            Object obj = param.getLeafExpression().calculate(ctx);
            if (obj instanceof Sequence) {
                return ((Sequence)obj).icount(this.option);
            }
            if (Variant.isTrue(obj)) {
                return ObjectCache.getInteger(1);
            }
            return ObjectCache.getInteger(0);
        }
        int size = param.getSubSize();
        HashSet<Object> set = new HashSet<Object>(size);
        for (int i = 0; i < size; ++i) {
            Object obj;
            IParam sub = param.getSub(i);
            if (sub == null || !Variant.isTrue(obj = sub.getLeafExpression().calculate(ctx))) continue;
            set.add(obj);
        }
        return set.size();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void prepare(Context ctx) {
        if (this.param == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("icount" + mm.getMessage("function.missingParam"));
        }
        if (this.param.isLeaf()) {
            this._$5 = this.param.getLeafExpression();
        } else {
            if (this.param.getSubSize() != 2) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("icount" + mm.getMessage("function.invalidParam"));
            }
            IParam sub0 = this.param.getSub(0);
            IParam sub1 = this.param.getSub(1);
            if (sub0 == null || sub1 == null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("icount" + mm.getMessage("function.invalidParam"));
            }
            this._$5 = sub0.getLeafExpression();
            Object value = sub1.getLeafExpression().calculate(ctx);
            if (!(value instanceof Number)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("icount" + mm.getMessage("function.paramTypeError"));
            }
            this._$1 = ((Number)value).intValue();
        }
        if (this.option == null) return;
        if (this.option.indexOf(111) != -1) {
            this._$4 = true;
            return;
        }
        if (this.option.indexOf(98) != -1) {
            this._$3 = true;
            return;
        }
        if (this.option.indexOf(102) == -1) return;
        this._$2 = this._$1 > 0;
    }

    public Object gather(Context ctx) {
        if (this._$4) {
            Object val = this._$5.calculate(ctx);
            if (val instanceof ICountInfo) {
                return val;
            }
            return new ICountInfo(val);
        }
        Object val = this._$5.calculate(ctx);
        if (val instanceof HashSet || val instanceof ICountFile) {
            return val;
        }
        if (val instanceof Sequence) {
            Sequence seq = (Sequence)val;
            int len = seq.length();
            HashSet<Object> set = new HashSet<Object>(len + 8);
            for (int i = 1; i <= len; ++i) {
                set.add(seq.getMem(i));
            }
            return set;
        }
        if (val != null) {
            if (this._$2) {
                ICountFile icf = new ICountFile(this._$1);
                icf.add(val);
                return icf;
            }
            HashSet<Object> set = new HashSet<Object>();
            set.add(val);
            return set;
        }
        return null;
    }

    public Object gather(Object oldValue, Context ctx) {
        Object val = this._$5.calculate(ctx);
        if (val == null) {
            return oldValue;
        }
        if (this._$4) {
            ((ICountInfo)oldValue).put(val);
            return oldValue;
        }
        if (oldValue instanceof HashSet) {
            HashSet set = (HashSet)oldValue;
            if (val instanceof HashSet) {
                set.addAll((HashSet)val);
            } else if (val instanceof Sequence) {
                Sequence seq = (Sequence)val;
                int len = seq.length();
                for (int i = 1; i <= len; ++i) {
                    set.add(seq.getMem(i));
                }
            } else {
                set.add(val);
            }
            return oldValue;
        }
        if (oldValue instanceof ICountFile) {
            ICountFile icf = (ICountFile)oldValue;
            icf.add(val);
            return icf;
        }
        if (val instanceof HashSet || val instanceof ICountFile) {
            return val;
        }
        if (val instanceof Sequence) {
            Sequence seq = (Sequence)val;
            int len = seq.length();
            HashSet<Object> set = new HashSet<Object>(len + 8);
            for (int i = 1; i <= len; ++i) {
                set.add(seq.getMem(i));
            }
            return set;
        }
        if (this._$2) {
            ICountFile icf = new ICountFile(this._$1);
            icf.add(val);
            return icf;
        }
        HashSet<Object> set = new HashSet<Object>();
        set.add(val);
        return set;
    }

    public Expression getRegatherExpression(int q) {
        if (this._$4) {
            String str = "icount@o(#" + q + ")";
            return new Expression(str);
        }
        String str = "icount(#" + q + ")";
        return new Expression(str);
    }

    public boolean needFinish1() {
        return true;
    }

    public boolean needFinish() {
        return true;
    }

    public IArray finish1(IArray array) {
        if (this._$3) {
            return this._$2(array);
        }
        return array;
    }

    public Object finish1(Object val) {
        if (val instanceof HashSet) {
            HashSet set = (HashSet)val;
            Sequence seq = new Sequence(set.size());
            Iterator iter = set.iterator();
            while (iter.hasNext()) {
                seq.add(iter.next());
            }
            return seq;
        }
        return val;
    }

    public IArray finish(IArray array) {
        if (this._$3) {
            return this._$1(array);
        }
        int size = array.size();
        if (this._$4) {
            IntArray result = new IntArray(size);
            for (int i = 1; i <= size; ++i) {
                ICountInfo val = (ICountInfo)array.get(i);
                result.pushInt(val._$3);
            }
            return result;
        }
        if (this._$2) {
            LongArray result = new LongArray(size);
            for (int i = 1; i <= size; ++i) {
                Object val = array.get(i);
                if (val instanceof ICountFile) {
                    result.pushLong(((ICountFile)val).result());
                    continue;
                }
                result.pushLong(0L);
            }
            return result;
        }
        IntArray result = new IntArray(size);
        for (int i = 1; i <= size; ++i) {
            Object val = array.get(i);
            if (val instanceof HashLinkSet) {
                result.pushInt(((HashLinkSet)val).size());
                continue;
            }
            if (val instanceof Sequence) {
                result.pushInt(((Sequence)val).length());
                continue;
            }
            result.pushInt(0);
        }
        return result;
    }

    public Object finish(Object val) {
        if (val instanceof ICountInfo) {
            return ((ICountInfo)val)._$3;
        }
        if (val instanceof HashSet) {
            return ObjectCache.getInteger(((HashSet)val).size());
        }
        if (val instanceof Sequence) {
            return ObjectCache.getInteger(((Sequence)val).length());
        }
        if (val instanceof ICountFile) {
            return ((ICountFile)val).result();
        }
        return ObjectCache.getInteger(0);
    }

    public Expression getExp() {
        return this._$5;
    }

    public boolean isSorted() {
        return this._$4;
    }

    public IArray gather(IArray result, int[] resultSeqs, Context ctx) {
        if (this._$3) {
            return this._$1(result, resultSeqs, ctx);
        }
        IArray array = this._$5.calculateAll(ctx);
        if (result == null) {
            result = new ObjectArray(8191);
        }
        if (this._$4) {
            int len = array.size();
            for (int i = 1; i <= len; ++i) {
                Object val = array.get(i);
                if (result.size() < resultSeqs[i]) {
                    if (val instanceof ICountInfo) {
                        result.add(val);
                        continue;
                    }
                    result.add(new ICountInfo(val));
                    continue;
                }
                ICountInfo oldValue = (ICountInfo)result.get(resultSeqs[i]);
                oldValue.put(val);
            }
        } else if (this._$2) {
            int maxSize = this._$1;
            if (array instanceof ObjectArray) {
                int size = array.size();
                for (int i = 1; i <= size; ++i) {
                    ICountFile icf;
                    Object val = array.get(i);
                    if (result.size() < resultSeqs[i]) {
                        if (val instanceof ICountFile) {
                            result.add(val);
                            continue;
                        }
                        if (val != null) {
                            icf = new ICountFile(maxSize);
                            icf.addValue(val);
                            result.add(icf);
                            continue;
                        }
                        result.add(new ICountFile(maxSize));
                        continue;
                    }
                    icf = (ICountFile)result.get(resultSeqs[i]);
                    icf.add(val);
                }
            } else {
                int size = array.size();
                for (int i = 1; i <= size; ++i) {
                    ICountFile icf;
                    if (result.size() < resultSeqs[i]) {
                        icf = new ICountFile(maxSize);
                        if (!array.isNull(i)) {
                            icf.add(array, i);
                        }
                        result.add(icf);
                        continue;
                    }
                    if (array.isNull(i)) continue;
                    icf = (ICountFile)result.get(resultSeqs[i]);
                    icf.add(array, i);
                }
            }
        } else if (array instanceof ObjectArray) {
            int size = array.size();
            for (int i = 1; i <= size; ++i) {
                HashLinkSet set;
                Object val = array.get(i);
                if (result.size() < resultSeqs[i]) {
                    if (val instanceof HashLinkSet) {
                        result.add(val);
                        continue;
                    }
                    if (val != null) {
                        set = new HashLinkSet(array, this._$1);
                        set.put(val);
                        result.add(set);
                        continue;
                    }
                    result.add(new HashLinkSet(array, this._$1));
                    continue;
                }
                set = (HashLinkSet)result.get(resultSeqs[i]);
                if (val instanceof HashLinkSet) {
                    set.addHashSet((HashLinkSet)val);
                    continue;
                }
                if (val == null) continue;
                set.put(val);
            }
        } else {
            int size = array.size();
            for (int i = 1; i <= size; ++i) {
                HashLinkSet set;
                if (result.size() < resultSeqs[i]) {
                    set = new HashLinkSet(array, this._$1);
                    if (!array.isNull(i)) {
                        set.put(array, i);
                    }
                    result.add(set);
                    continue;
                }
                if (array.isNull(i)) continue;
                set = (HashLinkSet)result.get(resultSeqs[i]);
                set.put(array, i);
            }
        }
        return result;
    }

    private IArray _$2(IArray array) {
        int size = array.size();
        if (!this._$4) {
            for (int i = 1; i <= size; ++i) {
                Object val = array.get(i);
                if (!(val instanceof ICountBitSet)) continue;
                ICountBitSet set = (ICountBitSet)val;
                array.set(i, set._$1);
            }
        }
        return array;
    }

    private IArray _$1(IArray array) {
        int size = array.size();
        IntArray result = new IntArray(size);
        for (int i = 1; i <= size; ++i) {
            Object val = array.get(i);
            if (val instanceof ICountBitSet) {
                result.pushInt(((ICountBitSet)val).size());
                continue;
            }
            if (val instanceof long[]) {
                result.pushInt(ICountBitSet.countBit((long[])val));
                continue;
            }
            result.pushInt(0);
        }
        return result;
    }

    private IArray _$1(IArray result, int[] resultSeqs, Context ctx) {
        IArray array = this._$5.calculateAll(ctx);
        if (result == null) {
            result = new ObjectArray(8191);
        }
        if (array instanceof IntArray && ((IntArray)array).getSigns() == null) {
            int size = array.size();
            for (int i = 1; i <= size; ++i) {
                ICountBitSet set;
                if (result.size() < resultSeqs[i]) {
                    ICountBitSet set2 = new ICountBitSet();
                    set2.add(array, i);
                    result.add(set2);
                    continue;
                }
                Object oldValue = result.get(resultSeqs[i]);
                if (oldValue == null) {
                    set = new ICountBitSet();
                    set.add(array, i);
                    result.set(resultSeqs[i], set);
                    continue;
                }
                set = (ICountBitSet)oldValue;
                set.add(array, i);
            }
        } else {
            int size = array.size();
            for (int i = 1; i <= size; ++i) {
                ICountBitSet set;
                Object val = array.get(i);
                if (result.size() < resultSeqs[i]) {
                    if (val instanceof ICountBitSet) {
                        result.add(val);
                        continue;
                    }
                    if (val instanceof long[]) {
                        long[] seq = (long[])val;
                        set = new ICountBitSet(seq);
                        result.add(set);
                        continue;
                    }
                    if (val != null) {
                        ICountBitSet set3 = new ICountBitSet();
                        set3.add((Integer)val);
                        result.add(set3);
                        continue;
                    }
                    result.add(null);
                    continue;
                }
                Object oldValue = result.get(resultSeqs[i]);
                if (oldValue == null) {
                    if (val instanceof ICountBitSet) {
                        oldValue = val;
                    } else if (val instanceof long[]) {
                        long[] seq = (long[])val;
                        ICountBitSet set4 = new ICountBitSet(seq);
                        oldValue = set4;
                    } else if (val != null) {
                        set = new ICountBitSet();
                        set.add((Integer)val);
                        oldValue = set;
                    }
                } else {
                    set = (ICountBitSet)oldValue;
                    if (val instanceof ICountBitSet) {
                        set.addAll((ICountBitSet)val);
                    } else if (val instanceof long[]) {
                        long[] seq = (long[])val;
                        set.addAll(seq);
                    } else if (val != null) {
                        set.add((Integer)val);
                    }
                }
                result.set(resultSeqs[i], oldValue);
            }
        }
        return result;
    }

    public void gather2(IArray result, IArray result2, int[] seqs, Context ctx) {
        if (this._$3) {
            int len = result2.size();
            for (int i = 1; i <= len; ++i) {
                if (seqs[i] == 0) continue;
                ICountBitSet value1 = (ICountBitSet)result.get(seqs[i]);
                ICountBitSet value2 = (ICountBitSet)result2.get(i);
                value1.addAll(value2);
            }
        } else if (this._$2) {
            int len = result2.size();
            for (int i = 1; i <= len; ++i) {
                if (seqs[i] == 0) continue;
                ICountFile value1 = (ICountFile)result.get(seqs[i]);
                value1.addAll((ICountFile)result2.get(i));
            }
        } else if (!this._$4) {
            int len = result2.size();
            for (int i = 1; i <= len; ++i) {
                if (seqs[i] == 0) continue;
                HashLinkSet value1 = (HashLinkSet)result.get(seqs[i]);
                value1.addHashSet((HashLinkSet)result2.get(i));
            }
        } else {
            int len = result2.size();
            for (int i = 1; i <= len; ++i) {
                if (seqs[i] == 0) continue;
                ICountInfo value1 = (ICountInfo)result.get(seqs[i]);
                ICountInfo value2 = (ICountInfo)result2.get(i);
                value1.put(value2);
            }
        }
    }

    public static class ICountPositionSet
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private static final int _$3 = 65536;
        private int _$2 = 0;
        private boolean[] _$1 = new boolean[65536];

        public boolean add(int num) {
            boolean[] posArray = this._$1;
            if (num >= posArray.length) {
                int newSize = num + num / 3;
                boolean[] newPosArray = new boolean[newSize];
                System.arraycopy(posArray, 0, newPosArray, 0, posArray.length);
                this._$1 = newPosArray;
                posArray = newPosArray;
            }
            if (posArray[num]) {
                return false;
            }
            posArray[num] = true;
            ++this._$2;
            return true;
        }

        public boolean add(IArray array, int index) {
            boolean[] posArray;
            int num = array.getInt(index);
            if (num >= (posArray = this._$1).length) {
                int newSize = num + num / 3;
                boolean[] newPosArray = new boolean[newSize];
                System.arraycopy(posArray, 0, newPosArray, 0, posArray.length);
                this._$1 = newPosArray;
                posArray = newPosArray;
            }
            if (posArray[num]) {
                return false;
            }
            posArray[num] = true;
            ++this._$2;
            return true;
        }

        public int size() {
            return this._$2;
        }
    }

    public static class ICountBitSet
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private static final int _$3 = 1024;
        private int _$2 = 0;
        private long[] _$1;

        public ICountBitSet() {
            this._$1 = new long[1024];
        }

        public ICountBitSet(long[] bitArray) {
            this._$1 = bitArray;
            this._$2 = ICountBitSet.countBit(bitArray);
        }

        public boolean add(int num) {
            long cur;
            int idx = num / 64;
            long bit = 1L << num % 64;
            long[] bitArray = this._$1;
            if (idx >= bitArray.length) {
                int newSize = idx + idx / 3;
                long[] newBitArray = new long[newSize];
                System.arraycopy(bitArray, 0, newBitArray, 0, bitArray.length);
                this._$1 = newBitArray;
                bitArray = newBitArray;
            }
            if (((cur = bitArray[idx]) & bit) != 0L) {
                return false;
            }
            bitArray[idx] = cur | bit;
            ++this._$2;
            return true;
        }

        public boolean add(IArray array, int index) {
            long cur;
            if (array.isNull(index)) {
                return false;
            }
            int num = array.getInt(index);
            int idx = num / 64;
            long bit = 1L << num % 64;
            long[] bitArray = this._$1;
            if (idx >= bitArray.length) {
                int newSize = idx + idx / 3;
                long[] newBitArray = new long[newSize];
                System.arraycopy(bitArray, 0, newBitArray, 0, bitArray.length);
                this._$1 = newBitArray;
                bitArray = newBitArray;
            }
            if (((cur = bitArray[idx]) & bit) != 0L) {
                return false;
            }
            bitArray[idx] = cur | bit;
            ++this._$2;
            return true;
        }

        public static int countBit(long[] bitArray) {
            int count = 0;
            for (long i : bitArray) {
                i -= i >>> 1 & 0x5555555555555555L;
                i = (i & 0x3333333333333333L) + (i >>> 2 & 0x3333333333333333L);
                i = i + (i >>> 4) & 0xF0F0F0F0F0F0F0FL;
                i += i >>> 8;
                i += i >>> 16;
                i += i >>> 32;
                count += (int)i & 0x7F;
            }
            return count;
        }

        public int size() {
            return this._$2;
        }

        public void addAll(long[] newBits) {
            long[] curBits = this._$1;
            int curLen = curBits.length;
            int newLen = newBits.length;
            if (curLen >= newLen) {
                for (int i = 0; i <= newLen; ++i) {
                    int n = i;
                    curBits[n] = curBits[n] | newBits[i];
                }
            } else {
                long[] temp = new long[newLen];
                System.arraycopy(newBits, curLen, temp, curLen, newLen - curLen);
                for (int i = 0; i < curLen; ++i) {
                    temp[i] = curBits[i] | newBits[i];
                }
                this._$1 = temp;
            }
            this._$2 = ICountBitSet.countBit(this._$1);
        }

        public void addAll(ICountBitSet set) {
            long[] newBits = set._$1;
            this.addAll(newBits);
        }
    }

    public static class ICountHashSet
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private static final int _$6 = 64;
        private IArray _$5;
        private HashUtil _$4 = new HashUtil(64);
        private int _$3 = 0;
        private int[] _$2 = new int[this._$4.getCapacity()];
        private IntArray _$1 = new IntArray(64);

        public ICountHashSet(IArray src) {
            this._$5 = src.newInstance(64);
        }

        public void add(IArray array, int index) {
            if (array.isNull(index)) {
                return;
            }
            IArray elementArray = this._$5;
            int[] linkArray = this._$1.getDatas();
            int[] entries = this._$2;
            int hash = this._$4.hashCode(array.hashCode(index));
            int seq = entries[hash];
            while (seq != 0) {
                if (elementArray.isEquals(seq, array, index)) {
                    return;
                }
                seq = linkArray[seq];
            }
            ++this._$3;
            int count = this._$3;
            if (count == linkArray.length) {
                this._$1.setSize(count - 1);
                elementArray.ensureCapacity(count);
                this._$1.ensureCapacity(count);
                linkArray = this._$1.getDatas();
            }
            elementArray.push(array, index);
            linkArray[count] = entries[hash];
            entries[hash] = count;
        }

        public void addInt(int key) {
            int[] elementArray = ((IntArray)this._$5).getDatas();
            int[] linkArray = this._$1.getDatas();
            int[] entries = this._$2;
            int hash = this._$4.hashCode(key);
            int seq = entries[hash];
            while (seq != 0) {
                if (elementArray[seq] == key) {
                    return;
                }
                seq = linkArray[seq];
            }
            ++this._$3;
            int count = this._$3;
            if (count == linkArray.length) {
                this._$5.setSize(count - 1);
                this._$1.setSize(count - 1);
                this._$5.ensureCapacity(count);
                this._$1.ensureCapacity(count);
                elementArray = ((IntArray)this._$5).getDatas();
                linkArray = this._$1.getDatas();
            }
            elementArray[count] = key;
            linkArray[count] = entries[hash];
            entries[hash] = count;
        }

        public void addAll(IArray array) {
            if (this._$5 == null) {
                this._$5 = array.newInstance(64);
            }
            IArray elementArray = this._$5;
            int[] linkArray = this._$1.getDatas();
            int[] entries = this._$2;
            HashUtil hashUtil = this._$4;
            int count = this._$3;
            int len = array.size();
            for (int i = 1; i <= len; ++i) {
                if (array.isNull(i)) continue;
                int hash = hashUtil.hashCode(array.hashCode(i));
                int seq = entries[hash];
                boolean find = false;
                while (seq != 0) {
                    if (elementArray.isEquals(seq, array, i)) {
                        find = true;
                        break;
                    }
                    seq = linkArray[seq];
                }
                if (find) continue;
                if (++count == linkArray.length) {
                    elementArray.ensureCapacity(count);
                    this._$1.setSize(count - 1);
                    this._$1.ensureCapacity(count);
                    linkArray = this._$1.getDatas();
                }
                elementArray.push(array, i);
                linkArray[count] = entries[hash];
                entries[hash] = count;
            }
            this._$3 = count;
        }

        public int size() {
            return this._$3;
        }
    }

    public static class ICountInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private int _$3;
        private Object _$2;
        private Object _$1;

        public ICountInfo() {
        }

        public ICountInfo(Object startValue) {
            if (startValue != null) {
                this._$3 = 1;
                this._$2 = startValue;
                this._$1 = startValue;
            }
        }

        public void put(Object value) {
            if (value instanceof ICountInfo) {
                ICountInfo next = (ICountInfo)value;
                if (this._$3 == 0) {
                    this._$3 = next._$3;
                    this._$2 = next._$2;
                    this._$1 = next._$1;
                } else if (next._$3 != 0) {
                    this._$3 = Variant.isEquals(this._$1, next._$2) ? (this._$3 += next._$3 - 1) : (this._$3 += next._$3);
                    this._$1 = next._$1;
                }
            } else if (value != null) {
                if (this._$1 == null) {
                    this._$2 = value;
                    this._$1 = value;
                    this._$3 = 1;
                } else if (!Variant.isEquals(this._$1, value)) {
                    ++this._$3;
                    this._$1 = value;
                }
            }
        }
    }

    public static class ICountFile {
        private final int _$6;
        private IArray _$5;
        private int[] _$4;
        private HashUtil _$3;
        private int[] _$2;
        private ArrayList<FileObject> _$1 = new ArrayList();

        public ICountFile(int maxSize) {
            this._$6 = maxSize;
            this._$5 = new ObjectArray(maxSize);
            this._$4 = new int[maxSize + 1];
            this._$3 = new HashUtil(maxSize);
            this._$2 = new int[this._$3.getCapacity()];
        }

        public ICountFile(IArray valueArray, int maxSize) {
            this._$6 = maxSize;
            this._$5 = valueArray.newInstance(maxSize);
            this._$4 = new int[maxSize + 1];
            this._$3 = new HashUtil(maxSize);
            this._$2 = new int[this._$3.getCapacity()];
        }

        public void addValue(Object value) {
            int[] entries = this._$2;
            int hash = this._$3.hashCode(value);
            int seq = entries[hash];
            while (seq != 0) {
                if (this._$5.isEquals(seq, value)) {
                    return;
                }
                seq = this._$4[seq];
            }
            int count = this._$5.size();
            if (count == this._$6) {
                Object[] values = this._$5.toArray();
                MultithreadUtil.sort(values);
                FileObject fo = FileObject.createTempFileObject();
                this._$1.add(fo);
                ObjectWriter writer = new ObjectWriter(fo.getOutputStream(false));
                try {
                    writer.writeInt(count);
                    for (Object obj : values) {
                        writer.writeObject(obj);
                    }
                }
                catch (IOException e) {
                    throw new RQException(e.getMessage(), e);
                }
                finally {
                    try {
                        writer.close();
                    }
                    catch (IOException e) {
                        throw new RQException(e.getMessage(), e);
                    }
                }
                this._$5.clear();
                int size = entries.length;
                for (int i = 0; i < size; ++i) {
                    entries[i] = 0;
                }
                int[] linkArray = this._$4;
                int size2 = this._$6;
                for (int i = 1; i <= size2; ++i) {
                    linkArray[i] = 0;
                }
                this._$5.push(value);
                entries[hash] = 1;
            } else {
                this._$5.push(value);
                this._$4[count + 1] = entries[hash];
                entries[hash] = count + 1;
            }
        }

        public void addAll(ICountFile cf) {
            this._$1.addAll(cf._$1);
            IArray elementArray = this._$5;
            int size1 = elementArray.size();
            if (size1 == 0) {
                this._$5 = cf._$5;
                this._$4 = cf._$4;
                this._$2 = cf._$2;
                return;
            }
            IArray elementArray2 = cf._$5;
            int size2 = elementArray2.size();
            if (size2 == 0) {
                return;
            }
            int[] entries = this._$2;
            int[] linkArray = this._$4;
            int[] entries2 = cf._$2;
            int[] linkArray2 = cf._$4;
            int oldCapacity = this._$6;
            int newCapacity = this._$6;
            int totalCount = size1;
            int capacity = entries.length;
            for (int h = 0; h < capacity; ++h) {
                int seq1 = entries[h];
                int seq2 = entries2[h];
                while (seq2 != 0) {
                    block23: {
                        int q = seq1;
                        while (q != 0) {
                            if (!elementArray.isEquals(q, elementArray2, seq2)) {
                                q = linkArray[q];
                                continue;
                            }
                            break block23;
                        }
                        if (newCapacity > oldCapacity) {
                            elementArray.push(elementArray2, seq2);
                        } else if (++totalCount <= newCapacity) {
                            elementArray.push(elementArray2, seq2);
                            linkArray[totalCount] = entries[h];
                            entries[h] = totalCount;
                        } else {
                            newCapacity = size1 + size2;
                            elementArray.ensureCapacity(newCapacity);
                            elementArray.push(elementArray2, seq2);
                        }
                    }
                    seq2 = linkArray2[seq2];
                }
            }
            if (newCapacity > oldCapacity) {
                int i;
                Object[] values = elementArray.toArray();
                MultithreadUtil.sort(values);
                FileObject fo = FileObject.createTempFileObject();
                this._$1.add(fo);
                ObjectWriter writer = new ObjectWriter(fo.getOutputStream(false));
                try {
                    writer.writeInt(size1);
                    for (Object obj : values) {
                        writer.writeObject(obj);
                    }
                }
                catch (IOException e) {
                    throw new RQException(e.getMessage(), e);
                }
                finally {
                    try {
                        writer.close();
                    }
                    catch (IOException e) {
                        throw new RQException(e.getMessage(), e);
                    }
                }
                this._$5 = elementArray2;
                this._$5.clear();
                int size = entries.length;
                for (i = 0; i < size; ++i) {
                    entries[i] = 0;
                }
                size = this._$6;
                for (i = 1; i <= size; ++i) {
                    linkArray[i] = 0;
                }
            }
        }

        public void add(Object value) {
            if (value instanceof ICountFile) {
                this.addAll((ICountFile)value);
            } else if (value != null) {
                this.addValue(value);
            }
        }

        public void add(IArray array, int index) {
            IArray elementArray = this._$5;
            int[] entries = this._$2;
            int hash = this._$3.hashCode(array.hashCode(index));
            int seq = entries[hash];
            while (seq != 0) {
                if (elementArray.isEquals(seq, array, index)) {
                    return;
                }
                seq = this._$4[seq];
            }
            int count = elementArray.size();
            if (count == this._$6) {
                Object[] values = elementArray.toArray();
                MultithreadUtil.sort(values);
                FileObject fo = FileObject.createTempFileObject();
                this._$1.add(fo);
                ObjectWriter writer = new ObjectWriter(fo.getOutputStream(false));
                try {
                    writer.writeInt(count);
                    for (Object obj : values) {
                        writer.writeObject(obj);
                    }
                }
                catch (IOException e) {
                    throw new RQException(e.getMessage(), e);
                }
                finally {
                    try {
                        writer.close();
                    }
                    catch (IOException e) {
                        throw new RQException(e.getMessage(), e);
                    }
                }
                elementArray.clear();
                int size = entries.length;
                for (int i = 0; i < size; ++i) {
                    entries[i] = 0;
                }
                int[] linkArray = this._$4;
                int size2 = this._$6;
                for (int i = 1; i <= size2; ++i) {
                    linkArray[i] = 0;
                }
                elementArray.push(array, index);
                entries[hash] = 1;
            } else {
                elementArray.push(array, index);
                this._$4[count + 1] = entries[hash];
                entries[hash] = count + 1;
            }
        }

        public long result() {
            int fileCount = this._$1.size();
            if (fileCount == 0) {
                return this._$5.size();
            }
            Object[] objs = this._$5.toArray();
            MultithreadUtil.sort(objs);
            lIlIIIllIIllllII[] valuesArray = new lIlIIIllIIllllII[fileCount + 1];
            valuesArray[0] = new lllIllllIlllIlll(objs);
            for (int i = 0; i < fileCount; ++i) {
                valuesArray[i + 1] = new IIlIIllIIIlIlIlI(this._$1.get(i));
            }
            long result = ICountFile._$1(valuesArray);
            return result;
        }

        private static long _$1(lIlIIIllIIllllII[] valuesArray, int path, Object value) {
            if (valuesArray[path] == null) {
                return 0L;
            }
            long result = 0L;
            Object curValue = valuesArray[path].getTop();
            int pathCount = valuesArray.length;
            int nextPath = path + 1;
            while (curValue != null) {
                int cmp = Variant.compare(value, curValue, true);
                if (cmp < 0) {
                    if (nextPath < valuesArray.length) {
                        return result + ICountFile._$1(valuesArray, nextPath, value);
                    }
                    return result;
                }
                if (cmp == 0) {
                    valuesArray[path].pop();
                    if (nextPath < valuesArray.length) {
                        return result + ICountFile._$1(valuesArray, nextPath, value);
                    }
                    return result;
                }
                ++result;
                if (nextPath < valuesArray.length) {
                    result += ICountFile._$1(valuesArray, nextPath, curValue);
                }
                valuesArray[path].pop();
                curValue = valuesArray[path].getTop();
            }
            if (path < --pathCount) {
                System.arraycopy(valuesArray, path + 1, valuesArray, path, pathCount - path);
                valuesArray[pathCount] = null;
                return result + ICountFile._$1(valuesArray, path, value);
            }
            valuesArray[pathCount] = null;
            return result;
        }

        private static long _$1(lIlIIIllIIllllII[] valuesArray) {
            int pathCount = valuesArray.length;
            long result = 0L;
            while (true) {
                Object value;
                if ((value = valuesArray[0].pop()) != null) {
                    result += ICountFile._$1(valuesArray, 1, value) + 1L;
                    continue;
                }
                if (valuesArray[1] == null) break;
                System.arraycopy(valuesArray, 1, valuesArray, 0, --pathCount);
                valuesArray[pathCount] = null;
            }
            return result;
        }
    }
}

