/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.fn.math;

import com.scudata.array.IArray;
import com.scudata.array.IntArray;
import com.scudata.array.LongArray;
import com.scudata.array.NumberArray;
import com.scudata.common.MessageManager;
import com.scudata.common.ObjectCache;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.dm.Sequence;
import com.scudata.expression.Function;
import com.scudata.expression.IParam;
import com.scudata.resources.EngineMessage;
import com.scudata.util.Variant;
import java.math.BigDecimal;
import java.math.BigInteger;

public class Bit1
extends Function {
    public void checkValidity() {
        if (this.param == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("bit1" + mm.getMessage("function.missingParam"));
        }
    }

    public static int bitCount(Object obj) {
        if (obj instanceof Long) {
            return Long.bitCount((Long)obj);
        }
        if (obj instanceof BigInteger) {
            return ((BigInteger)obj).bitCount();
        }
        if (obj instanceof Number) {
            return Integer.bitCount(((Number)obj).intValue());
        }
        if (obj instanceof Sequence) {
            Sequence sequence = (Sequence)obj;
            return sequence.getMems().bit1();
        }
        if (obj == null) {
            return 0;
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException("bit1" + mm.getMessage("function.paramTypeError"));
    }

    private static int _$1(IArray array1, IArray array2) {
        int size = array1.size();
        int count = 0;
        if (array1 instanceof NumberArray && array2 instanceof NumberArray) {
            for (int i = 1; i <= size; ++i) {
                if (array1.isNull(i) || array2.isNull(i)) continue;
                count += Long.bitCount(array1.getLong(i) ^ array2.getLong(i));
            }
        } else {
            for (int i = 1; i <= size; ++i) {
                count += Bit1.bitCount(array1.get(i), array2.get(i));
            }
        }
        return count;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int bitCount(Object v1, Object v2) {
        BigInteger bi;
        long longValue;
        block19: {
            longValue = 0L;
            bi = null;
            if (v1 instanceof BigDecimal) {
                bi = ((BigDecimal)v1).toBigInteger();
            } else if (v1 instanceof BigInteger) {
                bi = (BigInteger)v1;
            } else if (v1 instanceof Number) {
                longValue = ((Number)v1).longValue();
            } else {
                if (v1 == null) {
                    return 0;
                }
                MessageManager mm = EngineMessage.get();
                throw new RQException("bit1" + mm.getMessage("function.paramTypeError"));
            }
            if (bi != null) {
                if (v2 instanceof Number) {
                    BigInteger tmp = Variant.toBigInteger((Number)v2);
                    bi = bi.xor(tmp);
                    break block19;
                } else {
                    if (v2 == null) {
                        return 0;
                    }
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("bit1" + mm.getMessage("function.paramTypeError"));
                }
            }
            if (v2 instanceof BigDecimal) {
                bi = ((BigDecimal)v2).toBigInteger();
                bi = bi.xor(BigInteger.valueOf(longValue));
            } else if (v2 instanceof BigInteger) {
                bi = (BigInteger)v2;
                bi = bi.xor(BigInteger.valueOf(longValue));
            } else if (v2 instanceof Number) {
                longValue ^= ((Number)v2).longValue();
            } else {
                if (v2 == null) {
                    return 0;
                }
                MessageManager mm = EngineMessage.get();
                throw new RQException("bit1" + mm.getMessage("function.paramTypeError"));
            }
        }
        if (bi == null) {
            return Long.bitCount(longValue);
        }
        return bi.bitCount();
    }

    public Object calculate(Context ctx) {
        if (this.param.isLeaf()) {
            Object obj = this.param.getLeafExpression().calculate(ctx);
            return ObjectCache.getInteger(Bit1.bitCount(obj));
        }
        if (this.param.getSubSize() == 2) {
            IParam sub1 = this.param.getSub(0);
            IParam sub2 = this.param.getSub(1);
            if (sub1 == null || sub2 == null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("bit1" + mm.getMessage("function.invalidParam"));
            }
            Object obj1 = sub1.getLeafExpression().calculate(ctx);
            Object obj2 = sub2.getLeafExpression().calculate(ctx);
            if (obj1 instanceof Sequence && obj2 instanceof Sequence) {
                IArray array1 = ((Sequence)obj1).getMems();
                IArray array2 = ((Sequence)obj2).getMems();
                return ObjectCache.getInteger(Bit1._$1(array1, array2));
            }
            return ObjectCache.getInteger(Bit1.bitCount(obj1, obj2));
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException("bit1" + mm.getMessage("function.invalidParam"));
    }

    public IArray calculateAll(Context ctx) {
        if (this.param.isLeaf()) {
            IArray array = this.param.getLeafExpression().calculateAll(ctx);
            int len = array.size();
            IntArray result = new IntArray(len);
            if (array instanceof IntArray) {
                IntArray intArray = (IntArray)array;
                for (int i = 1; i <= len; ++i) {
                    if (intArray.isNull(i)) {
                        result.pushInt(0);
                        continue;
                    }
                    result.pushInt(Integer.bitCount(intArray.getInt(i)));
                }
            } else if (array instanceof LongArray) {
                LongArray longArray = (LongArray)array;
                for (int i = 1; i <= len; ++i) {
                    if (longArray.isNull(i)) {
                        result.pushInt(0);
                        continue;
                    }
                    result.pushInt(Long.bitCount(longArray.getLong(i)));
                }
            } else {
                for (int i = 1; i <= len; ++i) {
                    result.pushInt(Bit1.bitCount(array.get(i)));
                }
            }
            return result;
        }
        if (this.param.getSubSize() == 2) {
            IParam sub1 = this.param.getSub(0);
            IParam sub2 = this.param.getSub(1);
            if (sub1 == null || sub2 == null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("bit1" + mm.getMessage("function.invalidParam"));
            }
            IArray array1 = sub1.getLeafExpression().calculateAll(ctx);
            IArray array2 = sub2.getLeafExpression().calculateAll(ctx);
            int len = array1.size();
            IntArray result = new IntArray(len);
            if (array1 instanceof NumberArray && array2 instanceof NumberArray) {
                for (int i = 1; i <= len; ++i) {
                    if (array1.isNull(i) || array2.isNull(i)) {
                        result.pushInt(0);
                        continue;
                    }
                    int count = Long.bitCount(array1.getLong(i) ^ array2.getLong(i));
                    result.pushInt(count);
                }
            } else {
                for (int i = 1; i <= len; ++i) {
                    int count;
                    Object obj1 = array1.get(i);
                    Object obj2 = array2.get(i);
                    if (obj1 instanceof Sequence && obj2 instanceof Sequence) {
                        count = Bit1._$1(((Sequence)obj1).getMems(), ((Sequence)obj2).getMems());
                        result.pushInt(count);
                        continue;
                    }
                    count = Bit1.bitCount(obj1, obj2);
                    result.pushInt(count);
                }
            }
            return result;
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException("bit1" + mm.getMessage("function.invalidParam"));
    }

    public IArray calculateAll(Context ctx, IArray signArray, boolean sign) {
        if (this.param.isLeaf()) {
            IArray array = this.param.getLeafExpression().calculateAll(ctx, signArray, sign);
            int len = array.size();
            IntArray result = new IntArray(len);
            if (array instanceof IntArray) {
                IntArray intArray = (IntArray)array;
                for (int i = 1; i <= len; ++i) {
                    if (intArray.isNull(i)) {
                        result.pushInt(0);
                        continue;
                    }
                    if (signArray.isTrue(i) == sign) {
                        result.pushInt(Integer.bitCount(intArray.getInt(i)));
                        continue;
                    }
                    result.pushInt(0);
                }
            } else if (array instanceof LongArray) {
                LongArray longArray = (LongArray)array;
                for (int i = 1; i <= len; ++i) {
                    if (longArray.isNull(i)) {
                        result.pushInt(0);
                        continue;
                    }
                    if (signArray.isTrue(i) == sign) {
                        result.pushInt(Long.bitCount(longArray.getLong(i)));
                        continue;
                    }
                    result.pushInt(0);
                }
            } else {
                for (int i = 1; i <= len; ++i) {
                    if (signArray.isTrue(i) == sign) {
                        result.pushInt(Bit1.bitCount(array.get(i)));
                        continue;
                    }
                    result.pushInt(0);
                }
            }
            return result;
        }
        if (this.param.getSubSize() == 2) {
            IParam sub1 = this.param.getSub(0);
            IParam sub2 = this.param.getSub(1);
            if (sub1 == null || sub2 == null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("bit1" + mm.getMessage("function.invalidParam"));
            }
            IArray array1 = sub1.getLeafExpression().calculateAll(ctx, signArray, sign);
            IArray array2 = sub2.getLeafExpression().calculateAll(ctx, signArray, sign);
            int len = array1.size();
            IntArray result = new IntArray(len);
            if (array1 instanceof NumberArray && array2 instanceof NumberArray) {
                for (int i = 1; i <= len; ++i) {
                    if (array1.isNull(i) || array2.isNull(i)) {
                        result.pushInt(0);
                        continue;
                    }
                    if (signArray.isTrue(i) == sign) {
                        int count = Long.bitCount(array1.getLong(i) ^ array2.getLong(i));
                        result.pushInt(count);
                        continue;
                    }
                    result.pushInt(0);
                }
            } else {
                for (int i = 1; i <= len; ++i) {
                    Object obj1 = array1.get(i);
                    Object obj2 = array2.get(i);
                    if (signArray.isTrue(i) == sign) {
                        int count;
                        if (obj1 instanceof Sequence && obj2 instanceof Sequence) {
                            count = Bit1._$1(((Sequence)obj1).getMems(), ((Sequence)obj2).getMems());
                            result.pushInt(count);
                            continue;
                        }
                        count = Bit1.bitCount(obj1, obj2);
                        result.pushInt(count);
                        continue;
                    }
                    result.pushInt(0);
                }
            }
            return result;
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException("bit1" + mm.getMessage("function.invalidParam"));
    }
}

