/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.fn.math;

import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.expression.Function;
import com.scudata.expression.IParam;
import com.scudata.expression.fn.math.Fact;
import com.scudata.resources.EngineMessage;
import com.scudata.util.Variant;

public class Combin
extends Function {
    public void checkValidity() {
        if (this.param == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("combin" + mm.getMessage("function.missingParam"));
        }
        if (this.param.getSubSize() != 2) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("combin" + mm.getMessage("function.invalidParam"));
        }
    }

    public Object calculate(Context ctx) {
        IParam sub1 = this.param.getSub(0);
        IParam sub2 = this.param.getSub(1);
        if (sub1 == null || sub2 == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("combin" + mm.getMessage("function.invalidParam"));
        }
        Object result1 = sub1.getLeafExpression().calculate(ctx);
        if (result1 == null) {
            return null;
        }
        if (!(result1 instanceof Number)) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("The first param of combin" + mm.getMessage("function.paramTypeError"));
        }
        Object result2 = sub2.getLeafExpression().calculate(ctx);
        if (result2 == null) {
            return null;
        }
        if (!(result2 instanceof Number)) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("The second param of combin" + mm.getMessage("function.paramTypeError"));
        }
        return new Long(this._$1(Variant.longValue(result1), Variant.longValue(result2)));
    }

    private long _$1(long n, long k) {
        if (n < k) {
            return 0L;
        }
        if (n <= 0L || k <= 0L) {
            return 0L;
        }
        long result = 1L;
        if (k > n / 2L) {
            for (long i = n; i > k; --i) {
                result *= i;
            }
            result /= Fact.fact(n - k);
        } else {
            for (long i = n; i > n - k; --i) {
                result *= i;
            }
            result /= Fact.fact(k);
        }
        return result;
    }
}

