/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.fn.string;

import com.scudata.common.Logger;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.expression.fn.CharFunction;
import com.scudata.expression.fn.string.DESEncrypt;
import com.scudata.resources.EngineMessage;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class AESEncrypt
extends CharFunction {
    private static final String _$6 = "AES";
    private static final String _$5 = "AES/ECB/PKCS5Padding";
    private static final String _$4 = "AES/CBC/PKCS5Padding";
    private static final String _$3 = "AES/ECB/NoPadding";
    private static final String _$2 = "AES/CBC/NoPadding";
    private static final byte[] _$1 = DESEncrypt.encode("1a3b5c7d9e0f2g4h", "utf-8");

    protected Object doQuery(Object[] objs) {
        try {
            MessageManager mm;
            if (objs == null || objs.length < 2) {
                MessageManager mm2 = EngineMessage.get();
                throw new RQException("aes" + mm2.getMessage("function.invalidParam"));
            }
            Object[] params = objs;
            String charset = "utf-8";
            if (this.param.getType() == ';') {
                Object obj = objs[0];
                params = obj instanceof Object[] ? (Object[])obj : new Object[]{obj};
                if (objs[1] instanceof String) {
                    charset = (String)objs[1];
                } else {
                    MessageManager mm3 = EngineMessage.get();
                    throw new RQException("aes(...;charset), charset is invalid." + mm3.getMessage("function.invalidParam"));
                }
            }
            if (params == null || params.length < 2) {
                MessageManager mm4 = EngineMessage.get();
                throw new RQException("aes" + mm4.getMessage("function.invalidParam"));
            }
            byte[] inputb = DESEncrypt.encode(params[0], charset);
            byte[] keyb = DESEncrypt.encode(params[1], charset);
            byte[] ivb = null;
            if (inputb == null) {
                return null;
            }
            if (keyb == null) {
                return inputb;
            }
            if (params.length > 2) {
                ivb = DESEncrypt.encode(params[2], charset);
            }
            boolean dec = false;
            boolean modeC = false;
            boolean nopad = false;
            boolean autopad = false;
            boolean decStr = false;
            if (this.option != null) {
                if (this.option.indexOf(100) > -1) {
                    dec = true;
                }
                if (this.option.indexOf(99) > -1) {
                    modeC = true;
                }
                if (this.option.indexOf(110) > -1) {
                    nopad = true;
                }
                if (this.option.indexOf(97) > -1) {
                    autopad = true;
                }
                if (this.option.indexOf(115) > -1) {
                    decStr = true;
                }
            }
            if (nopad && inputb.length % 16 != 0) {
                if (autopad) {
                    mm = EngineMessage.get();
                    Logger.info("aes(input, key, iv; charset): " + mm.getMessage("encrypt.autopadding", "input", 16));
                    inputb = AESEncrypt.autoPadding(inputb, 16);
                } else {
                    MessageManager mm5 = EngineMessage.get();
                    throw new RQException("aes(input, key, iv; charset): " + mm5.getMessage("encrypt.nopadding", "input", 16));
                }
            }
            if (keyb.length != 16) {
                if (autopad) {
                    keyb = AESEncrypt.padding(keyb, 16);
                } else {
                    mm = EngineMessage.get();
                    throw new RQException("aes(input, key, iv; charset): " + mm.getMessage("encrypt.wronglen", "key", 16));
                }
            }
            Cipher ci = null;
            if (modeC) {
                if (ivb == null) {
                    MessageManager mm6 = EngineMessage.get();
                    Logger.info("aes(input, key, iv; charset): " + mm6.getMessage("encrypt.CBCnoiv"));
                    ivb = _$1;
                } else if (ivb.length != 16) {
                    if (autopad) {
                        ivb = AESEncrypt.padding(keyb, 16);
                    } else {
                        MessageManager mm7 = EngineMessage.get();
                        throw new RQException("aes(input, key, iv; charset): " + mm7.getMessage("encrypt.wronglen", "iv", 16));
                    }
                }
                ci = nopad ? Cipher.getInstance(_$2) : Cipher.getInstance(_$4);
            } else {
                ci = nopad ? Cipher.getInstance(_$3) : Cipher.getInstance(_$5);
            }
            IvParameterSpec iv = null;
            if (ivb != null) {
                iv = new IvParameterSpec(ivb);
            }
            SecretKeySpec key = new SecretKeySpec(keyb, _$6);
            byte[] result = null;
            if (dec) {
                if (!modeC) {
                    ci.init(2, key);
                    result = ci.doFinal(inputb);
                } else {
                    ci.init(2, (Key)key, iv);
                    result = ci.doFinal(inputb);
                }
                if (decStr) {
                    return DESEncrypt.encode(result, charset);
                }
            } else if (!modeC) {
                ci.init(1, key);
                result = ci.doFinal(inputb);
            } else {
                ci.init(1, (Key)key, iv);
                result = ci.doFinal(inputb);
            }
            return result;
        }
        catch (Exception e) {
            Logger.error(e.getMessage());
            return null;
        }
    }

    protected static byte[] padding(byte[] input, int length) {
        byte[] result = new byte[length];
        if (input == null) {
            return result;
        }
        int len = input.length;
        if (len == length) {
            return input;
        }
        if (len > length) {
            for (int i = 0; i < length; ++i) {
                result[i] = input[i];
            }
        } else {
            for (int i = 0; i < len; ++i) {
                result[i] = input[i];
            }
        }
        return result;
    }

    protected static byte[] autoPadding(byte[] input, int size) {
        int i;
        byte[] result = new byte[size];
        if (input == null) {
            return result;
        }
        int len = input.length;
        int length = len / size * size;
        byte diff = (byte)(length + size - len);
        if (len == length) {
            return input;
        }
        result = new byte[length += size];
        for (i = 0; i < len; ++i) {
            result[i] = input[i];
        }
        while (i < length) {
            result[i] = diff;
            ++i;
        }
        return result;
    }
}

