/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.mfn.channel;

import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.expression.ChannelFunction;
import com.scudata.expression.Expression;
import com.scudata.expression.IParam;
import com.scudata.resources.EngineMessage;

public class Sortx
extends ChannelFunction {
    /*
     * Enabled aggressive block sorting
     */
    public Object calculate(Context ctx) {
        Expression[] exps;
        if (this.param == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("sortx" + mm.getMessage("function.missingParam"));
        }
        IParam sortParam = null;
        int capacity = -1;
        if (this.param.getType() == ';') {
            if (this.param.getSubSize() > 2) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("sortx" + mm.getMessage("function.invalidParam"));
            }
            sortParam = this.param.getSub(0);
            if (sortParam == null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("sortx" + mm.getMessage("function.invalidParam"));
            }
            IParam sub = this.param.getSub(1);
            if (sub == null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("sortx" + mm.getMessage("function.invalidParam"));
            }
            if (!sub.isLeaf()) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("sortx" + mm.getMessage("function.invalidParam"));
            }
            Object obj = sub.getLeafExpression().calculate(ctx);
            if (!(obj instanceof Number)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("sortx" + mm.getMessage("function.paramTypeError"));
            }
            int n = ((Number)obj).intValue();
            if (n > 0) {
                capacity = n;
            }
        } else {
            sortParam = this.param;
        }
        if (sortParam.isLeaf()) {
            exps = new Expression[]{sortParam.getLeafExpression()};
        } else {
            if (sortParam.getType() != ',') {
                MessageManager mm = EngineMessage.get();
                throw new RQException("sortx" + mm.getMessage("function.invalidParam"));
            }
            int size = sortParam.getSubSize();
            exps = new Expression[size];
            for (int i = 0; i < size; ++i) {
                IParam sub = sortParam.getSub(i);
                if (sub == null || !sub.isLeaf()) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("sortx" + mm.getMessage("function.invalidParam"));
                }
                exps[i] = sub.getLeafExpression();
            }
        }
        this.channel.sortx(exps, capacity, this.option);
        return this.channel;
    }
}

