/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.mfn.cursor;

import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.dm.Env;
import com.scudata.dm.cursor.ICursor;
import com.scudata.dm.cursor.MultipathCursors;
import com.scudata.dm.cursor.SyncCursor;
import com.scudata.expression.CursorFunction;
import com.scudata.resources.EngineMessage;

public class MCursor
extends CursorFunction {
    public Object calculate(Context ctx) {
        int pathCount = Env.getCursorParallelNum();
        if (this.param != null) {
            if (this.param.isLeaf()) {
                Object obj = this.param.getLeafExpression().calculate(ctx);
                if (obj instanceof Number) {
                    pathCount = ((Number)obj).intValue();
                } else if (obj != null) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("mcursor" + mm.getMessage("function.paramTypeError"));
                }
            } else {
                MessageManager mm = EngineMessage.get();
                throw new RQException("mcursor" + mm.getMessage("function.invalidParam"));
            }
        }
        if (pathCount > 1) {
            ICursor[] cursors = new ICursor[pathCount];
            for (int i = 0; i < pathCount; ++i) {
                cursors[i] = new SyncCursor(this.cursor);
            }
            return new MultipathCursors(cursors, ctx);
        }
        return this.cursor;
    }
}

