/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.mfn.dw;

import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.dm.DataStruct;
import com.scudata.dm.FileObject;
import com.scudata.dm.Sequence;
import com.scudata.dm.cursor.MemoryCursor;
import com.scudata.dw.ComTable;
import com.scudata.dw.Cuboid;
import com.scudata.dw.IPhyTable;
import com.scudata.dw.PhyTable;
import com.scudata.dw.PhyTableGroup;
import com.scudata.expression.Expression;
import com.scudata.expression.IParam;
import com.scudata.expression.ParamInfo2;
import com.scudata.expression.PhyTableFunction;
import com.scudata.resources.EngineMessage;
import java.io.File;
import java.io.IOException;

public class CreateCuboid
extends PhyTableFunction {
    public Object calculate(Context ctx) {
        if (this.table instanceof PhyTableGroup) {
            IPhyTable[] tables;
            for (IPhyTable t : tables = ((PhyTableGroup)this.table).getTables()) {
                CreateCuboid._$1((PhyTable)t, this.param, ctx);
            }
            return this.table;
        }
        PhyTable srcTable = (PhyTable)this.table;
        return CreateCuboid._$1(srcTable, this.param, ctx);
    }

    private static Object _$1(PhyTable srcTable, IParam param, Context ctx) {
        int fcount;
        FileObject fo;
        IParam sub0;
        if (param == null) {
            try {
                return srcTable.deleteCuboid(null);
            }
            catch (IOException e) {
                throw new RQException(e.getMessage(), e);
            }
        }
        if (param.isLeaf()) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("cuboid" + mm.getMessage("function.invalidParam"));
        }
        IParam sub1 = null;
        if (param.getType() == ';') {
            int size = param.getSubSize();
            if (size > 2) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("cuboid" + mm.getMessage("function.invalidParam"));
            }
            sub0 = param.getSub(0);
            if (sub0 == null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("cuboid" + mm.getMessage("function.invalidParam"));
            }
            sub1 = param.getSub(1);
        } else {
            sub0 = param;
        }
        FileObject C = (FileObject)sub0.getSub(0).getLeafExpression().calculate(ctx);
        sub0 = sub0.create(1, sub0.getSubSize());
        String[] names = null;
        Expression[] newExps = null;
        String[] newNames = null;
        ParamInfo2 pi0 = ParamInfo2.parse(sub0, "cuboid", true, false);
        Expression[] exps = pi0.getExpressions1();
        names = new String[exps.length];
        int i = 0;
        for (Expression e : exps) {
            String s = e.getIdentifierName();
            names[i++] = s;
        }
        ParamInfo2 pi1 = null;
        if (sub1 != null) {
            pi1 = ParamInfo2.parse(sub1, "cuboid", true, false);
            newExps = pi1.getExpressions1();
            newNames = new String[newExps.length];
            i = 0;
            for (Expression e : newExps) {
                String s = e.getIdentifierName();
                newNames[i++] = s;
            }
        }
        if ((fo = C).isExists()) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(fo.getFileName() + mm.getMessage("dw.cuboidAlreadyExist"));
        }
        String[] cuboids = srcTable.getCuboids();
        if (cuboids != null) {
            for (String c : cuboids) {
                if (!C.equals(c)) continue;
                MessageManager mm = EngineMessage.get();
                throw new RQException("cuboid" + mm.getMessage("dw.cuboidAlreadyExist"));
            }
        }
        int n = fcount = exps == null ? 0 : exps.length;
        if (newExps != null) {
            fcount += newExps.length;
        }
        MemoryCursor cursor = new MemoryCursor(Cuboid.cgroups(sub0, sub1, srcTable, null, false, 0, null, ctx));
        File file = fo.getLocalFile().file();
        String[] colNames = new String[fcount];
        int[] sbytes = new int[fcount];
        i = 0;
        for (String n2 : names) {
            colNames[i++] = "#" + n2;
        }
        for (String s : newNames) {
            colNames[i++] = s;
        }
        ComTable table = null;
        try {
            table = new Cuboid(file, colNames, sbytes, ctx, "cuboid", "cuboid", pi0.getExpressionStrs1(), pi1.getExpressionStrs1());
            ((Cuboid)table).save();
            table.close();
            table = new Cuboid(file, ctx);
            table.checkPassword("cuboid");
            Sequence data = cursor.peek(1);
            if (data == null || data.length() <= 0) {
                return srcTable;
            }
            DataStruct ds = data.dataStruct();
            String[] fnames = ds.getFieldNames();
            System.arraycopy(colNames, 0, fnames, 0, fcount);
            System.arraycopy(names, 0, fnames, 0, names.length);
            ((Cuboid)table).append(cursor);
            ((Cuboid)table).setSrcCount(srcTable.getActualRecordCount());
            ((Cuboid)table).writeHeader();
            table.close();
        }
        catch (Exception e) {
            if (table != null) {
                table.close();
            }
            file.delete();
            throw new RQException(e.getMessage(), e);
        }
        return srcTable;
    }
}

