/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.mfn.file;

import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.BFileWriter;
import com.scudata.dm.Context;
import com.scudata.dm.FileObject;
import com.scudata.dm.IFile;
import com.scudata.dm.LocalFile;
import com.scudata.dm.Sequence;
import com.scudata.dm.cursor.ICursor;
import com.scudata.dm.cursor.MemoryCursor;
import com.scudata.expression.Expression;
import com.scudata.expression.FileFunction;
import com.scudata.expression.IParam;
import com.scudata.resources.EngineMessage;
import java.io.File;
import java.io.IOException;

public class Export
extends FileFunction {
    public Object calculate(Context ctx) {
        Object src;
        IParam param0;
        if (this.param == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("export" + mm.getMessage("function.missingParam"));
        }
        Expression sexp = null;
        if (this.param.getType() == ';') {
            if (this.param.getSubSize() != 2) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("export" + mm.getMessage("function.invalidParam"));
            }
            param0 = this.param.getSub(0);
            if (param0 == null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("export" + mm.getMessage("function.invalidParam"));
            }
            IParam param1 = this.param.getSub(1);
            if (param1 != null) {
                sexp = param1.getLeafExpression();
            }
        } else {
            param0 = this.param;
        }
        Expression[] exps = null;
        String[] names = null;
        if (param0.isLeaf()) {
            src = param0.getLeafExpression().calculate(ctx);
        } else {
            IParam sub = param0.getSub(0);
            if (sub == null || !sub.isLeaf()) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("export" + mm.getMessage("function.invalidParam"));
            }
            src = sub.getLeafExpression().calculate(ctx);
            int size = param0.getSubSize();
            exps = new Expression[size - 1];
            names = new String[size - 1];
            for (int i = 1; i < size; ++i) {
                MessageManager mm;
                sub = param0.getSub(i);
                if (sub == null) {
                    mm = EngineMessage.get();
                    throw new RQException("export" + mm.getMessage("function.invalidParam"));
                }
                if (sub.isLeaf()) {
                    exps[i - 1] = sub.getLeafExpression();
                    continue;
                }
                if (sub.getSubSize() != 2) {
                    mm = EngineMessage.get();
                    throw new RQException("export" + mm.getMessage("function.invalidParam"));
                }
                IParam p1 = sub.getSub(0);
                if (p1 == null) {
                    MessageManager mm2 = EngineMessage.get();
                    throw new RQException("export" + mm2.getMessage("function.invalidParam"));
                }
                exps[i - 1] = p1.getLeafExpression();
                IParam p2 = sub.getSub(1);
                if (p2 == null) continue;
                names[i - 1] = p2.getLeafExpression().getIdentifierName();
            }
        }
        Export._$1(this.file, src, exps, names, sexp, this.option, ctx);
        return null;
    }

    private static void _$1(FileObject fo, Object src, Expression[] exps, String[] names, Expression sexp, String opt, Context ctx) {
        IFile ifile = fo.getFile();
        if ((opt == null || opt.indexOf(97) == -1) && ifile instanceof LocalFile && ifile.size() > 0L) {
            File tmpFile;
            File oldFile = ((LocalFile)ifile).file();
            File parentFile = oldFile.getParentFile();
            try {
                tmpFile = File.createTempFile("tmpdata", "", parentFile);
            }
            catch (IOException e) {
                throw new RQException(e.getMessage(), e);
            }
            String cs = fo.getCharset();
            LocalFile lf = new LocalFile(tmpFile.getName(), null, ctx);
            lf.setParent(parentFile.getAbsolutePath());
            fo = new FileObject(lf, tmpFile.getAbsolutePath(), cs, null);
            try {
                if (sexp != null && BFileWriter.isBtxOption(opt)) {
                    ICursor cursor;
                    if (src instanceof Sequence || src == null) {
                        cursor = new MemoryCursor((Sequence)src);
                    } else if (src instanceof ICursor) {
                        cursor = (ICursor)src;
                    } else {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException("export" + mm.getMessage("function.paramTypeError"));
                    }
                    fo.export_g(cursor, exps, names, sexp, opt, ctx);
                } else {
                    Object s;
                    Object object = s = sexp == null ? null : sexp.calculate(ctx);
                    if (src instanceof Sequence || src == null) {
                        fo.exportSeries((Sequence)src, exps, names, opt, s, ctx);
                    } else if (src instanceof ICursor) {
                        fo.exportCursor((ICursor)src, exps, names, opt, s, ctx);
                    } else {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException("export" + mm.getMessage("function.paramTypeError"));
                    }
                }
                if (!oldFile.delete()) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("export" + mm.getMessage("file.deleteFailed"));
                }
                tmpFile.renameTo(oldFile);
            }
            catch (RuntimeException e) {
                tmpFile.delete();
                throw e;
            }
        }
        if (sexp != null && BFileWriter.isBtxOption(opt)) {
            ICursor cursor;
            if (src instanceof Sequence || src == null) {
                cursor = new MemoryCursor((Sequence)src);
            } else if (src instanceof ICursor) {
                cursor = (ICursor)src;
            } else {
                MessageManager mm = EngineMessage.get();
                throw new RQException("export" + mm.getMessage("function.paramTypeError"));
            }
            fo.export_g(cursor, exps, names, sexp, opt, ctx);
        } else {
            Object s;
            Object object = s = sexp == null ? null : sexp.calculate(ctx);
            if (src instanceof Sequence || src == null) {
                fo.exportSeries((Sequence)src, exps, names, opt, s, ctx);
            } else if (src instanceof ICursor) {
                fo.exportCursor((ICursor)src, exps, names, opt, s, ctx);
            } else {
                MessageManager mm = EngineMessage.get();
                throw new RQException("export" + mm.getMessage("function.paramTypeError"));
            }
        }
    }
}

