/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.mfn.file;

import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.BaseRecord;
import com.scudata.dm.Context;
import com.scudata.dm.DataStruct;
import com.scudata.dm.FileObject;
import com.scudata.dm.ObjectReader;
import com.scudata.dm.Record;
import com.scudata.dm.Sequence;
import com.scudata.dw.BlockLink;
import com.scudata.dw.BlockLinkReader;
import com.scudata.dw.ColPhyTable;
import com.scudata.dw.ColumnMetaData;
import com.scudata.dw.ComTable;
import com.scudata.dw.Cuboid;
import com.scudata.dw.DataBlockType;
import com.scudata.dw.ITableIndex;
import com.scudata.dw.PhyTable;
import com.scudata.dw.PhyTableIndex;
import com.scudata.dw.RowPhyTable;
import com.scudata.expression.FileFunction;
import com.scudata.parallel.ClusterFile;
import com.scudata.parallel.ClusterPhyTable;
import com.scudata.resources.EngineMessage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

public class Structure
extends FileFunction {
    private static final String[] _$9 = new String[]{"field", "key", "del", "row", "zip", "seg", "zonex", "attach", "block"};
    private static final String[] _$8 = new String[]{"name", "field", "key", "row", "zip", "seg", "zonex", "attach"};
    private static final String[] _$7 = new String[]{"name", "dim", "type", "type-len", "dict"};
    private static final String[] _$6 = new String[]{"name", "dim", "type", "type-len", "dict", "block-nums", "block-ratio"};
    private static final String[] _$5 = new String[]{"name", "dim"};
    private static final String[] _$4 = new String[]{"name", "keys", "aggr"};
    private static final String[] _$3 = new String[]{"keys", "aggr"};
    private static final String[] _$2 = new String[]{"name", "exp"};
    private static final String[] _$1 = new String[]{"min", "max", "count", "pos"};

    public Object calculate(Context ctx) {
        if (this.file.isRemoteFile()) {
            String host = this.file.getIP();
            int port = this.file.getPort();
            String fileName = this.file.getFileName();
            Integer partition = this.file.getPartition();
            int p = partition == null ? -1 : partition;
            ClusterFile cf = new ClusterFile(host, port, fileName, p, ctx);
            ClusterPhyTable table = cf.openGroupTable(ctx);
            Sequence seq = new Sequence();
            seq.add(Structure.getTableStruct(table, this.option));
            table.close();
            return seq;
        }
        boolean hasI = false;
        boolean hasC = false;
        if (this.option != null) {
            if (this.option.indexOf(105) != -1) {
                hasI = true;
            }
            if (this.option.indexOf(99) != -1) {
                hasC = true;
            }
        }
        if (hasI) {
            Sequence seq = new Sequence();
            seq.add(PhyTableIndex.getIndexStruct(this.file));
            return seq;
        }
        if (hasC) {
            Sequence seq = new Sequence();
            seq.add(Structure._$1(this.file));
            return seq;
        }
        PhyTable table = ComTable.openBaseTable(this.file, ctx);
        Integer partition = this.file.getPartition();
        if (partition != null && partition > 0) {
            table.getGroupTable().setPartition(partition);
        }
        if (table instanceof ColPhyTable && this.option != null && this.option.indexOf("b") != -1) {
            return this._$1((ColPhyTable)table);
        }
        Sequence seq = new Sequence();
        seq.add(Structure.getTableStruct(table, this.option));
        table.close();
        return seq;
    }

    protected static BaseRecord getTableStruct(ClusterPhyTable table, String option) {
        return table.getStructure();
    }

    public static Record getTableStruct(PhyTable table, String option) {
        Record rec;
        int idx = 0;
        if (table.isBaseTable()) {
            rec = new Record(new DataStruct(_$9));
        } else {
            rec = new Record(new DataStruct(_$8));
            rec.setNormalFieldValue(idx++, table.getTableName());
        }
        String[] colNames = table.getAllColNames();
        rec.setNormalFieldValue(idx++, Structure.getTableColumnStruct(table, option));
        rec.setNormalFieldValue(idx++, table.hasPrimaryKey());
        if (table.isBaseTable()) {
            rec.setNormalFieldValue(idx++, table.getGroupTable().hasDeleteKey());
        }
        rec.setNormalFieldValue(idx++, table instanceof RowPhyTable);
        rec.setNormalFieldValue(idx++, table.getGroupTable().isCompress());
        String seg = table.getSegmentCol();
        rec.setNormalFieldValue(idx++, seg != null && colNames[0] != null && seg.equals(colNames[0]));
        rec.setNormalFieldValue(idx++, table.getGroupTable().getDistribute());
        ArrayList<PhyTable> tables = table.getTableList();
        if (tables != null && tables.size() > 0) {
            Sequence seq = new Sequence();
            for (PhyTable tbl : tables) {
                seq.add(Structure.getTableStruct(tbl, option));
            }
            rec.setNormalFieldValue(idx, seq);
        }
        if (table.isBaseTable()) {
            rec.setNormalFieldValue(++idx, table.getGroupTable().getBlockSize());
        }
        return rec;
    }

    protected static Sequence getTableColumnStruct(PhyTable table, String option) {
        Sequence seq = new Sequence();
        if (table instanceof ColPhyTable) {
            DataStruct ds;
            ColumnMetaData[] columns = ((ColPhyTable)table).getColumns();
            boolean isExt = option != null && option.indexOf("e") != -1;
            double blockCount = 0.0;
            if (isExt) {
                ds = new DataStruct(_$6);
                for (ColumnMetaData column : columns) {
                    blockCount += (double)Structure._$1(column);
                }
            } else {
                ds = new DataStruct(_$7);
            }
            for (ColumnMetaData column : columns) {
                Record rec = new Record(ds);
                rec.setNormalFieldValue(0, column.getColName());
                rec.setNormalFieldValue(1, column.isKey());
                rec.setNormalFieldValue(2, DataBlockType.getTypeName(column.getDataType()));
                rec.setNormalFieldValue(3, DataBlockType.getTypeLen(column.getDataType()));
                Sequence dict = column.getDict();
                if (dict != null && dict.length() == 0) {
                    dict = null;
                }
                rec.setNormalFieldValue(4, dict);
                if (isExt) {
                    int num = Structure._$1(column);
                    rec.setNormalFieldValue(5, num);
                    rec.setNormalFieldValue(6, String.format("%.2f", (double)num / blockCount * 100.0));
                }
                seq.add(rec);
            }
        } else {
            RowPhyTable rowTable = (RowPhyTable)table;
            for (String column : rowTable.getColNames()) {
                Record rec = new Record(new DataStruct(_$5));
                rec.setNormalFieldValue(0, column);
                rec.setNormalFieldValue(1, rowTable.isDim(column));
                seq.add(rec);
            }
        }
        return seq;
    }

    protected static Sequence getTableIndexStruct(PhyTable table) {
        String[] inames = table.getIndexNames();
        if (inames == null) {
            return null;
        }
        Sequence seq = new Sequence();
        String dir = table.getGroupTable().getFile().getAbsolutePath() + "_";
        for (String iname : inames) {
            FileObject indexFile = new FileObject(dir + table.getTableName() + "_" + iname);
            if (!indexFile.isExists()) continue;
            ITableIndex index = table.getTableMetaDataIndex(indexFile, iname, true);
            seq.add(index.getIndexStruct());
        }
        return seq;
    }

    protected static Sequence getTableCuboidStruct(PhyTable table) {
        String[] cuboids = table.getCuboids();
        if (cuboids == null) {
            return null;
        }
        Sequence seq = new Sequence();
        String dir = table.getGroupTable().getFile().getAbsolutePath() + "_";
        for (String cuboid : cuboids) {
            FileObject fo = new FileObject(dir + table.getTableName() + "_CUBOID@" + cuboid);
            File file = fo.getLocalFile().file();
            ComTable srcCuboid = null;
            try {
                srcCuboid = new Cuboid(file, null);
                Record rec = new Record(new DataStruct(_$4));
                rec.setNormalFieldValue(0, cuboid);
                rec.setNormalFieldValue(1, new Sequence(((Cuboid)srcCuboid).getExps()));
                Sequence aggr = new Sequence();
                String[] newExps = ((Cuboid)srcCuboid).getNewExps();
                String[] names = srcCuboid.getBaseTable().getAllColNames();
                int len = newExps.length;
                int start = names.length - len;
                for (int i = 0; i < len; ++i) {
                    Record r = new Record(new DataStruct(_$2));
                    r.setNormalFieldValue(0, names[start + i]);
                    r.setNormalFieldValue(1, newExps[i]);
                    aggr.add(r);
                }
                rec.setNormalFieldValue(2, aggr);
                seq.add(rec);
                srcCuboid.close();
            }
            catch (Exception e) {
                if (srcCuboid == null) continue;
                srcCuboid.close();
            }
        }
        return seq;
    }

    private static Object _$1(FileObject fo) {
        File file = fo.getLocalFile().file();
        ComTable srcCuboid = null;
        Record rec = null;
        try {
            srcCuboid = new Cuboid(file, null);
            rec = new Record(new DataStruct(_$3));
            rec.setNormalFieldValue(0, new Sequence(((Cuboid)srcCuboid).getExps()));
            Sequence aggr = new Sequence();
            String[] newExps = ((Cuboid)srcCuboid).getNewExps();
            String[] names = srcCuboid.getBaseTable().getAllColNames();
            int len = newExps.length;
            int start = names.length - len;
            for (int i = 0; i < len; ++i) {
                Record r = new Record(new DataStruct(_$2));
                r.setNormalFieldValue(0, names[start + i]);
                r.setNormalFieldValue(1, newExps[i]);
                aggr.add(r);
            }
            rec.setNormalFieldValue(1, aggr);
            srcCuboid.close();
        }
        catch (Exception e) {
            if (srcCuboid != null) {
                srcCuboid.close();
            }
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("license.fileFormatError"));
        }
        return rec;
    }

    private Sequence _$1(ColPhyTable table) {
        String[] keys = table.getAllKeyColNames();
        if (keys == null) {
            return null;
        }
        ColumnMetaData[] cols = table.getColumns(keys);
        int curBlock = 0;
        int endBlock = table.getDataBlockCount();
        int fcount = keys.length;
        ObjectReader[] segmentReaders = new ObjectReader[fcount];
        for (int i = 0; i < fcount; ++i) {
            segmentReaders[i] = cols[i].getSegmentReader();
        }
        BlockLinkReader rowCountReader = table.getSegmentReader();
        Sequence result = new Sequence();
        String[] dsFields = (String[])_$1.clone();
        for (int i = 0; i < fcount; ++i) {
            dsFields[0] = dsFields[0] + "-" + cols[i].getColName();
        }
        try {
            while (curBlock < endBlock) {
                ++curBlock;
                int recordCount = rowCountReader.readInt32();
                Sequence minSeq = new Sequence();
                Sequence maxSeq = new Sequence();
                Sequence posSeq = new Sequence();
                for (int i = 0; i < fcount; ++i) {
                    long pos = segmentReaders[i].readLong40();
                    Object minValue = null;
                    Object maxValue = null;
                    if (cols[i].hasMaxMinValues()) {
                        minValue = segmentReaders[i].readObject();
                        maxValue = segmentReaders[i].readObject();
                        segmentReaders[i].skipObject();
                    }
                    minSeq.add(minValue);
                    maxSeq.add(maxValue);
                    posSeq.add(pos);
                }
                Record rec = new Record(new DataStruct(dsFields));
                if (fcount == 1) {
                    rec.setNormalFieldValue(0, minSeq.get(1));
                    rec.setNormalFieldValue(1, maxSeq.get(1));
                    rec.setNormalFieldValue(2, recordCount);
                    rec.setNormalFieldValue(3, posSeq.get(1));
                } else {
                    rec.setNormalFieldValue(0, minSeq);
                    rec.setNormalFieldValue(1, maxSeq);
                    rec.setNormalFieldValue(2, recordCount);
                    rec.setNormalFieldValue(3, posSeq);
                }
                result.add(rec);
            }
        }
        catch (IOException e) {
            throw new RQException(e.getMessage(), e);
        }
        finally {
            try {
                for (int i = 0; i < fcount; ++i) {
                    segmentReaders[i].close();
                }
                rowCountReader.close();
            }
            catch (IOException e) {}
        }
        return result;
    }

    private static int _$1(ColumnMetaData column) {
        BlockLink blockLink = column.getDataBlockLink();
        return blockLink.getBlockCount();
    }
}

