/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.mfn.file;

import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.common.StringUtils;
import com.scudata.dm.Context;
import com.scudata.dm.Env;
import com.scudata.dm.ILineInput;
import com.scudata.dm.UserUtils;
import com.scudata.dm.cursor.ICursor;
import com.scudata.excel.ExcelTool;
import com.scudata.excel.ExcelUtils;
import com.scudata.excel.XlsxSImporter;
import com.scudata.expression.FileFunction;
import com.scudata.expression.IParam;
import com.scudata.expression.Node;
import com.scudata.resources.AppMessage;
import com.scudata.resources.EngineMessage;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

public class XlsImport
extends FileFunction {
    public Object calculate(Context ctx) {
        boolean isXlsx;
        Object obj;
        String pwd;
        int end;
        int start;
        Object s;
        String[] fields;
        boolean hasTitle;
        boolean isCursor;
        String opt;
        block74: {
            IParam fieldParam;
            opt = this.option;
            XlsImport.checkOptions(opt);
            isCursor = opt != null && opt.indexOf("c") > -1;
            boolean bl = hasTitle = opt != null && opt.indexOf("t") > -1;
            if (this.param == null) {
                InputStream in = null;
                BufferedInputStream bis = null;
                try {
                    boolean isXlsx2 = ExcelUtils.isXlsxFile(this.file);
                    if (isCursor && !isXlsx2) {
                        MessageManager mm = AppMessage.get();
                        throw new RQException("xlsimport" + mm.getMessage("xlsfile.needxlsx"));
                    }
                    if (isCursor) {
                        XlsxSImporter importer = new XlsxSImporter(this.file, null, 0, 0, new Integer(1), opt);
                        String cursorOpt = "";
                        if (hasTitle) {
                            cursorOpt = cursorOpt + "t";
                        }
                        ICursor iCursor = UserUtils.newCursor(importer, cursorOpt);
                        return iCursor;
                    }
                    in = this.file.getInputStream();
                    bis = new BufferedInputStream(in, Env.FILE_BUFSIZE);
                    ExcelTool importer = new ExcelTool(in, isXlsx2, null);
                    Object cursorOpt = importer.fileXlsImport(opt);
                    return cursorOpt;
                }
                catch (IOException e) {
                    throw new RQException(e.getMessage(), e);
                }
                finally {
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (IOException e) {
                        throw new RQException(e.getMessage(), e);
                    }
                    try {
                        if (bis != null) {
                            bis.close();
                        }
                    }
                    catch (IOException e) {
                        throw new RQException(e.getMessage(), e);
                    }
                }
            }
            fields = null;
            s = null;
            start = 0;
            end = 0;
            pwd = null;
            if (this.param.getType() == ';') {
                IParam pwdParam;
                if (this.param.getSubSize() != 2 && this.param.getSubSize() != 3) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("xlsimport" + mm.getMessage("function.invalidParam"));
                }
                fieldParam = this.param.getSub(0);
                IParam param1 = this.param.getSub(1);
                if (this.param.getSubSize() == 3 && (pwdParam = this.param.getSub(2)) != null) {
                    Object tmp = pwdParam.getLeafExpression().calculate(ctx);
                    if (tmp != null) {
                        pwd = tmp.toString();
                    }
                    if ("".equals(pwd)) {
                        pwd = null;
                    }
                }
                if (param1 != null) {
                    if (param1.isLeaf()) {
                        s = param1.getLeafExpression().calculate(ctx);
                    } else {
                        IParam posParam;
                        if (param1.getSubSize() != 2) {
                            MessageManager mm = EngineMessage.get();
                            throw new RQException("xlsimport" + mm.getMessage("function.invalidParam"));
                        }
                        IParam sParam = param1.getSub(0);
                        if (sParam != null) {
                            s = sParam.getLeafExpression().calculate(ctx);
                        }
                        if ((posParam = param1.getSub(1)) != null) {
                            if (posParam.isLeaf()) {
                                Object obj2 = posParam.getLeafExpression().calculate(ctx);
                                if (!(obj2 instanceof Number)) {
                                    MessageManager mm = EngineMessage.get();
                                    throw new RQException("xlsimport" + mm.getMessage("function.paramTypeError"));
                                }
                                start = ((Number)obj2).intValue();
                            } else {
                                if (posParam.getSubSize() != 2) {
                                    MessageManager mm = EngineMessage.get();
                                    throw new RQException("xlsimport" + mm.getMessage("function.invalidParam"));
                                }
                                IParam sub0 = posParam.getSub(0);
                                IParam sub1 = posParam.getSub(1);
                                if (sub0 != null) {
                                    obj = sub0.getLeafExpression().calculate(ctx);
                                    if (!(obj instanceof Number)) {
                                        MessageManager mm = EngineMessage.get();
                                        throw new RQException("xlsimport" + mm.getMessage("function.paramTypeError"));
                                    }
                                    start = ((Number)obj).intValue();
                                }
                                if (sub1 != null) {
                                    obj = sub1.getLeafExpression().calculate(ctx);
                                    if (!(obj instanceof Number)) {
                                        MessageManager mm = EngineMessage.get();
                                        throw new RQException("xlsimport" + mm.getMessage("function.paramTypeError"));
                                    }
                                    end = ((Number)obj).intValue();
                                }
                            }
                        }
                    }
                }
            } else {
                fieldParam = this.param;
            }
            if (fieldParam != null) {
                if (fieldParam.isLeaf()) {
                    fields = new String[]{fieldParam.getLeafExpression().getIdentifierName()};
                } else {
                    int count = fieldParam.getSubSize();
                    fields = new String[count];
                    for (int i = 0; i < count; ++i) {
                        IParam sub = fieldParam.getSub(i);
                        if (sub == null || !sub.isLeaf()) {
                            MessageManager mm = EngineMessage.get();
                            throw new RQException("xlsimport" + mm.getMessage("function.invalidParam"));
                        }
                        fields[i] = sub.getLeafExpression().getIdentifierName();
                    }
                }
            }
            isXlsx = false;
            try {
                isXlsx = ExcelUtils.isXlsxFile(this.file);
            }
            catch (Throwable e1) {
                if (!StringUtils.isValidString(this.file.getFileName())) break block74;
                isXlsx = this.file.getFileName().toLowerCase().endsWith(".xlsx");
            }
        }
        if (isCursor && !isXlsx) {
            MessageManager mm = AppMessage.get();
            throw new RQException("xlsimport" + mm.getMessage("xlsfile.needxlsx"));
        }
        XlsImport.checkFieldOptions(fields, opt);
        InputStream in = null;
        BufferedInputStream bis = null;
        try {
            ILineInput importer;
            if (isCursor) {
                importer = new XlsxSImporter(this.file, fields, start, end, s, opt, pwd);
                String cursorOpt = "";
                if (hasTitle) {
                    cursorOpt = cursorOpt + "t";
                }
                obj = UserUtils.newCursor(importer, cursorOpt);
                return obj;
            }
            in = this.file.getInputStream();
            bis = new BufferedInputStream(in, Env.FILE_BUFSIZE);
            importer = new ExcelTool(in, isXlsx, pwd);
            Object object = ((ExcelTool)importer).fileXlsImport(fields, start, end, s, opt);
            return object;
        }
        catch (Exception e) {
            throw new RQException(e.getMessage(), e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                throw new RQException(e.getMessage(), e);
            }
            try {
                if (bis != null) {
                    bis.close();
                }
            }
            catch (IOException e) {
                throw new RQException(e.getMessage(), e);
            }
        }
    }

    public Node optimize(Context ctx) {
        if (this.param != null) {
            this.param.optimize(ctx);
        }
        return this;
    }

    public static void checkOptions(String opt) {
        String wOrSText;
        boolean removeBlank;
        boolean isCursor = opt != null && opt.indexOf("c") > -1;
        boolean hasTitle = opt != null && opt.indexOf("t") > -1;
        boolean bl = removeBlank = opt != null && opt.indexOf("b") > -1;
        if (isCursor && removeBlank) {
            throw new RQException(AppMessage.get().getMessage("xlsimport.nocb"));
        }
        boolean isW = opt != null && opt.indexOf("w") > -1;
        boolean isS = opt != null && opt.indexOf("s") > -1;
        boolean isP = opt != null && opt.indexOf("p") > -1;
        String string = wOrSText = isW ? "w" : "s";
        if ((isW || isS) && (hasTitle || removeBlank || isCursor)) {
            throw new RQException(AppMessage.get().getMessage("xlsimport.nowtbc", wOrSText));
        }
        if (!isW && isP) {
            throw new RQException(AppMessage.get().getMessage("xlsimport.pnnotw", "p"));
        }
    }

    public static void checkFieldOptions(String[] fields, String opt) {
        String wOrSText;
        boolean isW = opt != null && opt.indexOf("w") > -1;
        boolean isS = opt != null && opt.indexOf("s") > -1;
        String string = wOrSText = isW ? "w" : "s";
        if ((isW || isS) && fields != null) {
            throw new RQException(AppMessage.get().getMessage("xlsimport.nowfields", wOrSText));
        }
    }
}

