/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.mfn.sequence;

import com.scudata.array.ObjectArray;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.BaseRecord;
import com.scudata.dm.Context;
import com.scudata.dm.DataStruct;
import com.scudata.dm.Env;
import com.scudata.dm.Sequence;
import com.scudata.dm.cursor.ICursor;
import com.scudata.dm.cursor.IMultipath;
import com.scudata.dm.cursor.MemoryCursor;
import com.scudata.dm.cursor.MultipathCursors;
import com.scudata.dm.op.Derive;
import com.scudata.dm.op.DiffJoin;
import com.scudata.dm.op.New;
import com.scudata.dm.op.Select;
import com.scudata.dm.op.Switch;
import com.scudata.dw.MemoryTable;
import com.scudata.expression.Expression;
import com.scudata.expression.IParam;
import com.scudata.expression.Node;
import com.scudata.expression.ParamInfo2;
import com.scudata.expression.SequenceFunction;
import com.scudata.expression.operator.And;
import com.scudata.resources.EngineMessage;
import com.scudata.util.CursorUtil;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateCursor
extends SequenceFunction {
    @Override
    public Object calculate(Context ctx) {
        if (this.srcSequence instanceof MemoryTable) {
            return CreateCursor._$1((MemoryTable)this.srcSequence, this.param, this.option, ctx);
        }
        if (this.srcSequence.ifn() instanceof ICursor) {
            int len = this.srcSequence.length();
            ObjectArray array = new ObjectArray(len);
            for (int i = 1; i <= len; ++i) {
                Object obj = this.srcSequence.getMem(i);
                if (obj instanceof IMultipath) {
                    Object[] cursors = ((IMultipath)obj).getParallelCursors();
                    array.addAll(cursors);
                    continue;
                }
                if (obj instanceof ICursor) {
                    array.add(obj);
                    continue;
                }
                if (obj == null) continue;
                MessageManager mm = EngineMessage.get();
                throw new RQException("mcursor" + mm.getMessage("function.paramTypeError"));
            }
            Object[] cursors = new ICursor[array.size()];
            array.toArray(cursors);
            return new MultipathCursors((ICursor[])cursors, ctx);
        }
        if (this.option == null || this.option.indexOf(109) == -1) {
            return CreateCursor._$1(this.srcSequence, this.param, this.option, ctx);
        }
        return CreateCursor._$2(this.srcSequence, this.param, this.option, ctx);
    }

    private static void _$1(IParam param, ArrayList<Expression> expList, ArrayList<String> fieldList, ArrayList<Sequence> codeList, ArrayList<String> optList, Context ctx) {
        if (param != null) {
            if (param.isLeaf()) {
                expList.add(param.getLeafExpression());
            } else if (param.getType() == ':') {
                int subSize = param.getSubSize();
                if (subSize > 3) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("cursor" + mm.getMessage("function.invalidParam"));
                }
                IParam sub0 = param.getSub(0);
                IParam sub1 = param.getSub(1);
                if (sub0 == null || sub1 == null) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("cursor" + mm.getMessage("function.invalidParam"));
                }
                String fkName = sub0.getLeafExpression().getIdentifierName();
                fieldList.add(fkName);
                Object val = sub1.getLeafExpression().calculate(ctx);
                if (val instanceof Sequence) {
                    codeList.add((Sequence)val);
                } else if (val == null) {
                    codeList.add(new Sequence());
                } else {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("join" + mm.getMessage("function.paramTypeError"));
                }
                if (subSize > 2) {
                    IParam sub2 = param.getSub(2);
                    if (sub2 != null) {
                        String opt = sub2.getLeafExpression().toString();
                        optList.add(opt);
                    } else {
                        optList.add(null);
                    }
                } else {
                    optList.add(null);
                }
            }
        }
    }

    private static ICursor _$1(MemoryTable table, IParam param, String opt, Context ctx) {
        MessageManager mm;
        int i;
        boolean isMultiThread;
        boolean bl = isMultiThread = opt != null && opt.indexOf(109) != -1;
        if (param == null && !isMultiThread) {
            return table.cursor();
        }
        IParam fieldParam = null;
        Expression filter = null;
        String[] fkNames = null;
        Sequence[] codes = null;
        String[] opts = null;
        MultipathCursors mcs = null;
        int segSeq = 0;
        int segCount = 0;
        if (isMultiThread) {
            segCount = Env.getCursorParallelNum();
        }
        if (param != null && param.getType() == ';') {
            IParam segParam;
            int size = param.getSubSize();
            if (size > 3) {
                MessageManager mm2 = EngineMessage.get();
                throw new RQException("cursor" + mm2.getMessage("function.invalidParam"));
            }
            fieldParam = param.getSub(0);
            IParam expParam = param.getSub(1);
            if (expParam != null) {
                if (expParam.isLeaf()) {
                    filter = expParam.getLeafExpression();
                } else {
                    int expCount;
                    ArrayList<Expression> expList = new ArrayList<Expression>();
                    ArrayList<String> fieldList = new ArrayList<String>();
                    ArrayList<Sequence> codeList = new ArrayList<Sequence>();
                    ArrayList<String> optList = new ArrayList<String>();
                    if (expParam.getType() == ':') {
                        CreateCursor._$1(expParam, expList, fieldList, codeList, optList, ctx);
                    } else {
                        int psize = expParam.getSubSize();
                        for (int p = 0; p < psize; ++p) {
                            IParam sub = expParam.getSub(p);
                            CreateCursor._$1(sub, expList, fieldList, codeList, optList, ctx);
                        }
                    }
                    int fieldCount = fieldList.size();
                    if (fieldCount > 0) {
                        fkNames = new String[fieldCount];
                        codes = new Sequence[fieldCount];
                        opts = new String[fieldCount];
                        fieldList.toArray(fkNames);
                        codeList.toArray(codes);
                        optList.toArray(opts);
                    }
                    if ((expCount = expList.size()) == 1) {
                        filter = expList.get(0);
                    } else if (expCount > 1) {
                        Expression exp = expList.get(0);
                        Node home = exp.getHome();
                        for (i = 1; i < expCount; ++i) {
                            exp = expList.get(i);
                            And and = new And();
                            and.setLeft(home);
                            and.setRight(exp.getHome());
                            home = and;
                        }
                        filter = new Expression(home);
                    }
                }
            }
            if (size > 2 && (segParam = param.getSub(2)) != null) {
                if (segParam.isLeaf()) {
                    Object obj = segParam.getLeafExpression().calculate(ctx);
                    if (obj instanceof MultipathCursors) {
                        mcs = (MultipathCursors)obj;
                    } else if (obj instanceof ICursor) {
                        isMultiThread = false;
                    } else {
                        MessageManager mm3;
                        if (!isMultiThread) {
                            mm3 = EngineMessage.get();
                            throw new RQException("cursor" + mm3.getMessage("function.invalidParam"));
                        }
                        if (!(obj instanceof Number)) {
                            mm3 = EngineMessage.get();
                            throw new RQException("cursor" + mm3.getMessage("function.paramTypeError"));
                        }
                        segCount = ((Number)obj).intValue();
                    }
                } else {
                    if (segParam.getSubSize() != 2) {
                        MessageManager mm4 = EngineMessage.get();
                        throw new RQException("cursor" + mm4.getMessage("function.invalidParam"));
                    }
                    IParam sub0 = segParam.getSub(0);
                    IParam sub1 = segParam.getSub(1);
                    if (sub0 == null || sub1 == null) {
                        mm = EngineMessage.get();
                        throw new RQException("cursor" + mm.getMessage("function.invalidParam"));
                    }
                    Object obj = sub0.getLeafExpression().calculate(ctx);
                    if (!(obj instanceof Number)) {
                        MessageManager mm5 = EngineMessage.get();
                        throw new RQException("cursor" + mm5.getMessage("function.paramTypeError"));
                    }
                    segSeq = ((Number)obj).intValue();
                    obj = sub1.getLeafExpression().calculate(ctx);
                    if (!(obj instanceof Number)) {
                        MessageManager mm6 = EngineMessage.get();
                        throw new RQException("cursor" + mm6.getMessage("function.paramTypeError"));
                    }
                    segCount = ((Number)obj).intValue();
                    if (segSeq < 1 || segSeq > segCount) {
                        MessageManager mm7 = EngineMessage.get();
                        throw new RQException("cursor" + mm7.getMessage("function.invalidParam"));
                    }
                    isMultiThread = false;
                }
            }
        } else {
            fieldParam = param;
        }
        Expression[] exps = null;
        String[] names = null;
        if (fieldParam != null) {
            ParamInfo2 pi = ParamInfo2.parse(fieldParam, "cursor", false, false);
            exps = pi.getExpressions1();
            names = pi.getExpressionStrs2();
            int colCount = names.length;
            for (int i2 = 0; i2 < colCount; ++i2) {
                if (names[i2] == null || names[i2].length() == 0) {
                    if (exps[i2] == null) {
                        mm = EngineMessage.get();
                        throw new RQException("cursor" + mm.getMessage("function.invalidParam"));
                    }
                    names[i2] = exps[i2].getIdentifierName();
                    continue;
                }
                if (exps[i2] != null) continue;
                exps[i2] = Expression.NULL;
            }
        }
        ICursor cs = mcs != null ? CreateCursor._$1(table, mcs, null, null, opt, ctx) : table.cursor(segSeq, segCount, ctx);
        Switch switchOp = null;
        if (fkNames != null) {
            int switchCount;
            int fkCount = fkNames.length;
            ArrayList<Expression[]> diffExpList = new ArrayList<Expression[]>();
            ArrayList<Sequence> diffCodeList = new ArrayList<Sequence>();
            ArrayList<Object> switchFkList = new ArrayList<Object>();
            ArrayList<Sequence> switchCodeList = new ArrayList<Sequence>();
            ArrayList<Expression> switchExpList = new ArrayList<Expression>();
            for (i = 0; i < fkCount; ++i) {
                Expression exp;
                if (opts[i] == null) {
                    switchFkList.add(fkNames[i]);
                    switchCodeList.add(codes[i]);
                    switchExpList.add(null);
                    continue;
                }
                if (opts[i].equals("null")) {
                    exp = new Expression(ctx, fkNames[i]);
                    diffExpList.add(new Expression[]{exp});
                    diffCodeList.add(codes[i]);
                    continue;
                }
                if (!opts[i].equals("#")) continue;
                switchFkList.add(fkNames[i]);
                switchCodeList.add(codes[i]);
                exp = new Expression("#");
                switchExpList.add(exp);
            }
            int diffCount = diffExpList.size();
            if (diffCount > 0) {
                Expression[][] diffExps = new Expression[diffCount][];
                Sequence[] diffCodes = new Sequence[diffCount];
                diffExpList.toArray((T[])diffExps);
                diffCodeList.toArray(diffCodes);
                DiffJoin diff = new DiffJoin(diffExps, diffCodes, new Expression[diffCount][]);
                cs.addOperation(diff, ctx);
            }
            if ((switchCount = switchFkList.size()) > 0) {
                String[] switchFkNames = new String[switchCount];
                Sequence[] switchCodes = new Sequence[switchCount];
                Expression[] switchExps = new Expression[switchCount];
                switchFkList.toArray(switchFkNames);
                switchCodeList.toArray(switchCodes);
                switchExpList.toArray(switchExps);
                switchOp = new Switch(switchFkNames, switchCodes, switchExps, "i");
            }
        }
        if (filter != null) {
            Select select = new Select(filter, null);
            cs.addOperation(select, ctx);
        }
        if (names != null) {
            New newOp = new New(exps, names, null);
            cs.addOperation(newOp, ctx);
        } else {
            Derive deriveOp = new Derive(null, null, null);
            cs.addOperation(deriveOp, ctx);
        }
        if (switchOp != null) {
            cs.addOperation(switchOp, ctx);
        }
        return cs;
    }

    private static ICursor _$1(Sequence seq, IMultipath mcs, String[] keys1, String[] keys2, String opt, Context ctx) {
        int len = seq.length();
        ICursor[] cursors = mcs.getParallelCursors();
        int pathCount = cursors.length;
        if (opt != null && opt.indexOf(112) != -1) {
            keys2 = new String[]{"#1"};
            keys1 = keys2;
        } else if (keys1 == null) {
            String[] tmp;
            DataStruct ds = seq.dataStruct();
            if (ds == null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(mm.getMessage("ds.lessKey"));
            }
            keys1 = ds.getPrimary();
            if (keys1 == null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(mm.getMessage("ds.lessKey"));
            }
            Sequence data = cursors[0].peek(1);
            if (data == null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(mm.getMessage("ds.lessKey"));
            }
            ds = data.dataStruct();
            if (ds == null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(mm.getMessage("ds.lessKey"));
            }
            keys2 = ds.getPrimary();
            if (keys2 == null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(mm.getMessage("ds.lessKey"));
            }
            int fcount1 = keys1.length;
            int fcount2 = keys2.length;
            if (fcount1 > fcount2) {
                tmp = new String[fcount2];
                System.arraycopy(keys1, 0, tmp, 0, fcount2);
                keys1 = tmp;
            } else if (fcount1 < fcount2) {
                tmp = new String[fcount1];
                System.arraycopy(keys2, 0, tmp, 0, fcount1);
                keys2 = tmp;
            }
        }
        int fcount = keys1.length;
        Object[][] minValues = new Object[pathCount][];
        for (int i = 0; i < pathCount; ++i) {
            Sequence data = cursors[i].peek(1);
            if (data == null) {
                throw new RQException("Less data.");
            }
            BaseRecord r = (BaseRecord)data.get(1);
            Object[] vals = new Object[fcount];
            minValues[i] = vals;
            for (int f = 0; f < fcount; ++f) {
                vals[f] = r.getFieldValue(keys2[f]);
            }
        }
        ICursor[] resultCursors = new ICursor[pathCount];
        Expression[] exps = new Expression[fcount];
        for (int f = 0; f < fcount; ++f) {
            exps[f] = new Expression(ctx, keys1[f]);
        }
        int start = 1;
        for (int i = 1; i < pathCount; ++i) {
            int index = (Integer)seq.pselect(exps, minValues[i], start, "s", ctx);
            if (index < 0) {
                index = -index;
            }
            resultCursors[i - 1] = seq.cursor(start, index);
            start = index;
        }
        resultCursors[pathCount - 1] = seq.cursor(start, len + 1);
        return new MultipathCursors(resultCursors, ctx);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static ICursor _$2(Sequence seq, IParam param, String opt, Context ctx) {
        int pathCount;
        if (param == null) {
            pathCount = Env.getCursorParallelNum();
            return CursorUtil.cursor(seq, pathCount, opt, ctx);
        }
        if (param.isLeaf()) {
            Object obj = param.getLeafExpression().calculate(ctx);
            if (obj instanceof Number) {
                pathCount = ((Number)obj).intValue();
                return CursorUtil.cursor(seq, pathCount, opt, ctx);
            }
            if (obj instanceof IMultipath) {
                return CreateCursor._$1(seq, (IMultipath)obj, null, null, opt, ctx);
            }
            if (obj instanceof ICursor) {
                pathCount = 0;
                return CursorUtil.cursor(seq, pathCount, opt, ctx);
            }
            MessageManager mm = EngineMessage.get();
            throw new RQException("cursor" + mm.getMessage("function.paramTypeError"));
        }
        if (param.getType() != ',') {
            MessageManager mm = EngineMessage.get();
            throw new RQException("cursor" + mm.getMessage("function.invalidParam"));
        }
        int paramCount = param.getSubSize();
        IParam sub = param.getSub(0);
        if (sub == null || !sub.isLeaf()) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("cursor" + mm.getMessage("function.invalidParam"));
        }
        Object obj = sub.getLeafExpression().calculate(ctx);
        if (!(obj instanceof IMultipath)) {
            if (obj instanceof ICursor) {
                return new MemoryCursor(seq);
            }
            MessageManager mm = EngineMessage.get();
            throw new RQException("cursor" + mm.getMessage("function.paramTypeError"));
        }
        String[] keys1 = new String[paramCount - 1];
        String[] keys2 = new String[paramCount - 1];
        int i = 1;
        while (i < paramCount) {
            sub = param.getSub(i);
            if (sub == null || sub.getSubSize() != 2) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("cursor" + mm.getMessage("function.invalidParam"));
            }
            IParam sub0 = sub.getSub(0);
            IParam sub1 = sub.getSub(1);
            if (sub0 == null || sub1 == null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("cursor" + mm.getMessage("function.invalidParam"));
            }
            keys1[i - 1] = sub0.getLeafExpression().getIdentifierName();
            keys2[i - 1] = sub1.getLeafExpression().getIdentifierName();
            ++i;
        }
        return CreateCursor._$1(seq, (IMultipath)obj, keys1, keys2, opt, ctx);
    }

    private static ICursor _$1(Sequence seq, IParam param, String opt, Context ctx) {
        if (param == null) {
            return seq.cursor();
        }
        if (param.getSubSize() != 2) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("cursor" + mm.getMessage("function.invalidParam"));
        }
        IParam sub0 = param.getSub(0);
        IParam sub1 = param.getSub(1);
        if (sub0 == null || sub1 == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("cursor" + mm.getMessage("function.invalidParam"));
        }
        Object val0 = sub0.getLeafExpression().calculate(ctx);
        if (!(val0 instanceof Number)) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("cursor" + mm.getMessage("function.paramTypeError"));
        }
        Object val1 = sub1.getLeafExpression().calculate(ctx);
        if (!(val1 instanceof Number)) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("cursor" + mm.getMessage("function.paramTypeError"));
        }
        int segSeq = ((Number)val0).intValue();
        int segCount = ((Number)val1).intValue();
        if (segSeq < 1 || segSeq > segCount) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("cursor" + mm.getMessage("function.invalidParam"));
        }
        return CursorUtil.cursor(seq, segSeq, segCount, opt, ctx);
    }
}

