/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.mfn.sequence;

import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.BaseRecord;
import com.scudata.dm.Context;
import com.scudata.dm.Sequence;
import com.scudata.dm.Table;
import com.scudata.expression.IParam;
import com.scudata.expression.SequenceFunction;
import com.scudata.resources.EngineMessage;
import com.scudata.util.Variant;

public class FieldValue
extends SequenceFunction {
    public void checkValidity() {
        if (this.param == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("field" + mm.getMessage("function.missingParam"));
        }
    }

    public Object addAssign(Object value, Context ctx) {
        if (this.param.isLeaf()) {
            Object obj = this.param.getLeafExpression().calculate(ctx);
            if (obj instanceof Number) {
                int findex = ((Number)obj).intValue();
                if (findex > 0) {
                    --findex;
                } else if (findex == 0) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("0" + mm.getMessage("ds.fieldNotExist"));
                }
                Sequence src = this.srcSequence;
                int size = src.length();
                Sequence result = new Sequence(size);
                for (int i = 1; i <= size; ++i) {
                    BaseRecord cur = (BaseRecord)src.getMem(i);
                    if (cur == null) {
                        result.add(null);
                        continue;
                    }
                    Object val = Variant.add(cur.getFieldValue(findex), value);
                    cur.set(findex, val);
                    result.add(val);
                }
                return result;
            }
            if (obj instanceof String) {
                String fname = (String)obj;
                Sequence src = this.srcSequence;
                int size = src.length();
                Sequence result = new Sequence(size);
                for (int i = 1; i <= size; ++i) {
                    BaseRecord cur = (BaseRecord)src.getMem(i);
                    if (cur == null) {
                        result.add(null);
                        continue;
                    }
                    Object val = Variant.add(cur.getFieldValue(fname), value);
                    cur.set(fname, val);
                    result.add(val);
                }
                return result;
            }
            MessageManager mm = EngineMessage.get();
            throw new RQException("field" + mm.getMessage("function.paramTypeError"));
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException("field" + mm.getMessage("function.invalidParam"));
    }

    public Object calculate(Context ctx) {
        if (this.param.isLeaf()) {
            Object obj = this.param.getLeafExpression().calculate(ctx);
            if (obj instanceof Number) {
                int findex = ((Number)obj).intValue();
                if (findex > 0) {
                    --findex;
                } else if (findex == 0) {
                    return null;
                }
                if (this.option == null || this.option.indexOf(114) == -1) {
                    return FieldValue._$1(this.srcSequence, findex);
                }
                return this.srcSequence.fieldValues_r(findex);
            }
            if (obj instanceof String) {
                if (this.option == null || this.option.indexOf(114) == -1) {
                    return FieldValue.getFieldValues(this.srcSequence, (String)obj);
                }
                return this.srcSequence.fieldValues_r((String)obj);
            }
            MessageManager mm = EngineMessage.get();
            throw new RQException("field" + mm.getMessage("function.paramTypeError"));
        }
        if (this.param.getSubSize() != 2) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("field" + mm.getMessage("function.invalidParam"));
        }
        IParam sub0 = this.param.getSub(0);
        IParam sub1 = this.param.getSub(1);
        if (sub0 == null || sub1 == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("field" + mm.getMessage("function.invalidParam"));
        }
        Object obj = sub0.getLeafExpression().calculate(ctx);
        Object value = sub1.getLeafExpression().calculate(ctx);
        if (obj instanceof Number) {
            int findex = ((Number)obj).intValue();
            if (findex > 0) {
                --findex;
            } else if (findex == 0) {
                return null;
            }
            if (value instanceof Sequence) {
                FieldValue._$1(this.srcSequence, findex, (Sequence)value);
            } else {
                FieldValue._$1(this.srcSequence, findex, value);
            }
        } else if (obj instanceof String) {
            if (value instanceof Sequence) {
                FieldValue.setFieldValues(this.srcSequence, (String)obj, (Sequence)value);
            } else {
                FieldValue.setFieldValues(this.srcSequence, (String)obj, value);
            }
        } else {
            MessageManager mm = EngineMessage.get();
            throw new RQException("field" + mm.getMessage("function.paramTypeError"));
        }
        return null;
    }

    private static Sequence _$1(Sequence src, int field) {
        if (src instanceof Table) {
            if (src.dataStruct().getFieldCount() > field) {
                return src.fieldValues(field);
            }
            int size = src.length();
            Sequence result = new Sequence(size);
            for (int i = 1; i <= size; ++i) {
                result.add(null);
            }
            return result;
        }
        int size = src.length();
        Sequence result = new Sequence(size);
        for (int i = 1; i <= size; ++i) {
            BaseRecord cur = (BaseRecord)src.getMem(i);
            if (cur == null) {
                result.add(null);
                continue;
            }
            result.add(cur.getFieldValue2(field));
        }
        return result;
    }

    public static Sequence getFieldValues(Sequence src, String fieldName) {
        Object obj;
        if (src instanceof Table) {
            int field = src.dataStruct().getFieldIndex(fieldName);
            if (field != -1) {
                return src.fieldValues(field);
            }
            int size = src.length();
            Sequence result = new Sequence(size);
            for (int i = 1; i <= size; ++i) {
                result.add(null);
            }
            return result;
        }
        int size = src.length();
        Sequence result = new Sequence(size);
        int col = -1;
        BaseRecord prevRecord = null;
        int i = 1;
        while (i <= size) {
            if ((obj = src.getMem(i++)) != null) {
                if (!(obj instanceof BaseRecord)) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException(mm.getMessage("engine.needPmt"));
                }
                prevRecord = (BaseRecord)obj;
                col = prevRecord.getFieldIndex(fieldName);
                if (col >= 0) {
                    result.add(prevRecord.getFieldValue(col));
                    break;
                }
                result.add(null);
                break;
            }
            result.add(null);
        }
        while (i <= size) {
            obj = src.getMem(i);
            if (obj != null) {
                if (!(obj instanceof BaseRecord)) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException(mm.getMessage("engine.needPmt"));
                }
                BaseRecord cur = (BaseRecord)obj;
                if (!prevRecord.isSameDataStruct(cur)) {
                    col = cur.getFieldIndex(fieldName);
                    prevRecord = cur;
                }
                if (col >= 0) {
                    result.add(cur.getFieldValue(col));
                } else {
                    result.add(null);
                }
            } else {
                result.add(null);
            }
            ++i;
        }
        return result;
    }

    public static void setFieldValues(Sequence src, String fieldName, Object val) {
        Object obj;
        int size = src.length();
        int col = -1;
        BaseRecord prevRecord = null;
        int i = 1;
        while (i <= size) {
            if ((obj = src.getMem(i++)) == null) continue;
            if (!(obj instanceof BaseRecord)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(mm.getMessage("engine.needPmt"));
            }
            prevRecord = (BaseRecord)obj;
            col = prevRecord.getFieldIndex(fieldName);
            if (col < 0) break;
            prevRecord.setNormalFieldValue(col, val);
            break;
        }
        while (i <= size) {
            obj = src.getMem(i);
            if (obj != null) {
                if (!(obj instanceof BaseRecord)) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException(mm.getMessage("engine.needPmt"));
                }
                BaseRecord cur = (BaseRecord)obj;
                if (!prevRecord.isSameDataStruct(cur)) {
                    col = cur.getFieldIndex(fieldName);
                    prevRecord = cur;
                }
                if (col >= 0) {
                    cur.setNormalFieldValue(col, val);
                }
            }
            ++i;
        }
    }

    public static void setFieldValues(Sequence src, String fieldName, Sequence values) {
        Object obj;
        int i;
        int len = values.length();
        if (len > src.length()) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("field: " + mm.getMessage("engine.memCountNotMatch"));
        }
        int col = -1;
        BaseRecord prevRecord = null;
        for (i = 1; i <= len; ++i) {
            obj = src.getMem(i);
            if (obj == null) continue;
            if (!(obj instanceof BaseRecord)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(mm.getMessage("engine.needPmt"));
            }
            prevRecord = (BaseRecord)obj;
            col = prevRecord.getFieldIndex(fieldName);
            if (col >= 0) {
                prevRecord.setNormalFieldValue(col, values.getMem(i));
            }
            ++i;
            break;
        }
        while (i <= len) {
            obj = src.getMem(i);
            if (obj != null) {
                if (!(obj instanceof BaseRecord)) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException(mm.getMessage("engine.needPmt"));
                }
                BaseRecord cur = (BaseRecord)obj;
                if (!prevRecord.isSameDataStruct(cur)) {
                    col = cur.getFieldIndex(fieldName);
                    prevRecord = cur;
                }
                if (col >= 0) {
                    cur.setNormalFieldValue(col, values.getMem(i));
                }
            }
            ++i;
        }
    }

    private static void _$1(Sequence src, int field, Object value) {
        int len = src.length();
        for (int i = 1; i <= len; ++i) {
            BaseRecord cur = (BaseRecord)src.getMem(i);
            if (cur == null) continue;
            cur.set2(field, value);
        }
    }

    private static void _$1(Sequence src, int field, Sequence values) {
        int len = values.length();
        if (len > src.length()) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("field: " + mm.getMessage("engine.memCountNotMatch"));
        }
        for (int i = 1; i <= len; ++i) {
            BaseRecord cur = (BaseRecord)src.getMem(i);
            if (cur == null) continue;
            cur.set2(field, values.getMem(i));
        }
    }
}

