/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.mfn.sequence;

import com.scudata.array.ArrayUtil;
import com.scudata.array.BoolArray;
import com.scudata.array.ConstArray;
import com.scudata.array.IArray;
import com.scudata.array.ObjectArray;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.dm.IndexTable;
import com.scudata.dm.Sequence;
import com.scudata.expression.Expression;
import com.scudata.expression.Function;
import com.scudata.expression.IParam;
import com.scudata.expression.SequenceFunction;
import com.scudata.expression.ValueList;
import com.scudata.resources.EngineMessage;
import com.scudata.util.Variant;

public class Find
extends SequenceFunction {
    private Sequence _$2;
    private IndexTable _$1;

    public void checkValidity() {
        if (this.param == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("find" + mm.getMessage("function.missingParam"));
        }
    }

    public Object calculate(Context ctx) {
        Object key;
        if (this.param.isLeaf()) {
            key = this.param.getLeafExpression().calculate(ctx);
        } else {
            int count = this.param.getSubSize();
            Sequence seq = new Sequence(count);
            key = seq;
            for (int i = 0; i < count; ++i) {
                IParam sub = this.param.getSub(i);
                if (sub == null || !sub.isLeaf()) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("find" + mm.getMessage("function.invalidParam"));
                }
                seq.add(sub.getLeafExpression().calculate(ctx));
            }
        }
        if (this.option != null) {
            boolean isMultiRow;
            boolean isSorted = this.option.indexOf(98) != -1;
            boolean bl = isMultiRow = this.option.indexOf(107) != -1;
            if (isMultiRow && key instanceof Sequence) {
                Sequence keys = (Sequence)key;
                int len = keys.length();
                Sequence result = new Sequence(len);
                for (int i = 1; i <= len; ++i) {
                    result.add(this.srcSequence.findByKey(keys.getMem(i), isSorted));
                }
                return result;
            }
            return this.srcSequence.findByKey(key, isSorted);
        }
        return this.srcSequence.findByKey(key, false);
    }

    public IArray calculateAll(Context ctx) {
        Object leftValue;
        IArray leftArray = this.left.calculateAll(ctx);
        if (leftArray instanceof ConstArray && (leftValue = ((ConstArray)leftArray).getData()) instanceof Sequence) {
            int i;
            int[] index;
            Sequence srcSequence = (Sequence)leftValue;
            if (this._$2 != srcSequence) {
                this._$2 = srcSequence;
                this._$1 = srcSequence.newIndexTable();
            }
            if (this.param.isLeaf()) {
                Expression exp = this.param.getLeafExpression();
                if (exp.getHome() instanceof ValueList) {
                    Expression[] list = ((Function)exp.getHome()).getParamExpressions(null, true);
                    int size = list.length;
                    IArray[] arrays = new IArray[size];
                    for (int i2 = 0; i2 < size; ++i2) {
                        arrays[i2] = list[i2].calculateAll(ctx);
                    }
                    index = this._$1.findAllPos(arrays);
                } else {
                    IArray array = exp.calculateAll(ctx);
                    index = this._$1.findAllPos(array);
                }
            } else {
                int size = this.param.getSubSize();
                IArray[] arrays = new IArray[size];
                for (i = 0; i < size; ++i) {
                    IParam sub = this.param.getSub(i);
                    if (sub == null || !sub.isLeaf()) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException("find" + mm.getMessage("function.invalidParam"));
                    }
                    arrays[i] = sub.getLeafExpression().calculateAll(ctx);
                }
                index = this._$1.findAllPos(arrays);
            }
            int len = index.length;
            Object[] rs = new Object[len];
            for (i = 1; i < len; ++i) {
                if (index[i] <= 0) continue;
                rs[i] = srcSequence.getMem(index[i]);
            }
            ObjectArray result = new ObjectArray(rs, len - 1);
            result.setTemporary(true);
            return result;
        }
        return this.calculateAll(leftArray, ctx);
    }

    public IArray calculateAll(Context ctx, IArray signArray, boolean sign) {
        Object leftValue;
        IArray leftArray = this.left.calculateAll(ctx);
        if (leftArray instanceof ConstArray && (leftValue = ((ConstArray)leftArray).getData()) instanceof Sequence) {
            int i;
            int[] index;
            Sequence srcSequence = (Sequence)leftValue;
            if (this._$2 != srcSequence) {
                this._$2 = srcSequence;
                this._$1 = srcSequence.newIndexTable();
            }
            BoolArray boolArray = ArrayUtil.booleanValue(signArray, sign);
            if (this.param.isLeaf()) {
                Expression exp = this.param.getLeafExpression();
                if (exp.getHome() instanceof ValueList) {
                    Expression[] list = ((Function)exp.getHome()).getParamExpressions(null, true);
                    int size = list.length;
                    IArray[] arrays = new IArray[size];
                    for (int i2 = 0; i2 < size; ++i2) {
                        arrays[i2] = list[i2].calculateAll(ctx, boolArray, true);
                    }
                    index = this._$1.findAllPos(arrays, boolArray);
                } else {
                    IArray array = exp.calculateAll(ctx, boolArray, true);
                    index = this._$1.findAllPos(array, boolArray);
                }
            } else {
                int size = this.param.getSubSize();
                IArray[] arrays = new IArray[size];
                for (i = 0; i < size; ++i) {
                    IParam sub = this.param.getSub(i);
                    if (sub == null || !sub.isLeaf()) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException("find" + mm.getMessage("function.invalidParam"));
                    }
                    arrays[i] = sub.getLeafExpression().calculateAll(ctx, boolArray, true);
                }
                index = this._$1.findAllPos(arrays, boolArray);
            }
            int len = index.length;
            Object[] rs = new Object[len];
            for (i = 1; i < len; ++i) {
                if (index[i] <= 0) continue;
                rs[i] = srcSequence.getMem(index[i]);
            }
            ObjectArray result = new ObjectArray(rs, len - 1);
            result.setTemporary(true);
            return result;
        }
        return this.calculateAll(leftArray, ctx, signArray, sign);
    }

    public BoolArray calculateAnd(Context ctx, IArray leftResult) {
        Object leftValue;
        IArray leftArray = this.left.calculateAll(ctx);
        if (leftArray instanceof ConstArray && (leftValue = ((ConstArray)leftArray).getData()) instanceof Sequence) {
            int[] index;
            Sequence srcSequence = (Sequence)leftValue;
            if (this._$2 != srcSequence) {
                this._$2 = srcSequence;
                this._$1 = srcSequence.newIndexTable();
            }
            BoolArray result = leftResult.isTrue();
            if (this.param.isLeaf()) {
                Expression exp = this.param.getLeafExpression();
                if (exp.getHome() instanceof ValueList) {
                    Expression[] list = ((Function)exp.getHome()).getParamExpressions(null, true);
                    int size = list.length;
                    IArray[] arrays = new IArray[size];
                    for (int i = 0; i < size; ++i) {
                        arrays[i] = list[i].calculateAll(ctx, result, true);
                    }
                    index = this._$1.findAllPos(arrays, result);
                } else {
                    IArray array = exp.calculateAll(ctx, result, true);
                    index = this._$1.findAllPos(array, result);
                }
            } else {
                int size = this.param.getSubSize();
                IArray[] arrays = new IArray[size];
                for (int i = 0; i < size; ++i) {
                    IParam sub = this.param.getSub(i);
                    if (sub == null || !sub.isLeaf()) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException("find" + mm.getMessage("function.invalidParam"));
                    }
                    arrays[i] = sub.getLeafExpression().calculateAll(ctx, result, true);
                }
                index = this._$1.findAllPos(arrays, result);
            }
            int len = index.length;
            for (int i = 1; i < len; ++i) {
                if (index[i] >= 1) continue;
                result.set(i, false);
            }
            return result;
        }
        return this.calculateAnd(leftArray, ctx, leftResult);
    }

    public int isValueRangeMatch(Context ctx) {
        Object leftValue;
        if (this.option != null && this.option.indexOf(107) != -1) {
            return 0;
        }
        IArray leftArray = this.left.calculateAll(ctx);
        if (leftArray instanceof ConstArray && (leftValue = ((ConstArray)leftArray).getData()) instanceof Sequence && this.param.isLeaf()) {
            Object maxValue;
            IArray array = this.param.getLeafExpression().calculateRange(ctx);
            if (array == null) {
                return 0;
            }
            Sequence srcSequence = (Sequence)leftValue;
            Object minValue = array.get(1);
            if (Variant.isEquals(minValue, maxValue = array.get(2))) {
                boolean isSorted = this.option != null && this.option.indexOf(98) != -1;
                Object value = srcSequence.findByKey(minValue, isSorted);
                if (Variant.isTrue(value)) {
                    return 1;
                }
                return -1;
            }
            return 0;
        }
        return 0;
    }
}

