/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.mfn.sequence;

import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.dm.cursor.ICursor;
import com.scudata.dm.cursor.IMultipath;
import com.scudata.dm.cursor.MultipathCursors;
import com.scudata.dm.op.Operation;
import com.scudata.expression.Expression;
import com.scudata.expression.IParam;
import com.scudata.expression.SequenceFunction;
import com.scudata.resources.EngineMessage;
import com.scudata.util.CursorUtil;

public class Mergex
extends SequenceFunction {
    public Object calculate(Context ctx) {
        int srcLen;
        int count = srcLen = this.srcSequence.length();
        for (int i = 1; i <= srcLen; ++i) {
            Object obj = this.srcSequence.getMem(i);
            if (obj == null) {
                --count;
                continue;
            }
            if (obj instanceof ICursor) continue;
            MessageManager mm = EngineMessage.get();
            throw new RQException("\".\"" + mm.getMessage("dot.cursorLeft"));
        }
        if (count < 1) {
            return null;
        }
        if (count == 1) {
            return this.srcSequence.ifn();
        }
        ICursor[] cursors = new ICursor[count];
        boolean isMultipath = false;
        int pathCount = 1;
        int q = 0;
        for (int i = 1; i <= srcLen; ++i) {
            Object obj = this.srcSequence.get(i);
            if (obj == null) continue;
            ICursor cursor = (ICursor)obj;
            cursors[q++] = cursor;
            if (!(cursor instanceof IMultipath)) continue;
            if (q == 1) {
                isMultipath = true;
                pathCount = ((IMultipath)((Object)cursor)).getPathCount();
                continue;
            }
            if (pathCount == ((IMultipath)((Object)cursor)).getPathCount()) continue;
            isMultipath = false;
        }
        Expression[] exps = null;
        if (this.param != null) {
            if (this.param.isLeaf()) {
                exps = new Expression[]{this.param.getLeafExpression()};
            } else if (this.param.getType() == ',') {
                int size = this.param.getSubSize();
                exps = new Expression[size];
                for (int i = 0; i < size; ++i) {
                    IParam sub = this.param.getSub(i);
                    if (sub == null || !sub.isLeaf()) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException("mergex" + mm.getMessage("function.invalidParam"));
                    }
                    exps[i] = sub.getLeafExpression();
                }
            } else {
                MessageManager mm = EngineMessage.get();
                throw new RQException("mergex" + mm.getMessage("function.invalidParam"));
            }
        }
        if (isMultipath && pathCount > 1) {
            int i;
            ICursor[] result = new ICursor[pathCount];
            ICursor[][] multiCursors = new ICursor[count][];
            for (i = 0; i < count; ++i) {
                IMultipath multipath = (IMultipath)((Object)cursors[i]);
                multiCursors[i] = multipath.getParallelCursors();
            }
            for (i = 0; i < pathCount; ++i) {
                ICursor[] curs = new ICursor[count];
                for (int c = 0; c < count; ++c) {
                    curs[c] = multiCursors[c][i];
                }
                Context tmpCtx = ctx.newComputeContext();
                Expression[] tmpExps = Operation.dupExpressions(exps, tmpCtx);
                result[i] = CursorUtil.merge(curs, tmpExps, this.option, tmpCtx);
            }
            return new MultipathCursors(result, ctx);
        }
        return CursorUtil.merge(cursors, exps, this.option, ctx);
    }
}

