/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.mfn.sequence;

import com.scudata.array.IArray;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.BaseRecord;
import com.scudata.dm.Context;
import com.scudata.dm.Sequence;
import com.scudata.expression.IParam;
import com.scudata.expression.SequenceFunction;
import com.scudata.resources.EngineMessage;

public class Nodes
extends SequenceFunction {
    public static void getAllSubs(Sequence srcSequence, String[] fields, Sequence result) {
        int len = srcSequence.length();
        for (int i = 1; i <= len; ++i) {
            Object obj = srcSequence.getMem(i);
            if (obj instanceof BaseRecord) {
                Nodes.getAllSubs((BaseRecord)obj, fields, result);
                continue;
            }
            if (!(obj instanceof Sequence)) continue;
            Nodes.getAllSubs((Sequence)obj, fields, result);
        }
    }

    public static void getAllSubs(BaseRecord srcRecord, String[] fields, Sequence result) {
        boolean sign = true;
        if (fields == null) {
            int fcount = srcRecord.getFieldCount();
            for (int f = 0; f < fcount; ++f) {
                Object obj = srcRecord.getNormalFieldValue(f);
                if (obj instanceof BaseRecord) {
                    Nodes.getAllSubs((BaseRecord)obj, null, result);
                    sign = false;
                    continue;
                }
                if (!(obj instanceof Sequence)) continue;
                Nodes.getAllSubs((Sequence)obj, null, result);
                sign = false;
            }
        } else {
            for (String field : fields) {
                int f = srcRecord.getFieldIndex(field);
                if (f == -1) continue;
                Object obj = srcRecord.getNormalFieldValue(f);
                if (obj instanceof BaseRecord) {
                    Nodes.getAllSubs((BaseRecord)obj, null, result);
                    sign = false;
                    continue;
                }
                if (!(obj instanceof Sequence)) continue;
                Nodes.getAllSubs((Sequence)obj, null, result);
                sign = false;
            }
        }
        if (sign) {
            result.add(srcRecord);
        }
    }

    public Object calculate(Context ctx) {
        String field;
        boolean isLeaf = false;
        boolean isPath = false;
        if (this.option != null) {
            if (this.option.indexOf(114) != -1) {
                Sequence result = new Sequence();
                if (this.param == null) {
                    Nodes.getAllSubs(this.srcSequence, null, result);
                } else {
                    String[] fields = this.param.toStringArray("nodes", false);
                    Nodes.getAllSubs(this.srcSequence, fields, result);
                }
                return result;
            }
            if (this.option.indexOf(100) != -1) {
                isLeaf = true;
            }
            if (this.option.indexOf(112) != -1) {
                isPath = true;
            }
        }
        BaseRecord parent = null;
        int maxLevel = 1000;
        if (this.param == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("nodes" + mm.getMessage("function.missingParam"));
        }
        if (this.param.isLeaf()) {
            field = this.param.getLeafExpression().getIdentifierName();
        } else {
            Object obj;
            int size = this.param.getSubSize();
            if (size > 3) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("nodes" + mm.getMessage("function.invalidParam"));
            }
            IParam sub = this.param.getSub(0);
            if (sub == null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("nodes" + mm.getMessage("function.invalidParam"));
            }
            field = sub.getLeafExpression().getIdentifierName();
            sub = this.param.getSub(1);
            if (sub != null) {
                obj = sub.getLeafExpression().calculate(ctx);
                if (obj instanceof BaseRecord) {
                    parent = (BaseRecord)obj;
                } else if (obj != null) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("nodes" + mm.getMessage("function.paramTypeError"));
                }
            }
            if (size > 2 && (sub = this.param.getSub(2)) != null) {
                obj = sub.getLeafExpression().calculate(ctx);
                if (obj instanceof Number) {
                    maxLevel = ((Number)obj).intValue();
                } else if (obj != null) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("nodes" + mm.getMessage("function.paramTypeError"));
                }
            }
        }
        IArray mems = this.srcSequence.getMems();
        int len = mems.size();
        Sequence result = new Sequence(len);
        if (isLeaf) {
            IArray p = this.srcSequence.fieldValues(field).getMems();
            for (int i = 1; i <= len; ++i) {
                BaseRecord r = (BaseRecord)mems.get(i);
                Sequence seq = r.prior(field, parent, maxLevel);
                if (seq == null || seq.length() <= 0 || seq.length() != maxLevel && p.objectContains(seq.get(1))) continue;
                if (isPath) {
                    result.add(seq.rvs());
                    continue;
                }
                result.add(seq.get(1));
            }
        } else {
            for (int i = 1; i <= len; ++i) {
                Object obj = mems.get(i);
                if (obj instanceof BaseRecord) {
                    BaseRecord r = (BaseRecord)obj;
                    Sequence seq = r.prior(field, parent, maxLevel);
                    if (seq == null || seq.length() <= 0) continue;
                    if (isPath) {
                        result.add(seq.rvs());
                        continue;
                    }
                    result.add(seq.get(1));
                    continue;
                }
                MessageManager mm = EngineMessage.get();
                throw new RQException("\".\"" + mm.getMessage("dot.tableLeft"));
            }
        }
        return result;
    }
}

