/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.mfn.sequence;

import com.scudata.array.ArrayUtil;
import com.scudata.array.BoolArray;
import com.scudata.array.ConstArray;
import com.scudata.array.IArray;
import com.scudata.array.IntArray;
import com.scudata.common.MessageManager;
import com.scudata.common.ObjectCache;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.dm.IndexTable;
import com.scudata.dm.Sequence;
import com.scudata.expression.IParam;
import com.scudata.expression.SequenceFunction;
import com.scudata.resources.EngineMessage;
import com.scudata.util.Variant;

public class PFind
extends SequenceFunction {
    private Sequence _$2;
    private IndexTable _$1;

    public void checkValidity() {
        if (this.param == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("pfind" + mm.getMessage("function.missingParam"));
        }
    }

    public Object calculate(Context ctx) {
        Object key;
        boolean isSorted = false;
        boolean isInsertPos = false;
        boolean isZero = false;
        if (this.option != null) {
            if (this.option.indexOf(98) != -1) {
                isSorted = true;
            }
            if (this.option.indexOf(115) != -1) {
                isSorted = true;
                isInsertPos = true;
            }
            if (this.option.indexOf(48) != -1) {
                isZero = true;
            }
        }
        if (this.param.isLeaf()) {
            key = this.param.getLeafExpression().calculate(ctx);
        } else {
            int count = this.param.getSubSize();
            Sequence seq = new Sequence(count);
            key = seq;
            for (int i = 0; i < count; ++i) {
                IParam sub = this.param.getSub(i);
                if (sub == null || !sub.isLeaf()) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("pfind" + mm.getMessage("function.invalidParam"));
                }
                seq.add(sub.getLeafExpression().calculate(ctx));
            }
        }
        int index = this.srcSequence.pfindByKey(key, isSorted);
        if (index <= 0 && !isInsertPos) {
            return isZero ? ObjectCache.getInteger(0) : null;
        }
        return ObjectCache.getInteger(index);
    }

    public IArray calculateAll(Context ctx) {
        Object leftValue;
        IArray leftArray = this.left.calculateAll(ctx);
        if (leftArray instanceof ConstArray && (leftValue = ((ConstArray)leftArray).getData()) instanceof Sequence && this.param.isLeaf()) {
            int[] index;
            boolean isSorted = false;
            boolean isZero = false;
            if (this.option != null) {
                if (this.option.indexOf(98) != -1) {
                    isSorted = true;
                }
                if (this.option.indexOf(48) != -1) {
                    isZero = true;
                }
            }
            Sequence srcSequence = (Sequence)leftValue;
            IArray array = this.param.getLeafExpression().calculateAll(ctx);
            if (isSorted) {
                int i;
                int len = array.size();
                index = new int[len + 1];
                for (i = 1; i <= len; ++i) {
                    index[i] = srcSequence.pfindByKey(array.get(i), true);
                }
                if (isZero) {
                    for (i = 1; i <= len; ++i) {
                        if (index[i] >= 0) continue;
                        index[i] = 0;
                    }
                }
            } else {
                if (this._$2 != srcSequence) {
                    this._$2 = srcSequence;
                    this._$1 = srcSequence.newIndexTable();
                }
                index = this._$1.findAllPos(array);
            }
            boolean[] signs = null;
            if (!isZero) {
                int len = index.length;
                signs = new boolean[len];
                for (int i = 1; i < len; ++i) {
                    signs[i] = index[i] < 1;
                }
            }
            IntArray result = new IntArray(index, signs, array.size());
            result.setTemporary(true);
            return result;
        }
        return this.calculateAll(leftArray, ctx);
    }

    public IArray calculateAll(Context ctx, IArray signArray, boolean sign) {
        Object leftValue;
        IArray leftArray = this.left.calculateAll(ctx);
        if (leftArray instanceof ConstArray && (leftValue = ((ConstArray)leftArray).getData()) instanceof Sequence && this.param.isLeaf()) {
            int[] index;
            boolean isSorted = false;
            boolean isZero = false;
            if (this.option != null) {
                if (this.option.indexOf(98) != -1) {
                    isSorted = true;
                }
                if (this.option.indexOf(48) != -1) {
                    isZero = true;
                }
            }
            Sequence srcSequence = (Sequence)leftValue;
            BoolArray boolArray = ArrayUtil.booleanValue(signArray, sign);
            IArray array = this.param.getLeafExpression().calculateAll(ctx, boolArray, true);
            if (isSorted) {
                int i;
                int len = array.size();
                index = new int[len + 1];
                for (i = 1; i <= len; ++i) {
                    if (!boolArray.isTrue(i)) continue;
                    index[i] = srcSequence.pfindByKey(array.get(i), true);
                }
                if (isZero) {
                    for (i = 1; i <= len; ++i) {
                        if (index[i] >= 0) continue;
                        index[i] = 0;
                    }
                }
            } else {
                if (this._$2 != srcSequence) {
                    this._$2 = srcSequence;
                    this._$1 = srcSequence.newIndexTable();
                }
                index = this._$1.findAllPos(array, boolArray);
            }
            boolean[] signs = null;
            if (!isZero) {
                int len = index.length;
                signs = new boolean[len];
                for (int i = 1; i < len; ++i) {
                    signs[i] = index[i] < 1;
                }
            }
            IntArray result = new IntArray(index, signs, array.size());
            result.setTemporary(true);
            return result;
        }
        return this.calculateAll(leftArray, ctx, signArray, sign);
    }

    public BoolArray calculateAnd(Context ctx, IArray leftResult) {
        Object leftValue;
        IArray leftArray = this.left.calculateAll(ctx);
        if (leftArray instanceof ConstArray && (leftValue = ((ConstArray)leftArray).getData()) instanceof Sequence && this.param.isLeaf()) {
            Sequence srcSequence = (Sequence)leftValue;
            BoolArray result = leftResult.isTrue();
            IArray array = this.param.getLeafExpression().calculateAll(ctx, result, true);
            if (this.option != null && this.option.indexOf(98) != -1) {
                int len = array.size();
                for (int i = 1; i <= len; ++i) {
                    if (!result.isTrue(i) || srcSequence.pfindByKey(array.get(i), true) >= 1) continue;
                    result.set(i, false);
                }
            } else {
                if (this._$2 != srcSequence) {
                    this._$2 = srcSequence;
                    this._$1 = srcSequence.newIndexTable();
                }
                int[] index = this._$1.findAllPos(array, result);
                int len = index.length;
                for (int i = 1; i < len; ++i) {
                    if (index[i] >= 1) continue;
                    result.set(i, false);
                }
            }
            return result;
        }
        return this.calculateAnd(leftArray, ctx, leftResult);
    }

    public int isValueRangeMatch(Context ctx) {
        Object leftValue;
        if (this.option != null && this.option.indexOf(107) != -1) {
            return 0;
        }
        IArray leftArray = this.left.calculateAll(ctx);
        if (leftArray instanceof ConstArray && (leftValue = ((ConstArray)leftArray).getData()) instanceof Sequence && this.param.isLeaf()) {
            Object maxValue;
            IArray array = this.param.getLeafExpression().calculateRange(ctx);
            if (array == null) {
                return 0;
            }
            Sequence srcSequence = (Sequence)leftValue;
            Object minValue = array.get(1);
            if (Variant.isEquals(minValue, maxValue = array.get(2))) {
                boolean isSorted = this.option != null && this.option.indexOf(98) != -1;
                Object value = srcSequence.findByKey(minValue, isSorted);
                if (Variant.isTrue(value)) {
                    return 1;
                }
                return -1;
            }
            return 0;
        }
        return 0;
    }
}

