/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.mfn.sequence;

import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.dm.Sequence;
import com.scudata.expression.Expression;
import com.scudata.expression.IParam;
import com.scudata.expression.SequenceFunction;
import com.scudata.resources.EngineMessage;

public class PJoin
extends SequenceFunction {
    public void checkValidity() {
        if (this.param == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("pjoin" + mm.getMessage("function.missingParam"));
        }
        if (this.param.getType() != ';') {
            MessageManager mm = EngineMessage.get();
            throw new RQException("pjoin" + mm.getMessage("function.invalidParam"));
        }
    }

    public Object calculate(Context ctx) {
        Expression[] srcKeyExps;
        int keyCount;
        MessageManager mm;
        IParam keyParam;
        IParam sub = this.param.getSub(0);
        Expression[] srcNewExps = null;
        String[] srcNewNames = null;
        if (sub.getType() == ',') {
            keyParam = sub.getSub(0);
            if (keyParam == null) {
                MessageManager mm2 = EngineMessage.get();
                throw new RQException("pjoin" + mm2.getMessage("function.invalidParam"));
            }
            int newSize = sub.getSubSize() - 1;
            srcNewExps = new Expression[newSize];
            srcNewNames = new String[newSize];
            for (int i = 0; i < newSize; ++i) {
                IParam newParam = sub.getSub(i + 1);
                if (newParam == null) {
                    mm = EngineMessage.get();
                    throw new RQException("pjoin" + mm.getMessage("function.invalidParam"));
                }
                if (newParam.isLeaf()) {
                    srcNewExps[i] = newParam.getLeafExpression();
                    srcNewNames[i] = srcNewExps[i].getFieldName();
                    continue;
                }
                if (newParam.getSubSize() == 2) {
                    IParam sub0 = newParam.getSub(0);
                    IParam sub1 = newParam.getSub(1);
                    if (sub0 == null || sub1 == null) {
                        MessageManager mm3 = EngineMessage.get();
                        throw new RQException("pjoin" + mm3.getMessage("function.invalidParam"));
                    }
                    srcNewExps[i] = sub0.getLeafExpression();
                    srcNewNames[i] = sub1.getLeafExpression().getIdentifierName();
                    continue;
                }
                mm = EngineMessage.get();
                throw new RQException("pjoin" + mm.getMessage("function.invalidParam"));
            }
        } else {
            keyParam = sub;
        }
        if (keyParam.isLeaf()) {
            keyCount = 1;
            srcKeyExps = new Expression[]{keyParam.getLeafExpression()};
        } else {
            keyCount = keyParam.getSubSize();
            srcKeyExps = new Expression[keyCount];
            for (int i = 0; i < keyCount; ++i) {
                sub = keyParam.getSub(i);
                if (sub == null) {
                    mm = EngineMessage.get();
                    throw new RQException("pjoin" + mm.getMessage("function.invalidParam"));
                }
                srcKeyExps[i] = sub.getLeafExpression();
            }
        }
        int tableCount = this.param.getSubSize() - 1;
        Sequence[] sequences = new Sequence[tableCount];
        String[] options = new String[tableCount];
        Expression[][] keyExps = new Expression[tableCount][];
        Expression[][] newExps = new Expression[tableCount][];
        String[][] newNames = new String[tableCount][];
        for (int t = 0; t < tableCount; ++t) {
            Object table;
            IParam tableParam = this.param.getSub(t + 1);
            if (tableParam == null || tableParam.getType() != ',') {
                MessageManager mm4 = EngineMessage.get();
                throw new RQException("pjoin" + mm4.getMessage("function.invalidParam"));
            }
            sub = tableParam.getSub(0);
            if (sub == null) {
                MessageManager mm5 = EngineMessage.get();
                throw new RQException("pjoin" + mm5.getMessage("function.invalidParam"));
            }
            if (sub.isLeaf()) {
                table = sub.getLeafExpression().calculate(ctx);
            } else if (sub.getSubSize() == 2) {
                IParam sub0 = sub.getSub(0);
                IParam sub1 = sub.getSub(1);
                if (sub0 == null || sub1 == null) {
                    MessageManager mm6 = EngineMessage.get();
                    throw new RQException("pjoin" + mm6.getMessage("function.invalidParam"));
                }
                table = sub0.getLeafExpression().calculate(ctx);
                options[t] = sub1.getLeafExpression().toString();
            } else {
                MessageManager mm7 = EngineMessage.get();
                throw new RQException("pjoin" + mm7.getMessage("function.invalidParam"));
            }
            if (table instanceof Sequence) {
                sequences[t] = (Sequence)table;
            } else if (table != null) {
                MessageManager mm8 = EngineMessage.get();
                throw new RQException("pjoin" + mm8.getMessage("function.paramTypeError"));
            }
            keyParam = tableParam.getSub(1);
            if (keyParam == null) {
                MessageManager mm9 = EngineMessage.get();
                throw new RQException("pjoin" + mm9.getMessage("function.invalidParam"));
            }
            if (keyParam.isLeaf()) {
                if (keyCount != 1) {
                    MessageManager mm10 = EngineMessage.get();
                    throw new RQException("pjoin" + mm10.getMessage("function.paramCountNotMatch"));
                }
                keyExps[t] = new Expression[]{keyParam.getLeafExpression()};
            } else {
                if (keyCount != keyParam.getSubSize()) {
                    MessageManager mm11 = EngineMessage.get();
                    throw new RQException("pjoin" + mm11.getMessage("function.paramCountNotMatch"));
                }
                keyExps[t] = new Expression[keyCount];
                for (int i = 0; i < keyCount; ++i) {
                    sub = keyParam.getSub(i);
                    if (sub == null) {
                        MessageManager mm12 = EngineMessage.get();
                        throw new RQException("pjoin" + mm12.getMessage("function.invalidParam"));
                    }
                    keyExps[t][i] = sub.getLeafExpression();
                }
            }
            int newSize = tableParam.getSubSize() - 2;
            if (newSize <= 0) continue;
            newExps[t] = new Expression[newSize];
            newNames[t] = new String[newSize];
            for (int i = 0; i < newSize; ++i) {
                MessageManager mm13;
                IParam newParam = tableParam.getSub(i + 2);
                if (newParam == null) {
                    mm13 = EngineMessage.get();
                    throw new RQException("pjoin" + mm13.getMessage("function.invalidParam"));
                }
                if (newParam.isLeaf()) {
                    newExps[t][i] = newParam.getLeafExpression();
                    newNames[t][i] = newExps[t][i].getFieldName();
                    continue;
                }
                if (newParam.getSubSize() == 2) {
                    IParam sub0 = newParam.getSub(0);
                    IParam sub1 = newParam.getSub(1);
                    if (sub0 == null || sub1 == null) {
                        MessageManager mm14 = EngineMessage.get();
                        throw new RQException("pjoin" + mm14.getMessage("function.invalidParam"));
                    }
                    newExps[t][i] = sub0.getLeafExpression();
                    newNames[t][i] = sub1.getLeafExpression().getIdentifierName();
                    continue;
                }
                mm13 = EngineMessage.get();
                throw new RQException("pjoin" + mm13.getMessage("function.invalidParam"));
            }
        }
        return this.srcSequence.pjoin(srcKeyExps, srcNewExps, srcNewNames, sequences, options, keyExps, newExps, newNames, this.option, ctx);
    }
}

