/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.mfn.sequence;

import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.dm.Sequence;
import com.scudata.dm.Table;
import com.scudata.expression.Expression;
import com.scudata.expression.IParam;
import com.scudata.expression.SequenceFunction;
import com.scudata.resources.EngineMessage;

public class RecordValue
extends SequenceFunction {
    public Object calculate(Context ctx) {
        if (this.srcSequence instanceof Table) {
            return this._$1((Table)this.srcSequence, ctx);
        }
        if (this.param == null) {
            return this.srcSequence.toTable();
        }
        if (this.param.isLeaf()) {
            Object obj = this.param.getLeafExpression().calculate(ctx);
            if (!(obj instanceof Number)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("record" + mm.getMessage("function.paramTypeError"));
            }
            int fcount = ((Number)obj).intValue();
            return RecordValue._$1(this.srcSequence, fcount);
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException("record" + mm.getMessage("function.invalidParam"));
    }

    private static Table _$1(Sequence seq, int fcount) {
        int len = seq.length();
        if (len == 0) {
            return null;
        }
        if (fcount < 1 || fcount > len) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("record" + mm.getMessage("function.invalidParam"));
        }
        String[] fnames = new String[fcount];
        for (int i = 1; i <= fcount; ++i) {
            Object obj = seq.getMem(i);
            if (obj instanceof String) {
                fnames[i - 1] = (String)obj;
                continue;
            }
            if (obj == null) continue;
            fnames[i - 1] = obj.toString();
        }
        Table table = new Table(fnames, len / fcount);
        Sequence tmp = seq.get(fcount + 1, len + 1);
        table.record(1, tmp, null);
        return table;
    }

    private Sequence _$1(Table srcTable, Context ctx) {
        Expression srcExp;
        if (this.param == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("record" + mm.getMessage("function.missingParam"));
        }
        int pos = 0;
        if (this.param.isLeaf()) {
            srcExp = this.param.getLeafExpression();
        } else {
            if (this.param.getSubSize() != 2) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("record" + mm.getMessage("function.invalidParam"));
            }
            IParam sub1 = this.param.getSub(0);
            IParam sub2 = this.param.getSub(1);
            if (sub1 == null || sub2 == null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("record" + mm.getMessage("function.invalidParam"));
            }
            srcExp = sub1.getLeafExpression();
            Object posObj = sub2.getLeafExpression().calculate(ctx);
            if (!(posObj instanceof Number)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("record" + mm.getMessage("function.paramTypeError"));
            }
            pos = ((Number)posObj).intValue();
        }
        Object src = srcExp.calculate(ctx);
        if (src instanceof Sequence) {
            return srcTable.record(pos, (Sequence)src, this.option);
        }
        if (src == null) {
            return srcTable;
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException("record" + mm.getMessage("function.paramTypeError"));
    }
}

