/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.mfn.string;

import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.dm.Sequence;
import com.scudata.expression.StringFunction;
import com.scudata.resources.EngineMessage;
import com.scudata.util.Variant;

public class Split
extends StringFunction {
    public Object calculate(Context ctx) {
        String sep = "";
        if (this.param != null) {
            Object obj = this.param.getLeafExpression().calculate(ctx);
            if (obj instanceof String) {
                sep = (String)obj;
            } else {
                if (obj instanceof Sequence) {
                    int[] lens = ((Sequence)obj).toIntArray();
                    return Split.split(this.srcStr, lens, this.option);
                }
                MessageManager mm = EngineMessage.get();
                throw new RQException("split" + mm.getMessage("function.paramTypeError"));
            }
        }
        return Sequence.toSequence(this.srcStr, sep, this.option);
    }

    public static Sequence split(String srcStr, int[] lens, String opt) {
        boolean bData = false;
        boolean bTrim = false;
        if (opt != null) {
            if (opt.indexOf(112) != -1) {
                bData = true;
            }
            if (opt.indexOf(116) != -1) {
                bTrim = true;
            }
        }
        int count = lens.length;
        int index = 0;
        Sequence result = new Sequence(count);
        int strLen = srcStr.length();
        for (int i = 0; i < count; ++i) {
            if (lens[i] > 0) {
                if (index >= strLen) {
                    result.add("");
                    continue;
                }
                int end = index + lens[i];
                if (end >= strLen) {
                    end = strLen;
                }
                String sub = srcStr.substring(index, end);
                index = end;
                if (bTrim) {
                    sub = sub.trim();
                }
                if (bData) {
                    result.add(Variant.parse(sub));
                    continue;
                }
                result.add(sub);
                continue;
            }
            index -= lens[i];
        }
        return result;
    }
}

