/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.mfn.vdb;

import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.expression.VSFunction;
import com.scudata.resources.EngineMessage;
import com.scudata.vdb.Library;
import java.io.File;
import java.io.IOException;

public class Purge
extends VSFunction {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object calculate(Context ctx) {
        if (this.param != null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("purge" + mm.getMessage("function.invalidParam"));
        }
        Library library = this.vs.getVDB().getLibrary();
        File file = new File(library.getPathName());
        try {
            File tmpFile = File.createTempFile("tmpdata", "", file.getParentFile());
            boolean result = library.reset(tmpFile.getAbsolutePath());
            library.stop();
            if (!result) {
                tmpFile.delete();
                return result;
            }
            if (file.delete()) {
                tmpFile.renameTo(file);
                return result;
            }
            tmpFile.delete();
            MessageManager mm = EngineMessage.get();
            throw new RQException("purge" + mm.getMessage("file.deleteFailed"));
        }
        catch (IOException e) {
            throw new RQException(e.getMessage(), e);
        }
    }
}

