/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.mfn.xo;

import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.dm.Sequence;
import com.scudata.dm.cursor.ICursor;
import com.scudata.dm.cursor.MemoryCursor;
import com.scudata.dm.cursor.SubCursor;
import com.scudata.excel.ExcelUtils;
import com.scudata.excel.SheetObject;
import com.scudata.excel.SheetXls;
import com.scudata.expression.Expression;
import com.scudata.expression.IParam;
import com.scudata.expression.Node;
import com.scudata.expression.XOFunction;
import com.scudata.resources.AppMessage;
import com.scudata.resources.EngineMessage;

public class XlsExport
extends XOFunction {
    public Object calculate(Context ctx) {
        int maxRowCount;
        int startRow;
        boolean isP;
        Object src;
        IParam param0;
        if (this.param == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("xlsexport" + mm.getMessage("function.missingParam"));
        }
        IParam param1 = null;
        if (this.param.getType() == ';') {
            if (this.param.getSubSize() != 2) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("xlsexport" + mm.getMessage("function.invalidParam"));
            }
            param0 = this.param.getSub(0);
            param1 = this.param.getSub(1);
            if (param0 == null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("xlsexport" + mm.getMessage("function.invalidParam"));
            }
        } else {
            param0 = this.param;
        }
        Expression[] exps = null;
        String[] names = null;
        Object s = null;
        if (param0.isLeaf()) {
            src = param0.getLeafExpression().calculate(ctx);
        } else {
            IParam sub = param0.getSub(0);
            if (sub == null || !sub.isLeaf()) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("xlsexport" + mm.getMessage("function.invalidParam"));
            }
            src = sub.getLeafExpression().calculate(ctx);
            int size = param0.getSubSize();
            exps = new Expression[size - 1];
            names = new String[size - 1];
            for (int i = 1; i < size; ++i) {
                MessageManager mm;
                sub = param0.getSub(i);
                if (sub == null) {
                    mm = EngineMessage.get();
                    throw new RQException("xlsexport" + mm.getMessage("function.invalidParam"));
                }
                if (sub.isLeaf()) {
                    exps[i - 1] = sub.getLeafExpression();
                    continue;
                }
                if (sub.getSubSize() != 2) {
                    mm = EngineMessage.get();
                    throw new RQException("xlsexport" + mm.getMessage("function.invalidParam"));
                }
                IParam p1 = sub.getSub(0);
                if (p1 == null) {
                    MessageManager mm2 = EngineMessage.get();
                    throw new RQException("xlsexport" + mm2.getMessage("function.invalidParam"));
                }
                exps[i - 1] = p1.getLeafExpression();
                IParam p2 = sub.getSub(1);
                if (p2 == null) continue;
                names[i - 1] = p2.getLeafExpression().getIdentifierName();
            }
        }
        if (param1 != null) {
            s = param1.getLeafExpression().calculate(ctx);
        }
        String opt = this.option;
        boolean isTitle = false;
        boolean isAppend = false;
        if (opt != null) {
            if (opt.indexOf(116) != -1) {
                isTitle = true;
            }
            if (opt.indexOf(97) != -1) {
                isAppend = true;
            }
        }
        boolean isW = opt != null && opt.indexOf("w") > -1;
        boolean bl = isP = opt != null && opt.indexOf("p") > -1;
        if (isW) {
            if (isTitle) {
                throw new RQException(AppMessage.get().getMessage("xlsexport.nowt", "t"));
            }
            if (this.file.supportCursor()) {
                throw new RQException(AppMessage.get().getMessage("xlsexport.nowt", "w"));
            }
            if (exps != null) {
                throw new RQException(AppMessage.get().getMessage("xlsexport.nowfields"));
            }
        }
        if (!isW && isP) {
            throw new RQException(AppMessage.get().getMessage("xlsimport.pnnotw", "p"));
        }
        ExcelUtils.checkSheetName(s);
        SheetObject so = null;
        try {
            if (this.file.getFileType() == 1) {
                throw new RQException("xlsexport : xlsopen@r does not support xlsexport");
            }
            if (s == null) {
                s = new Integer(1);
            }
            so = this.file.getSheetObject(s, true, !isAppend);
            SheetXls sx = (SheetXls)so;
            startRow = sx.getStartRow(isTitle);
            maxRowCount = sx.getMaxRowCount();
        }
        catch (Exception e) {
            throw new RQException(e.getMessage(), e);
        }
        int maxCount = maxRowCount - startRow;
        if (isTitle) {
            --maxCount;
        }
        if (maxCount <= 0) {
            return null;
        }
        Sequence seq = null;
        ICursor cursor = null;
        boolean isStr = false;
        if (isW && src != null && src instanceof String) {
            src = com.scudata.expression.mfn.file.XlsExport.parseSequence((String)src);
            isStr = true;
        }
        if (src == null) {
            return null;
        }
        if (src instanceof Sequence) {
            seq = (Sequence)src;
            if (!isStr && isP) {
                seq = ExcelUtils.transpose(seq);
                src = seq;
            }
        }
        if (src instanceof Sequence) {
            seq = (Sequence)src;
            if (seq.length() > maxCount) {
                cursor = new MemoryCursor(seq, 1, maxCount + 1);
                seq = null;
            }
        } else if (src instanceof ICursor) {
            cursor = (ICursor)src;
            cursor = new SubCursor(cursor, maxCount);
        } else {
            MessageManager mm = EngineMessage.get();
            throw new RQException("xlsexport" + mm.getMessage("function.paramTypeError"));
        }
        try {
            if (seq != null) {
                this.file.xlsexport(so, seq, exps, names, s, startRow, opt, ctx);
            } else {
                this.file.xlsexport(so, cursor, exps, names, s, startRow, opt, ctx);
            }
        }
        catch (Exception e) {
            throw new RQException(e.getMessage(), e);
        }
        return null;
    }

    public Node optimize(Context ctx) {
        if (this.param != null) {
            this.param.optimize(ctx);
        }
        return this;
    }
}

