/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.operator;

import com.scudata.array.IArray;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.dm.Sequence;
import com.scudata.expression.Operator;
import com.scudata.resources.EngineMessage;
import com.scudata.util.Variant;

public class Diff
extends Operator {
    public Diff() {
        this.priority = 14;
    }

    public void checkValidity() {
        if (this.left == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("\"\\\"" + mm.getMessage("operator.missingLeftOperation"));
        }
        if (this.right == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("\"\\\"" + mm.getMessage("operator.missingRightOperation"));
        }
        this.left.checkValidity();
        this.right.checkValidity();
    }

    public Object calculate(Context ctx) {
        Object o1 = this.left.calculate(ctx);
        Object o2 = this.right.calculate(ctx);
        if (o1 == null) {
            if (o2 == null || o2 instanceof Sequence || o2 instanceof Number) {
                return null;
            }
            MessageManager mm = EngineMessage.get();
            throw new RQException("\"\\\"" + mm.getMessage("function.paramTypeError"));
        }
        if (o1 instanceof Sequence) {
            if (o2 == null) {
                return o1;
            }
            if (!(o2 instanceof Sequence)) {
                Sequence s2 = new Sequence(1);
                s2.add(o2);
                o2 = s2;
            }
            return ((Sequence)o1).diff((Sequence)o2, false);
        }
        return Variant.intDivide(o1, o2);
    }

    public IArray calculateAll(Context ctx) {
        IArray leftArray = this.left.calculateAll(ctx);
        IArray rightArray = this.right.calculateAll(ctx);
        return leftArray.memberIntDivide(rightArray);
    }

    public IArray calculateAll(Context ctx, IArray signArray, boolean sign) {
        IArray leftArray = this.left.calculateAll(ctx, signArray, sign);
        IArray rightArray = this.right.calculateAll(ctx, signArray, sign);
        return leftArray.memberIntDivide(rightArray);
    }
}

