/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.operator;

import com.scudata.array.BoolArray;
import com.scudata.array.IArray;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.dm.Sequence;
import com.scudata.expression.Function;
import com.scudata.expression.Move;
import com.scudata.expression.Node;
import com.scudata.expression.Operator;
import com.scudata.resources.EngineMessage;
import com.scudata.util.Variant;

public class DotOperator
extends Operator {
    public DotOperator() {
        this.priority = 18;
    }

    public void checkValidity() {
        if (this.left == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("\".\"" + mm.getMessage("operator.missingLeftOperation"));
        }
        if (this.right == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("\".\"" + mm.getMessage("operator.missingRightOperation"));
        }
        this.left.checkValidity();
        this.right.checkValidity();
    }

    public Node optimize(Context ctx) {
        if (!this.right.ifModifySequence()) {
            this.left = this.left.optimize(ctx, true);
            this.right = this.right.optimize(ctx);
            return this;
        }
        return super.optimize(ctx);
    }

    private Object _$1(Context ctx) {
        Object obj = this.left.calculate(ctx);
        if (obj instanceof Number && this.right.isSequenceFunction()) {
            int n = ((Number)obj).intValue();
            if (n > 0) {
                return new Sequence(1, n);
            }
            return new Sequence(0);
        }
        return obj;
    }

    public Object calculate(Context ctx) {
        Object leftValue = this._$1(ctx);
        if (leftValue == null) {
            return null;
        }
        for (Node right = this.right; right != null; right = right.getNextFunction()) {
            if (!right.isLeftTypeMatch(leftValue)) continue;
            right.setDotLeftObject(leftValue);
            Object result = right.calculate(ctx);
            right.releaseDotLeftObject();
            return result;
        }
        String fnName = this.right instanceof Function ? ((Function)this.right).getFunctionName() : "";
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("dot.leftTypeError", Variant.getDataType(leftValue), fnName));
    }

    public Object assign(Object value, Context ctx) {
        Object leftValue = this._$1(ctx);
        if (leftValue == null) {
            return null;
        }
        for (Node right = this.right; right != null; right = right.getNextFunction()) {
            if (!right.isLeftTypeMatch(leftValue)) continue;
            right.setDotLeftObject(leftValue);
            return right.assign(value, ctx);
        }
        String fnName = this.right instanceof Function ? ((Function)this.right).getFunctionName() : "";
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("dot.leftTypeError", Variant.getDataType(leftValue), fnName));
    }

    public Object addAssign(Object value, Context ctx) {
        Object leftValue = this._$1(ctx);
        if (leftValue == null) {
            return null;
        }
        for (Node right = this.right; right != null; right = right.getNextFunction()) {
            if (!right.isLeftTypeMatch(leftValue)) continue;
            right.setDotLeftObject(leftValue);
            return right.addAssign(value, ctx);
        }
        String fnName = this.right instanceof Function ? ((Function)this.right).getFunctionName() : "";
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("dot.leftTypeError", Variant.getDataType(leftValue), fnName));
    }

    public Object move(Move node, Context ctx) {
        Object result1 = this._$1(ctx);
        if (result1 == null) {
            return null;
        }
        this.right.setDotLeftObject(result1);
        return this.right.move(node, ctx);
    }

    public Object moveAssign(Move node, Object value, Context ctx) {
        Object result1 = this._$1(ctx);
        if (result1 == null) {
            return value;
        }
        this.right.setDotLeftObject(result1);
        return this.right.moveAssign(node, value, ctx);
    }

    public Object moves(Move node, Context ctx) {
        Object result1 = this._$1(ctx);
        if (result1 == null) {
            return null;
        }
        this.right.setDotLeftObject(result1);
        return this.right.moves(node, ctx);
    }

    public IArray calculateAll(Context ctx) {
        this.right.setLeft(this.left);
        return this.right.calculateAll(ctx);
    }

    public IArray calculateAll(Context ctx, IArray signArray, boolean sign) {
        this.right.setLeft(this.left);
        return this.right.calculateAll(ctx, signArray, sign);
    }

    public BoolArray calculateAnd(Context ctx, IArray leftResult) {
        this.right.setLeft(this.left);
        return this.right.calculateAnd(ctx, leftResult);
    }

    public int isValueRangeMatch(Context ctx) {
        this.right.setLeft(this.left);
        return this.right.isValueRangeMatch(ctx);
    }

    public IArray calculateRange(Context ctx) {
        this.right.setLeft(this.left);
        return this.right.calculateRange(ctx);
    }

    public boolean isMonotone() {
        return this.left.isMonotone() && this.right.isMonotone();
    }
}

