/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.operator;

import com.scudata.array.ConstArray;
import com.scudata.array.IArray;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.expression.Relation;
import com.scudata.resources.EngineMessage;
import com.scudata.util.Variant;

public class Equals
extends Relation {
    public Equals() {
        this.priority = 10;
    }

    public void checkValidity() {
        if (this.left == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("\"==\"" + mm.getMessage("operator.missingLeftOperation"));
        }
        if (this.right == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("\"==\"" + mm.getMessage("operator.missingRightOperation"));
        }
        this.left.checkValidity();
        this.right.checkValidity();
    }

    public Object calculate(Context ctx) {
        if (Variant.isEquals(this.left.calculate(ctx), this.right.calculate(ctx))) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public int getRelation() {
        return 1;
    }

    public int getInverseRelation() {
        return 1;
    }

    public int isValueRangeMatch(Context ctx) {
        IArray leftArray = this.left.calculateRange(ctx);
        if (leftArray == null) {
            return 0;
        }
        IArray rightArray = this.right.calculateRange(ctx);
        if (rightArray instanceof ConstArray) {
            Object value = rightArray.get(1);
            int cmp1 = Variant.compare(leftArray.get(1), value, true);
            if (cmp1 < 0) {
                int cmp2 = Variant.compare(leftArray.get(2), value, true);
                return cmp2 < 0 ? -1 : 0;
            }
            if (cmp1 == 0) {
                int cmp2 = Variant.compare(leftArray.get(2), value, true);
                return cmp2 == 0 ? 1 : 0;
            }
            return -1;
        }
        if (leftArray instanceof ConstArray) {
            Object value = leftArray.get(1);
            int cmp1 = Variant.compare(rightArray.get(1), value, true);
            if (cmp1 < 0) {
                int cmp2 = Variant.compare(rightArray.get(2), value, true);
                return cmp2 < 0 ? -1 : 0;
            }
            if (cmp1 == 0) {
                int cmp2 = Variant.compare(rightArray.get(2), value, true);
                return cmp2 == 0 ? 1 : 0;
            }
            return -1;
        }
        return 0;
    }
}

